way', 'Right Of Way', 'Ring', 'Rise', 'River', 'Riverway', 'Riviera', 'Road', 'Roads', 'Roadside', 'Roadway', 'Ronde', 'Rosebowl', 'Rotary', 'Round', 'Route', 'Row', 'Rue', 'Run', 'Service Way', 'Siding', 'Slope', 'Sound', 'Spur', 'Square', 'Stairs', 'State Highway', 'Steps', 'Strand', 'Street', 'Strip', 'Subway', 'Tarn', 'Terrace', 'Thoroughfare', 'Tollway', 'Top', 'Tor', 'Towers', 'Track', 'Trail', 'Trailer', 'Triangle', 'Trunkway', 'Turn', 'Underpass', 'Upper', 'Vale', 'Viaduct', 'View', 'Villas', 'Vista', 'Wade', 'Walk', 'Walkway', 'Way', 'Wynd',
    ];

    protected static $postcode = [
        // as per https://en.wikipedia.org/wiki/Postcodes_in_Australia
        // NSW
        '1###',
        '20##', '21##', '22##', '23##', '24##', '25##',
        '2619', '262#', '263#', '264#', '265#', '266#', '267#', '268#', '269#', '27##', '28##',
        '292#', '293#', '294#', '295#', '296#', '297#', '298#', '299#',
        // ACT
        '02##',
        '260#', '261#',
        '290#', '291#', '2920',
        // VIC
        '3###',
        '8###',
        // QLD
        '4###',
        '9###',
        // SA
        '5###',
        // WA
        '6###',
        // TASPK     Fs[jBݔE  E    Faker/Provider/ko_KR/Person.phpnu [        ected static $state = [
        'Australian Capital Territory', 'New South Wales', 'Northern Territory', 'Queensland', 'South Australia', 'Tasmania', 'Victoria', 'Western Australia',
    ];

    protected static $stateAbbr = [
        'ACT', 'NSW', 'NT', 'QLD', 'SA', 'TAS', 'VIC', 'WA',
    ];

    protected static $streetAddressFormats = [
        '{{buildingNumber}} {{streetName}}',
        '{{buildingNumber}}{{buildingLetter}} {{streetName}}',
        '{{secondaryAddress}} {{buildingNumber}} {{streetName}}',
    ];

    protected static $secondaryAddressFormats = [
        'Apt. ###',
        'Flat ##',
        'Suite ###',
        'Unit ##',
        'Level #',
        '### /',
        '## /',
        '# /',
    ];

    /**
     * Returns a sane building letter
     *
     * @example B
     */
    public static function buildingLetter()
    {
        return static::toUpper(static::randomElement(static::$buildingLetters));
    }

    /**
     * Returns a sane city prefix
     *
     * @example West
     */
    public static function cityPrefix()
    {
        return static::randomElement(static::$cityPrefix);
    }

    /**
     * Returns a sane street suffix
     *
     * @example Beach
     */
    public static function streetSuffix()
    {
        return static::randomElement(static::$streetSuffix);
    }

    /**
     * Returns a sane state
     *
     * @example New South Wales
     */
    public static function state()
    {
        return static::randomElement(static::$state);
    }
}
PK     Fs[jBݔE  E    Faker/Provider/ko_KR/Person.phpnu [        <?php

namespace Faker\Provider\ko_KR;

class Person extends \Faker\Provider\Person
{
    /**
     * This provider uses wikipedia's top Korean last names. These cover more than 90% of Korean population.
     */
    protected static $maleNameFormats = [
        '{{lastName}}{{firstNameMale}}',
    ];

    protected static $femaleNameFormats = [
        '{{lastName}}{{firstNameFemale}}',
    ];

    /**
     * {@link} http://ko.wikipedia.org/wiki/%ED%95%9C%EA%B5%AD%EC%9D%98_%EC%84%B1%EC%94%A8%EC%99%80_%EC%9D%B4%EB%A6%84#.EC.8B.9C.EB.8C.80.EB.B3.84_.EA.B0.80.EC.9E.A5_.ED.9D.94.ED.95.9C_.EC.9D.B4.EB.A6.84_10.EC.84.A0.28.E9.81.B8.29
     */
    protected static $firstNameMale = [
        '건우', '건호', '경석', '경수', '경춘', '경환', '광수', '광현', '구범', '규산', '기수', '남수', '남호', '대선', '대수', '도윤',
        '도현', '동윤', '동하', '동현', '명식', '명호', '문용', '문창', '민석', '민성', '민수', '민재', '민준', '민철', '민환', '병철',
        '병호', '상선', '상수', '상우', '상욱', '상준', '상철', '상현', '상호', '상훈', '서준', '서호', '선엽', '성곤', '성령', '성민',
        '성수', '성진', '성현', '성호', '성훈', '수원', '승민', '승현', '승호', '시우', '영길', '영수', '영식', '영일', '영진', '영철',
        '영하', '영호', '영환', '예준', '용태', '용환', '용훈', '우진', '원준', '원진', '원희', '은성', '은택', '인규', '재윤', '재철',
        '재혁', '재현', '재호', '