(static::$lastName);
    }

    /**
     * @example 'Mrs.'
     *
     * @param string|null $gender 'male', 'female' or null for any
     *
     * @return string
     */
    public function title($gender = null)
    {
        if ($gender === static::GENDER_MALE) {
            return static::titleMale();
        }

        if ($gender === static::GENDER_FEMALE) {
            return static::titleFemale();
        }

        return $this->generator->parse(static::randomElement(static::$titleFormat));
    }

    /**
     * @example 'Mr.'
     *
     * @return string
     */
    public static function titleMale()
    {
        return static::randomElement(static::$titleMale);
    }

    /**
     * @example 'Mrs.'
     *
     * @return string
     */
    public static function titleFemale()
    {
        return static::randomElement(static::$titleFemale);
    }
}
PK     YFs[s`E,  ,    Faker/Provider/Biased.phpnu [        <?php

namespace Faker\Provider;

class Biased extends Base
{
    /**
     * Returns a biased integer between $min and $max (both inclusive).
     * The distribution depends on $function.
     *
     * The algorithm creates two doubles, xPK     YFs[%K      Faker/Provider/mn_MN/Person.phpnu [        on for x is greater than or equal to y. If this is
     * the case the number is accepted and x is mapped to the appropriate integer
     * between $min and $max. Otherwise two new doubles are created until the pair
     * is accepted.
     *
     * @param int      $min      Minimum value of the generated integers.
     * @param int      $max      Maximum value of the generated integers.
     * @param callable $function A function mapping x ∈ [0, 1] onto a double ∈ [0, 1]
     *
     * @return int An integer between $min and $max.
     */
    public function biasedNumberBetween($min = 0, $max = 100, $function = 'sqrt')
    {
        do {
            $x = mt_rand() / mt_getrandmax();
            $y = mt_rand() / (mt_getrandmax() + 1);
        } while (call_user_func($function, $x) < $y);

        return (int) floor($x * ($max - $min + 1) + $min);
    }

    /**
     * 'unbiased' creates an unbiased distribution by giving
     * each value the same value of one.
     *
     * @return int
     */
    protected static function unbiased()
    {
        return 1;
    }

    /**
     * 'linearLow' favors lower numbers. The probability decreases
     * in a linear fashion.
     *
     * @return int
     */
    protected static function linearLow($x)
    {
        return 1 - $x;
    }

    /**
     * 'linearHigh' favors higher numbers. The probability increases
     * in a linear fashion.
     *
     * @return int
     */
    protected static function linearHigh($x)
    {
        return $x;
    }
}
PK     YFs[%K      Faker/Provider/mn_MN/Person.phpnu [        <?php

namespace Faker\Provider\mn_MN;

class Person extends \Faker\Provider\Person
{
    /**
     * @see http://ner.query.mn/son
     */
    protected static $firstNameMale = [
        'Агь-Од', 'Адархидай', 'Адхираг', 'Ажай', 'Аз-Оргил', 'Алаг-Наяа', 'Алахуш-дигитхури', 'Алдиэр', 'Алтаннар', 'Алхуй', 'Алчи', 'Алчидай', 'Амал', 'Амбагай', 'Амин-Эрдэнэ', 'Анхлан', 'Арачиан', 'Аргасун', 'Арин', 'Арулад', 'Архай Хасар', 'Аучу', 'Ачиг-Чирүн', 'Ачиг-Ширүн', 'Аша-хамбу',
        'Баарьдай', 'Багу-Чорхи', 'Байшинхор', 'Бала', 'Бала-Чэрби', 'Балхачи', 'Барула', 'Баруладай', 'Бахажи', 'Баярмагнай', 'Бодончар', 'Боржигидай', 'Боролдай', 'Боролдайсуялби', 'Бужир', 'Буйраг', 'Булуган', 'Бурьбулчиру', 'Буту', 'Буха-Төмөр', 'Бухатай', 'Бухату', 'Бучаран', 'Бэсүдэй', 'Бүлтэчү', 'Бүри', 'Бүри-Бөхө', 'Бүрибөх', 'Бүхэдэй', 'Бөгэн',
        'Гилүгэтэй', 'Гэнигэдэй', 'Гүнгуа', 'Гүр-Хан', 'Гүчүгүр', 'Гүчүд',
        'Дайр', 'Дайр-Үсүн', 'Далдурхан', 'Дамача', 'Дарбай', 'Даридай', 'Даун', 'Добу', 'Доголдай', 'Доголху', 'Додай', 'Дорибөхө', 'Дува', 'Дэгэй', 'Дэй-Сэцэн', 'Дөрбуй', 'Дөрбэй',
        'Егү', 'Еди-Тоблуг', 'Есүнхэй', 'Ехэй-Хонтагар',
        'Жажирадай', 'Жалалдин', 'Жали', 'Жалибуха', 'Жалман', 'Жарчиудай', 'Жатай', 'Жаурьдай', 'Жаха-Хамбу', 'Жахахамбу', 'Жибгэ', 'Жибэгэ', 'Жидай', 'Жидэр', 'Жихүр', 'Жубхан', 'Жунсо', 'Жэгэй', 'Жэхү', 'Жэүн', 'Жүрчидэй',
        'Зочи', 'Зүтгэлбөх',
        'Ивгээл', 'Идухадай', 'Идүүд', 'Илаху', 'Илугай', 'Инал', 'Иналч', 'Инанча', 'Итүргэн', 'Их-Нэүрин', 'Их-Чэрэн', 'Ихнүдэн', 'Ихчирэн',
        'Кишлиг',
        'Лаблах',
        'Мангай', 'Мангудай', 'Масхуд', 'Молор', 'Молор эрдэнэ', 'Моричи', 'Мороха', 'Мулхалху', 'Мухулай буюу Мухули', 'Мэгэтү', 'Мэгүжин', 'Мэлиг', 'Мэнгитү', 'Мэнлиг', 'Мэнэн', 'Мүгэ', 'Мүлхэ-тотаг', 'Мүнтүүр', 'Мөчи',
        'Нарийн-гэгээн', 'Наринтоорил', 'Наху', 'Ноёгидай', 'Нэүдэйн Цагаан',
        'Огда', 'Оготор', 'Олар', 'Олдхар', 'Онгууд', 'Оронар', 'Оронартай', 'Охинбархаг',
        'Өлэбэг', 'Өнгүр', 'Өэлэн',
        'Саль-Хачау', 'Саргай', 'Сача-Бэхи', 'Сачуур', 'Сорхату', 'Сорхоншар', 'Сохо-Сэцэн', 'Сэмсэчүлэ', 'Сэцэ-Домог', 'Сэчиүр', 'Сэчэ-Бэхи', 'Сүбэхэй', 'Сүйхэтү', 'Сүхэхэй', 'Сүхэхэй-Жаун', 'Сүхэхэй-Жэүн', 'Сөнид',
        'Тай-Төмөр', 'Тайчар', 'Тайчиудай', 'Тайчу', 'Тамача', 'Тамир', 'Таргудай', 'Тататунга', 'Тобуха', 'Тогочар', 'Тогтоа', 'Тогучар', 'Тодойн-Гэрти', 'Тодсаха', 'Толун', 'Торбиташ', 'Торголжин', 'Торойн отчигон', 'Тугудай', 'Тунбинай', 'Тунхуйдай', 'Тусах', 'Туху', 'Тэв тэнгэр', 'Тэлэгэтү', 'Тэмүжин-Үгэ', 'Тэмүжинүгэ', 'Тэрхэг', 'Түгэ', 'Түгэ-Маха',
        'Удутай', 'Уйгуртай', 'Уруудай', 'Усун', 'Ухуна',
        'Үгэ', 'Үгэлэн', 'Үнгүр',
        'Хаатай Дармала', 'Хабич', 'Хабтурхас', 'Хадиги', 'Хайду', 'Халжа', 'Халиудар', 'Хан-Эрдэнэ', 'Хангиадай', 'Ханхархан', 'Хар-Хадаан', 'Хараудар', 'Харачар', 'Хархай', 'Хархалзан', 'Хархирүгэ', 'Харчу', 'Хауран', 'Хачи-Хүлүг', 'Хачиу', 'Хачиун', 'Хачула', 'Хаши', 'Хашин', 'Хингиадай', 'Хиратай', 'Хирилтуг', 'Хирмау', 'Хишилиг', 'Ходун',
  