 */
    public function toArray(): array
    {
        $data = [
            'type' => 'websocket',
            'uri' => $this->id,
            'content-type' => $this->getContentType(),
        ];

        if (!empty($this->getHeaders())) {
            $data['headers'] = $this->getHeaders();
        }

        return $data;
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function getContentType(): string
    {
        return $this->contentType;
    }

    /**
     * @return $this
     */
    public function setContentType(string $contentType): self
    {
        $this->contentType = $contentType;

        return $this;
    }

    public function getHeaders(): array
    {
        return $this->headers;
    }

    /**
     * @return $this
     */
    public function addHeader(string $key, string $value): self
    {
        $this->headers[$key] = $value;

        return $this;
    }

    /**
     * @return $this
     */
    public function setHeaders(array $headers): self
    {
        $this->headers = $headers;

        return $this;
    }
}
PK     t[	q8T      Voice/Endpoint/App.phpnu [        <?php

/PK     AFs[!p  p     Faker/Provider/nb_NO/Company.phpnu [        age, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice\Endpoint;

class App implements EndpointInterface
{
    public function __construct(protected string $id)
    {
    }

    public static function factory(string $user): App
    {
        return new App($user);
    }

    /**
     * @return array{type: string, user: string}
     */
    public function jsonSerialize(): array
    {
        return $this->toArray();
    }

    /**
     * @return array{type: string, user: string}
     */
    public function toArray(): array
    {
        return [
            'type' => 'app',
            'user' => $this->id,
        ];
    }

    public function getId(): string
    {
        return $this->id;
    }
}
PK     t[rWq    "  Voice/Endpoint/EndpointFactory.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice\Endpoint;

use RuntimeException;
use Vonage\Entity\Factory\FactoryInterface;

class EndpointFactory implements FactoryInterface
{

    public function create(array $data): ?EndpointInterface
    {
        return match ($data['type']) {
            'app' => App::factory($data['user']),
            'phone' => Phone::factory($data['number'], $data),
            'sip' => SIP::factory($data['uri'], $data),
            'vbc' => VBC::factory($data['extension']),
            'websocket' => Websocket::factory($data['uri'], $data),
            default => throw new RuntimeException('Unknown endpoint type'),
        };
    }
}
PK     t[_      Voice/Endpoint/VBC.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice\Endpoint;

class VBC implements EndpointInterface
{
    public function __construct(protected string $id)
    {
    }

    public static function factory(string $extension): VBC
    {
        return new VBC($extension);
    }

    /**
     * @return array{type: string, user: string}
     */
    public function jsonSerialize(): array
    {
        return $this->toArray();
    }

    /**
     * @return array{type: string, user: string}
     */
    public function toArray(): array
    {
        return [
            'type' => 'vbc',
            'extension' => $this->id,
        ];
    }

    public function getId(): string
    {
        return $this->id;
    }
}
PK     t[$*      Voice/Endpoint/Phone.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice\Endpoint;

use function array_key_exists;

class Phone implements EndpointInterface
{
    /**
     * @var ?string
     */
    protected $ringbackTone;

    /**
     * @var ?string
     */
    protected $url;

    public function __construct(protected string $id, protected ?string $dtmfAnswer = null)
    {
    }

    public static function factory(string $number, array $data): Phone
    {
        $endpoint = new Phone($number);

        if (array_key_exists('dtmfAnswer', $data)) {
            $endpoint->setDtmfAnswer($data['dtmfAnswer']);
        }

        if (array_key_exists('onAnswer', $data)) {
            $endpoint->setUrl($data['onAnswer']['url']);

            if (array_key_exists('ringbackTone', $data['onAnswer'])) {
                $endpoint->setRingbackTone($data['onAnswer']['ringbackTone']);
            }

            // Legacy name for ringbackTone
            if (array_key_exists('ringback', $data['onAnswer'])) {
                $endpoint->setRingbackTone($data['onAnswer']['ringback']);
            }
        }

        return $endpoint;
    }

    public function getDtmfAnswer(): ?string
    {
        return $this->dtmfAnswer;
    }

    /**
     * @return array{type: string, number: string, dtmfAnswer?: string}
     */
    public function jsonSerialize(): array
    {
        return $this->toArray();
    }

    /**
     * @return $this
     */
    public function setDtmfAnswer(string $dtmf): self
    {
        $this->dtmfAnswer = $dtmf;

        return $this;
    }

    /**
     * @return array{type: string, number: string, dtmfAnswer?: string}
     */
    public function toArray(): array
    {
        $data = [
            'type' => 'phone',
            'number' => $this->id,
        ];

        if (null !== $this->getDtmfAnswer()) {
            $data['dtmfAnswer'] = $this->getDtmfAnswer();
        }

        if (null !== $this->getUrl()) {
            $data['onAnswer']['url'] = $this->getUrl();

            if (null !== $this->getRingbackTone()) {
                $data['onAnswer']['ringbackTone'] = $this->getRingbackTone();
            }
        }

        return $data;
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function getRingbackTone(): ?string
    {
        return $this->ringbackTone;
    }

    /**
     * @return $this
     */
    public function setRingbackTone(string $ringbackTone): self
    {
        $this->ringbackTone = $ringbackTone;

        return $this;
    }

    public function getUrl(): ?string
    {
        return $this->url;
    }

    /**
     * @return $this
     */
    public function setUrl(string $url): self
    {
        $this->url = $url;
        return $this;
    }
}
PK     t[Rh      Voice/CallFactory.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice;

use Exception;
use Vonage\Entity\Factory\FactoryInterface;

class CallFactory implements FactoryInterface
{
    /**
     * @throws Exception
     */
    public function create(array $data): Call
    {
        return new Call($data);
    }
}
PK     t[       Voice/Call/Inbound.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice\Call;

/**
 * @deprecated This objects are no longer viable and will be removed in a future version
 */
class Inbound
{
}
PK     t[9x	  	    Voice/Call/Call.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice\Call;

use Vonage\Client\Request\AbstractRequest;

use function is_null;

/**
 * @deprecated This objects are no longer viable and will be removed in a future version
 */
class Call extends AbstractRequest
{
    /**
     * @param $url
     * @param $to
     * @param $from
     */
    public function __construct($url, $to, $from = null)
    {
        $this->params['answer_url'] = $url;
        $this->params['to'] = $to;

        if (!is_null($from)) {
            $this->params['from'] = $from;
        }
    }

    /**
     * @param $url
     * @param $method
     *
     * @return $this
     */
    public function setAnswer($url, $method = null): Call
    {
        $this->params['answer_url'] = $url;

        if (!is_null($method)) {
            $this->params['answer_method'] = $method;
        } else {
            unset($this->params['answer_method']);
        }

        return $this;
    }

    /**
     * @param $url
     * @param $method
     *
     * @return $this
     */
    public function setError($url, $method = null): Call
    {
        $this->params['error_url'] = $url;
        if (!is_null($method)) {
            $this->params['error_method'] = $method;
        } else {
            unset($this->params['error_method']);
        }

        return $this;
    }

    /**
     * @param $url
     * @param $method
     *
     * @return $this
     */
    public function setStatus($url, $method = null): Call
    {
        $this->params['status_url'] = $url;
        if (!is_null($method)) {
            $this->params['status_method'] = $method;
        } else {
            unset($this->params['status_method']);
        }

        return $this;
    }

    /**
     * @param bool $hangup
     * @param $timeout
     *
     * @return $this
     */
    public function setMachineDetection($hangup = true, $timeout = null): Call
    {
        $this->params['machine_detection'] = ($hangup ? 'hangup' : 'true');
        if (!is_null($timeout)) {
            $this->params['machine_timeout'] = (int)$timeout;
        } else {
            unset($this->params['machine_timeout']);
        }

        return $this;
    }

    public function getURI(): string
    {
        return '/call/json';
    }
}
PK     t[éfL  L    Voice/Webhook/Error.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice\Webhook;

use DateTimeImmutable;
use Exception;

class Error
{
    /**
     * @var string
     */
    protected $conversationUuid;

    /**
     * @var string
     */
    protected $reason;

    /**
     * @var DateTimeImmutable
     */
    protected $timestamp;

    /**
     * @throws Exception
     */
    public function __construct(array $event)
    {
        $this->conversationUuid = $event['conversation_uuid'];
        $this->reason = $event['reason'];
        $this->timestamp = new DateTimeImmutable($event['timestamp']);
    }

    public function getConversationUuid(): string
    {
        return $this->conversationUuid;
    }

    public function getReason(): string
    {
        return $this->reason;
    }

    public function getTimestamp(): DateTimeImmutable
    {
        return $this->timestamp;
    }
}
PK     t[q       Voice/Webhook/Notification.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice\Webhook;

use DateTimeImmutable;
use Exception;

use function is_string;
use function json_decode;

class Notification
{
    /**
     * @var array<string, mixed>
     */
    protected $payload;

    /**
     * @var string
     */
    protected $conversationUuid;

    /**
     * @var DateTimeImmutable
     */
    protected $timestamp;

    /**
     * @throws Exception
     */
    public function __construct(array $data)
    {
        if (is_string($data['payload'])) {
            $data['payload'] = json_decode($data['payload'], true);
        }

        $this->payload = $data['payload'];
        $this->conversationUuid = $data['conversation_uuid'];
        $this->timestamp = new DateTimeImmutable($data['timestamp']);
    }

    public function getPayload(): array
    {
        return $this->payload;
    }

    public function getConversationUuid(): string
    {
        return $this->conversationUuid;
    }

    public function getTimestamp(): DateTimeImmutable
    {
        return $this->timestamp;
    }
}
PK     t[;j
P  P    Voice/Webhook/Transfer.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice\Webhook;

use DateTimeImmutable;
use Exception;

class Transfer
{
    /**
     * @var string
     */
    protected $conversationUuidFrom;

    /**
     * @var string
     */
    protected $conversationUuidTo;

    /**
     * @var string
     */
    protected $uuid;

    /**
     * @var DateTimeImmutable
     */
    protected $timestamp;

    /**
     * @throws Exception
     */
    public function __construct(array $event)
    {
        $this->conversationUuidFrom = $event['conversation_uuid_from'];
        $this->conversationUuidTo = $event['conversation_uuid_to'];
        $this->uuid = $event['uuid'];
        $this->timestamp = new DateTimeImmutable($event['timestamp']);
    }

    public function getConversationUuidFrom(): string
    {
        return $this->conversationUuidFrom;
    }

    public function getConversationUuidTo(): string
    {
        return $this->conversationUuidTo;
    }

    public function getUuid(): string
    {
        return $this->uuid;
    }

    public function getTimestamp(): DateTimeImmutable
    {
        return $this->timestamp;
    }
}
PK     t[	&      Voice/Webhook/Record.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice\Webhook;

use DateTimeImmutable;
use Exception;

class Record
{
    /**
     * @var DateTimeImmutable
     */
    protected $startTime;

    /**
     * @var string
     */
    protected $recordingUrl;

    /**
     * @var int
     */
    protected $size;

    /**
     * @var string
     */
    protected $recordingUuid;

    /**
     * @var DateTimeImmutable
     */
    protected $endTime;

    /**
     * @var string
     */
    protected $conversationUuid;

    /**
     * @var DateTimeImmutable
     */
    protected $timestamp;

    /**
     * @throws Exception
     */
    public function __construct(array $event)
    {
        $this->startTime = new DateTimeImmutable($event['start_time']);
        $this->endTime = new DateTimeImmutable($event['end_time']);
        $this->timestamp = new DateTimeImmutable($event['timestamp']);
        $this->recordingUrl = $event['recording_url'];
        $this->recordingUuid = $event['recording_uuid'];
        $this->conversationUuid = $event['conversation_uuid'];
        $this->size = (int)$event['size'];
    }

    public function getStartTime(): DateTimeImmutable
    {
        return $this->startTime;
    }

    public function getRecordingUrl(): string
    {
        return $this->recordingUrl;
    }

    public function getSize(): int
    {
        return $this->size;
    }

    public function getRecordingUuid(): string
    {
        return $this->recordingUuid;
    }

    public function getEndTime(): DateTimeImmutable
    {
        return $this->endTime;
    }

    public function getConversationUuid(): string
    {
        return $this->conversationUuid;
    }

    public function getTimestamp(): DateTimeImmutable
    {
        return $this->timestamp;
    }
}
PK     t[0 h  h    Voice/Webhook/Answer.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice\Webhook;

class Answer
{
    /**
     * @var string
     */
    protected $conversationUuid;

    /**
     * @var string
     */
    protected $from;

    /**
     * @var string
     */
    protected $to;

    /**
     * @var string
     */
    protected $uuid;

    public function __construct(array $event)
    {
        $this->from = $event['from'];
        $this->to = $event['to'];
        $this->uuid = $event['uuid'] ?? $event['call_uuid'];
        $this->conversationUuid = $event['conversation_uuid'];
    }

    public function getConversationUuid(): string
    {
        return $this->conversationUuid;
    }

    public function getFrom(): string
    {
        return $this->from;
    }

    public function getTo(): string
    {
        return $this->to;
    }

    public function getUuid(): string
    {
        return $this->uuid;
    }
}
PK     t[&m9(l  l    Voice/Webhook/Input.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice\Webhook;

use DateTimeImmutable;
use Exception;

use function is_string;
use function json_decode;

class Input
{
    /**
     * @var array
     */
    protected $speech;

    /**
     * @var array
     */
    protected $dtmf;

    /**
     * @var string
     */
    protected $from;

    /**
     * @var string
     */
    protected $to;

    /**
     * @var string
     */
    protected $uuid;

    /**
     * @var string
     */
    protected $conversationUuid;

    /**
     * @var DateTimeImmutable
     */
    protected $timestamp;

    /**
     * @throws Exception
     */
    public function __construct(array $data)
    {
        // GET requests push this in as a string
        if (is_string($data['speech'])) {
            $data['speech'] = json_decode($data['speech'], true);
        }

        $this->speech = $data['speech'];

        // GET requests push this in as a string
        if (is_string($data['dtmf'])) {
            $data['dtmf'] = json_decode($data['dtmf'], true);
        }

        $this->dtmf = $data['dtmf'];
        $this->to = $data['to'];
        $this->from = $data['from'];
        $this->uuid = $data['uuid'];
        $this->conversationUuid = $data['conversation_uuid'];
        $this->timestamp = new DateTimeImmutable($data['timestamp']);
    }

    public function getSpeech(): array
    {
        return $this->speech;
    }

    public function getDtmf(): array
    {
        return $this->dtmf;
    }

    public function getFrom(): string
    {
        return $this->from;
    }

    public function getTo(): string
    {
        return $this->to;
    }

    public function getUuid(): string
    {
        return $this->uuid;
    }

    public function getConversationUuid(): string
    {
        return $this->conversationUuid;
    }

    public function getTimestamp(): DateTimeImmutable
    {
        return $this->timestamp;
    }
}
PK     t[pHQ9      Voice/Webhook/Factory.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice\Webhook;

use Exception;
use InvalidArgumentException;
use Vonage\Webhook\Factory as WebhookFactory;

use function array_diff;
use function array_key_exists;
use function array_keys;
use function count;

class Factory extends WebhookFactory
{
    /**
     * @throws Exception
     *
     * @return mixed|Answer|Error|Event|Input|Notification|Record|Transfer
     */
    public static function createFromArray(array $data)
    {
        if (array_key_exists('status', $data)) {
            return new Event($data);
        }

        // Answer webhooks have no defining type other than length and keys
        if (count($data) === 4 && array_diff(array_keys($data), ['to', 'from', 'uuid', 'conversation_uuid']) === []) {
            return new Answer($data);
        }

        if (array_key_exists('type', $data) && $data['type'] === 'transfer') {
            return new Transfer($data);
        }

        if (array_key_exists('recording_url', $data)) {
            return new Record($data);
        }

        if (array_key_exists('reason', $data)) {
            return new Error($data);
        }

        if (array_key_exists('payload', $data)) {
            return new Notification($data);
        }

        if (array_key_exists('speech', $data) || array_key_exists('dtmf', $data)) {
            return new Input($data);
        }

        throw new InvalidArgumentException('Unable to detect incoming webhook type');
    }
}
PK     t[Y~8      Voice/Webhook/Event.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice\Webhook;

use DateTimeImmutable;
use Exception;

use function array_key_exists;
use function is_null;

class Event
{
    public const STATUS_STARTED = 'started';
    public const STATUS_RINGING = 'ringing';
    public const STATUS_ANSWERED = 'answered';
    public const STATUS_BUSY = 'busy';
    public const STATUS_CANCELLED = 'cancelled';
    public const STATUS_UNANSWERED = 'unanswered';
    public const STATUS_DISCONNECTED = 'disconnected';
    public const STATUS_REJECTED = 'rejected';
    public const STATUS_FAILED = 'failed';
    public const STATUS_HUMAN = 'human';
    public const STATUS_MACHINE = 'machine';
    public const STATUS_TIMEOUT = 'timeout';
    public const STATUS_COMPLETED = 'completed';

    /**
     * @var string
     */
    protected $conversationUuid;

    /**
     * @var string
     */
    protected $detail;

    /**
     * @var string
     */
    protected $direction;

    /**
     * @var ?string
     */
    protected $duration;

    /**
     * @var ?DateTimeImmutable
     */
    protected $endTime;

    /**
     * @var string
     */
    protected $from;

    /**
     * @var ?string
     */
    protected $network;

    /**
     * @var ?string
     */
    protected $price;

    /**
     * @var ?string
     */
    protected $rate;

    /**
     * @var string
     */
    protected $status;

    /**
     * @var ?DateTimeImmutable
     */
    protected $startTime;

    /**
     * @var DateTimeImmutable
     */
    protected $timestamp;

    /**
     * @var string
     */
    protected $to;

    /**
     * @var string
     */
    protected $uuid;

    /**
     * @throws Exception
     */
    public function __construct(array $event)
    {
        $this->from = $event['from'] ?? null;
        $this->to = $event['to'];
        $this->uuid = $event['uuid'] ?? $event['call_uuid'];
        $this->conversationUuid = $event['conversation_uuid'];
        $this->status = $event['status'];
        $this->direction = $event['direction'];
        $this->timestamp = new DateTimeImmutable($event['timestamp']);
        $this->rate = $event['rate'] ?? null;
        $this->network = $event['network'] ?? null;
        $this->duration = $event['duration'] ?? null;
        $this->price = $event['price'] ?? null;

        if (array_key_exists('start_time', $event) && !is_null($event['start_time'])) {
            $this->startTime = new DateTimeImmutable($event['start_time']);
        }

        if (array_key_exists('end_time', $event)) {
            $this->endTime = new DateTimeImmutable($event['end_time']);
        }

        $this->detail = $event['detail'] ?? null;
    }

    public function getConversationUuid(): string
    {
        return $this->conversationUuid;
    }

    /**
     * Returns additional details on the event, if available
     * Not all events contain this field, so it may be null.
     */
    public function getDetail(): ?string
    {
        return $this->detail;
    }

    public function getDirection(): string
    {
        return $this->direction;
    }

    public function getFrom(): ?string
    {
        return $this->from;
    }

    public function getStatus(): string
    {
        return $this->status;
    }

    public function getTimestamp(): DateTimeImmutable
    {
        return $this->timestamp;
    }

    public function getTo(): string
    {
        return $this->to;
    }

    public function getUuid(): string
    {
        return $this->uuid;
    }

    public function getNetwork(): ?string
    {
        return $this->network;
    }

    public function getRate(): ?string
    {
        return $this->rate;
    }

    public function getStartTime(): ?DateTimeImmutable
    {
        return $this->startTime;
    }

    public function getEndTime(): ?DateTimeImmutable
    {
        return $this->endTime;
    }

    public function getDuration(): ?string
    {
        return $this->duration;
    }

    public function getPrice(): ?string
    {
        return $this->price;
    }
}
PK     t[      Voice/Call.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice;

use DateTime;
use Exception;
use Vonage\Entity\Hydrator\ArrayHydrateInterface;
use Vonage\Voice\Endpoint\EndpointFactory;
use Vonage\Voice\Endpoint\EndpointInterface;

use function array_key_exists;

class Call implements ArrayHydrateInterface
{
    /**
     * @var string
     */
    protected $conversationUuid;

    /**
     * @var string
     */
    protected $direction;

    /**
     * @var string
     */
    protected $duration;

    /**
     * @var DateTime
     */
    protected $endTime;

    /**
     * @var EndpointInterface
     */
    protected $from;

    /**
     * @var string
     */
    protected $network;

    /**
     * @var string
     */
    protected $price;

    /**
     * @var string
     */
    protected $rate;

    /**
     * @var DateTime
     */
    protected $startTime;

    /**
     * @var string
     */
    protected $status;

    /**
     * @var EndpointInterface
     */
    protected $to;

    /**
     * @var string
     */
    protected $uuid;

    /**
     * @throws Exception
     */
    public function __construct(array $data = [])
    {
        if (!empty($data)) {
            $this->fromArray($data);
        }
    }

    /**
     * @throws Exception
     */
    public function fromArray(array $data): void
    {
        if (array_key_exists('to', $data)) {
            $to = $data['to'][0] ?? $data['to'];
            $this->to = (new EndpointFactory())->create($to);
        }

        if (array_key_exists('from', $data)) {
            $from = $data['from'][0] ?? $data['from'];
            $this->from = (new EndpointFactory())->create($from);
        }

        $this->uuid = $data['uuid'];
        $this->conversationUuid = $data['conversation_uuid'];
        $this->status = $data['status'];
        $this->direction = $data['direction'];
        $this->rate = $data['rate'] ?? null;
        $this->duration = $data['duration'] ?? null;
        $this->price = $data['price'] ?? null;
        $this->startTime = new DateTime($data['start_time']);
        $this->endTime = new DateTime($data['end_time']);
        $this->network = $data['network'] ?? null;
    }

    public function getUuid(): string
    {
        return $thi