entException('error settings are required when setting am error text prompt.');
        }

        foreach ($prompts['errors'] as $errorPromptKey => $errorPromptData) {
            if (!array_key_exists('text', $errorPromptData)) {
                throw new InvalidArgumentException('text is required when setting errPK     AFs[-I      Faker/Provider/th_TH/Color.phpnu [        TED_ERROR_KEYS[$prompts['type']];

            if (!in_array($errorPromptKey, $permittedErrors, true)) {
                throw new InvalidArgumentException('incorrect error type for prompt.');
            }
        }

        $this->prompts = $prompts;
    }

    /**
     * @return ?array
     */
    public function getVoice(): array
    {
        return $this->voice;
    }

    public function setVoice(array $settings): void
    {
        foreach (array_keys($settings) as $settingKey) {
            if (!in_array($settingKey, self::PERMITTED_VOICE_KEYS, true)) {
                throw new InvalidArgumentException($settingKey . ' did not fall under permitted voice settings');
            }
        }

        $this->voice = $settings;
    }

    public function toNCCOArray(): arPK     AFs[v֪>x  >x    Faker/Provider/nb_NO/Person.phpnu [         => $this->getAmount()
        ];

        if (isset($this->currency)) {
            $data['currency'] = $this->getCurrency();
        }

        if (isset($this->eventUrl)) {
            $data['eventUrl'] = $this->getEventUrl();
        }

        if (isset($this->prompts)) {
            $data['prompts'] = $this->getPrompts();
        }

        if (isset($this->voice)) {
            $data['voice'] = $this->getVoice();
        }

        return $data;
    }

    public function jsonSerialize(): array
    {
        return $this->toNCCOArray();
    }

    public static function factory(array $data): Pay
    {
        $pay = new self();

        if (array_key_exists('amount', $data)) {
            $pay->setAmount($data['amount']);
        } else {
            throw new InvalidArgumentException('Amount is required for this action.');
        }

        if (array_key_exists('currency', $data)) {
            $pay->setCurrency($data['currency']);
        }

        if (array_key_exists('eventUrl', $data)) {
            $pay->setEventUrl($data['eventUrl']);
        }

        if (array_key_exists('prompts', $data)) {
            $pay->setPrompts($data['prompts']);
        }

        if (array_key_exists('voice', $data)) {
            $pay->setVoice($data['voice']);
        }

        return $pay;
    }
}
PK     t[.  .    Voice/NCCO/Action/Connect.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice\NCCO\Action;

use InvalidArgumentException;
use Vonage\Voice\Endpoint\EndpointInterface;
use Vonage\Voice\VoiceObjects\AdvancedMachineDetection;
use Vonage\Voice\Webhook;

class Connect implements ActionInterface
{
    public const EVENT_TYPE_SYNCHRONOUS = 'synchronous';
    public const MACHINE_CONTINUE = 'continue';
    public const MACHINE_HANGUP = 'hangup';

    protected ?string $from = '';
    protected ?string $eventType = '';

    protected int $timeout = 0;
    protected int $limit = 0;
    protected $machineDetection = '';
    protected ?Webhook $eventWebhook = null;
    protected ?string $ringbackTone = '';
    protected ?AdvancedMachineDetection $advancedMachineDetection = null;

    public function __construct(protected EndpointInterface $endpoint)
    {
    }

    public static function factory(EndpointInterface $endpoint): Connect
    {
        return new Connect($endpoint);
    }

    /**
     * @return array|mixed
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return $this->toNCCOArray();
    }

    public function toNCCOArray(): array
    {
        $data = [
            'action' => 'connect',
            'endpoint' => [$this->endpoint->toArray()],
        ];

        if ($this->getTimeout()) {
            $data['timeout'] = $this->getTimeout();
        }

        if ($this->getLimit()) {
            $data['limit'] = $this->getLimit();
        }

        if ($this->getMachineDetection()) {
            $data['machineDetection'] = $this->getMachineDetection();
        }

        if ($this->getAdvancedMachineDetection()) {
            $data['advancedMachineDetection'] = $this->getAdvancedMachineDetection()->toArray();
        }

        $from = $this->getFrom();

        if ($from) {
            $data['from'] = $from;
        }

        $eventType = $this->getEventType();

        if ($eventType) {
            $data['eventType'] = $eventType;
        }

        $eventWebhook = $this->getEventWebhook();

        if ($eventWebhook) {
            $data['eventUrl'] = [$eventWebhook->getUrl()];
            $data['eventMethod'] = $eventWebhook->getMethod();
        }

        $ringbackTone = $this->getRingbackTone();

        if ($ringbackTone) {
            $data['ringbackTone'] = $ringbackTone;
        }

        return $data;
    }

    public function getFrom(): ?string
    {
        return $this->from;
    }

    /**
     * @return $this
     */
    public function setFrom(string $from): self
    {
        $this->from = $from;

        return $this;
    }

    public function getEventType(): ?string
    {
        return $this->eventType;
    }

    /**
     * @return $this
     */
    public function setEventType(string $eventType): self
    {
        if ($eventType !== self::EVENT_TYPE_SYNCHRONOUS) {
            throw new InvalidArgumentException('Unknown event type for Connection action');
        }

        $this->eventType = $eventType;

        return $this;
    }

    public function getTimeout(): ?int
    {
        return $this->timeout;
    }

    /**
     * @return $this
     */
    public function setTimeout(int $timeout): self
    {
        $this->timeout = $timeout;

        return $this;
    }

    public function getLimit(): ?int
    {
        return $this->limit;
    }

    /**
     * @return $this
     */
    public function setLimit(int $limit): self
    {
        $this->limit = $limit;

        return $this;
    }

    public function getMachineDetection(): ?string
    {
        return $this->machineDetection;
    }

    /**
     * @return $this
     */
    public function setMachineDetection(string $machineDetection): self
    {
        if (
            $machineDetection !== self::MACHINE_CONTINUE &&
            $machineDetection !== self::MACHINE_HANGUP
        ) {
            throw new InvalidArgumentException('Unknown machine detection type');
        }

        $this->machineDetection = $machineDetection;

        return $this;
    }

    public function getEventWebhook(): ?Webhook
    {
        return $this->eventWebhook;
    }

    /**
     * @return $this
     */
    public function setEventWebhook(Webhook $eventWebhook): self
    {
        $this->eventWebhook = $eventWebhook;

        return $this;
    }

    public function getRingbackTone(): ?string
    {
        return $this->ringbackTone;
    }

    /**
     * @return $this
     */
    public function setRingbackTone(string $ringbackTone): self
    {
        $this->ringbackTone = $ringbackTone;

        return $this;
    }

    public function getAdvancedMachineDetection(): ?AdvancedMachineDetection
    {
        return $this->advancedMachineDetection;
    }

    public function setAdvancedMachineDetection(AdvancedMachineDetection $advancedMachineDetection): static
    {
        $this->advancedMachineDetection = $advancedMachineDetection;

        return $this;
    }
}
PK     t[!^Y      Voice/NCCO/Action/Notify.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice\NCCO\Action;

use InvalidArgumentException;
use Vonage\Voice\Webhook;

use function array_key_exists;

class Notify implements ActionInterface
{
    public function __construct(protected array $payload, protected ?\Vonage\Voice\Webhook $eventWebhook)
    {
    }

    /**
     * @param array<array, mixed> $data
     */
    public static function factory(array $payload, array $data): Notify
    {
        if (array_key_exists('eventUrl', $data)) {
            if (array_key_exists('eventMethod', $data)) {
                $webhook = new Webhook($data['eventUrl'], $data['eventMethod']);
            } else {
                $webhook = new Webhook($data['eventUrl']);
            }
        } else {
            throw new InvalidArgumentException('Must supply at least an eventUrl for Notify NCCO');
        }

        return new Notify($payload, $webhook);
    }

    /**
     * @return array<string, mixed>
     */
    public function jsonSerialize(): array
    {
        return $this->toNCCOArray();
    }

    /**
     * @return array<string, mixed>
     */
    public function toNCCOArray(): array
    {
        $eventWebhook = $this->getEventWebhook();

        return [
            'action' => 'notify',
            'payload' => $this->getPayload(),
            'eventUrl' => [null !== $eventWebhook ? $eventWebhook->getUrl() : null],
            'eventMethod' => null !== $eventWebhook ? $eventWebhook->getMethod() : null,
        ];
    }

    public function getEventWebhook(): ?Webhook
    {
        return $this->eventWebhook;
    }

    public function setEventWebhook(Webhook $eventWebhook): self
    {
        $this->eventWebhook = $eventWebhook;
        return $this;
    }

    public function getPayload(): array
    {
        return $this->payload;
    }

    public function addToPayload(string $key, string $value): self
    {
        $this->payload[$key] = $value;
        return $this;
    }
}
PK     t[m      Voice/Filter/VoiceFilter.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice\Filter;

use DateTimeImmutable;
use DateTimeZone;
use InvalidArgumentException;
use Vonage\Entity\Filter\FilterInterface;

class VoiceFilter implements FilterInterface
{
    public const STATUS_STARTED = 'started';
    public const STATUS_RINGING = 'ringing';
    public const STATUS_ANSWERED = 'answered';
    public const STATUS_MACHINE = 'machine';
    public const STATUS_COMPLETED = 'completed';
    public const STATUS_BUSY = 'busy';
    public const STATUS_CANCELLED = 'cancelled';
    public const STATUS_FAILED = 'failed';
    public const STATUS_REJECTED = 'rejected';
    public const STATUS_TIMEOUT = 'timeout';
    public const STATUS_UNANSWERED = 'unanswered';

    public const ORDER_ASC = 'asc';
    public const ORDER_DESC = 'desc';

    /**
     * @var string
     */
    protected $status;

    /**
     * @var DateTimeImmutable
     */
    protected $dateStart;

    /**
     * @var DateTimeImmutable
     */
    protected $dateEnd;

    /**
     * @var int
     */
    protected $pageSize = 10;

    /**
     * @var int
     */
    protected $recordIndex = 0;

    /**
     * @var string
     */
    protected $order = 'asc';

    /**
     * @var string
     */
    protected $conversationUUID;

    public function getQuery(): array
    {
        $data = [
            'page_size' => $this->getPageSize(),
            'record_index' => $this->getRecordIndex(),
            'order' => $this->getOrder(),
        ];

        if ($this->getStatus()) {
            $data['status'] = $this->getStatus();
        }

        if ($this->getDateStart()) {
            $data['date_start'] = $this->getDateStart()->format('Y-m-d\TH:i:s\Z');
        }

        if ($this->getDateEnd()) {
            $data['date_end'] = $this->getDateEnd()->format('Y-m-d\TH:i:s\Z');
        }

        if ($this->getConversationUUID()) {
            $data['conversation_uuid'] = $this->getConversationUUID();
        }

        return $data;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    /**
     * @return $this
     */
    public function setStatus(string $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getDateStart(): ?DateTimeImmutable
    {
        return $this->dateStart;
    }

    /**
     * @return $this
     */
    public function setDateStart(DateTimeImmutable $dateStart): self
    {
        $dateStart = $dateStart->setTimezone(new DateTimeZone('Z'));
        $this->dateStart = $dateStart;

        return $this;
    }

    public function getDateEnd(): ?DateTimeImmutable
    {
        return $this->dateEnd;
    }

    /**
     * @return $this
     */
    public function setDateEnd(DateTimeImmutable $dateEnd): self
    {
        $dateEnd = $dateEnd->setTimezone(new DateTimeZone('Z'));
        $this->dateEnd = $dateEnd;

        return $this;
    }

    public function getPageSize(): int
    {
        return $this->pageSize;
    }

    /**
     * @return $this
     */
    public function setPageSize(int $pageSize): self
    {
        $this->pageSize = $pageSize;

        return $this;
    }

    public function getRecordIndex(): int
    {
        return $this->recordIndex;
    }

    /**
     * @return $this
     */
    public function setRecordIndex(int $recordIndex): self
    {
        $this->recordIndex = $recordIndex;

        return $this;
    }

    public function getOrder(): string
    {
        return $this->order;
    }

    /**
     * @return $this
     */
    public function setOrder(string $order): self
    {
        if ($order !== self::ORDER_ASC && $order !== self::ORDER_DESC) {
            throw new InvalidArgumentException('Order must be `asc` or `desc`');
        }

        $this->order = $order;

        return $this;
    }

    public function getConversationUUID(): ?string
    {
        return $this->conversationUUID;
    }

    /**
     * @return $this
     */
    public function setConversationUUID(string $conversationUUID): self
    {
        $this->conversationUUID = $conversationUUID;

        return $this;
    }
}
PK     t[辸      Voice/ClientFactory.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice;

use Psr\Container\ContainerInterface;
use Vonage\Client\APIResource;
use Vonage\Client\Credentials\Handler\KeypairHandler;

class ClientFactory
{
    public function __invoke(ContainerInterface $container): Client
    {
        /** @var APIResource $api */
        $api = $container->make(APIResource::class);
        $api
            ->setBaseUri('/v1/calls')
            ->setAuthHandler(new KeypairHandler())
            ->setCollectionName('calls');

        return new Client($api);
    }
}
PK     t[R      Voice/Client.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice;

use DateTimeImmutable;
use DateTimeZone;
use Exception;
use Psr\Http\Client\ClientExceptionInterface;
use Psr\Http\Message\StreamInterface;
use Vonage\Client\APIClient;
use Vonage\Client\APIResource;
use Vonage\Entity\Filter\FilterInterface;
use Vonage\Entity\Hydrator\ArrayHydrator;
use Vonage\Entity\IterableAPICollection;
use Vonage\Voice\NCCO\Action\Talk;
use Vonage\Voice\NCCO\NCCO;
use Vonage\Voice\Webhook\Event;

use function is_null;

class Client implements APIClient
{
    public function __construct(protected APIResource $api)
    {
    }

    public function getAPIResource(): APIResource
    {
        return $this->api;
    }

    /**
     * @throws ClientExceptionInterface
     * @throws \Vonage\Client\Exception\Exception
     * @throws Exception
     * @throws Exception
     *
     * @return Event {uuid: string, conversation_uuid: string, status: string, direction: string}
     */
    public function createOutboundCall(OutboundCall $call): Event
    {
        $json = [
            'to' => [$call->getTo()],
        ];

        if ($call->getFrom()) {
            $json['from'] = $call->getFrom();
        } else {
            $json['random_from_number'] = true;
        }

        if (null !== $call->getAnswerWebhook()) {
            $json['answer_url'] = [$call->getAnswerWebhook()->getUrl()];
            $json['answer_method'] = $call->getAnswerWebhook()->getMethod();
        }

        if (null !== $call->getEventWebhook()) {
            $json['event_url'] = [$call->getEventWebhook()->getUrl()];
            $json['event_method'] = $call->getEventWebhook()->getMethod();
        }

        if (null !== $call->getNCCO()) {
            $json['ncco'] = $call->getNCCO();
        }

        if ($call->getMachineDetection()) {
            $json['machine_detection'] = $call->getMachineDetection();
        }

        if (!is_null($call->getLengthTimer())) {
            $json['length_timer'] = (string)$call->getLengthTimer();
        }

        if (!is_null($call->getRingingTimer())) {
            $json['ringing_timer'] = (string)$call->getRingingTimer();
        }

        if (!is_null($call->getAdvancedMachineDetection())) {
            $json['advanced_machine_detection'] = $call->getAdvancedMachineDetection()->toArray();
        }

        $event = $this->api->create($json);
        $event['to'] = $call->getTo()->getId();
        if ($call->getFrom()) {
            $event['from'] = $call->getFrom()->getId();
        }
        $event['timestamp'] = (new DateTimeImmutable("now", new DateTimeZone("UTC")))->format(DATE_ATOM);

        return new Event($event);
    }

    /**
     * @throws ClientExceptionInterface
     * @throws \Vonage\Client\Exception\Exception
     */
    public function earmuffCall(string $callId): void
    {
        $this->modifyCall($callId, CallAction::EARMUFF);
    }

    /**
     * @throws ClientExceptionInterface
     * @throws \Vonage\Client\Exception\Exception
     * @throws Exception
     */
    public function get(string $callId): Call
    {
        return (new CallFactory())->create($this->api->get($callId));
    }

    /**
     * @throws ClientExceptionInterface
     * @throws \Vonage\Client\Exception\Exception
     */
    public function hangupCall(string $callId): void
    {
        $this->modifyCall($callId, CallAction::HANGUP);
    }

    /**
     * @throws ClientExceptionInterface
     * @throws \Vonage\Client\Exception\Exception
     */
    public function modifyCall(string $callId, string $action): void
    {
        $this->api->update($callId, [
            'action' => $action,
        ]);
    }

    /**
     * @throws ClientExceptionInterface
     * @throws \Vonage\Client\Exception\Exception
     */
    public function muteCall(string $callId): void
    {
        $this->modifyCall($callId, CallAction::MUTE);
    }

    /**
     * @throws ClientExceptionInterface
     * @throws \Vonage\Client\Exception\Exception
     *
     * @return array{uuid: string, message: string}
     */
    public function playDTMF(string $callId, string $digits): array
    {
        return $this->api->update($callId . '/dtmf', [
            'digits' => $digits
        ]);
    }

    /**
     * @throws ClientExceptionInterface
     * @throws \Vonage\Client\Exception\Exception
     *
     * @return array{uuid: string, message: string}
     */
    public function playTTS(string $callId, Talk $action): array
    {
        $payload = $action->toNCCOArray();
        unset($payload['action']);

        return $this->api->update($callId . '/talk', $payload);
    }

    public function search(FilterInterface $filter = null): IterableAPICollection
    {
        $response = $this->api->search($filter);
        $response->setApiResource(clone $this->api);
        $response->setNaiveCount(true);

        $hydrator = new ArrayHydrator();
        $hydrator->setPrototype(new Call());

        $response->setHydrator($hydrator);

        return $response;
    }

    /**
     * @throws ClientExceptionInterface
     * @throws \Vonage\Client\Exception\Exception
     *
     * @return array{uuid: string, message: string}
     */
    public function stopStreamAudio(string $callId): array
    {
        return $this->api->delete($callId . '/stream');
    }

    /**
     * @throws ClientExceptionInterface
     * @throws \Vonage\Client\Exception\Exception
     *
     * @return array{uuid: string, message: string}
     */
    public function stopTTS(string $callId): array
    {
        return $this->api->delete($callId . '/talk');
    }

    /**
     * @throws ClientExceptionInterface
     * @throws \Vonage\Client\Exception\Exception
     *
     * @return array{uuid: string, message: string}
     */
    public function streamAudio(string $callId, string $url, int $loop = 1, float $volumeLevel = 0.0): array
    {
        return $this->api->update($callId . '/stream', [
            'stream_url' => [$url],
            'loop' => (string)$loop,
            'level' => (string)$volumeLevel,
        ]);
    }

    /**
     * @throws ClientExceptionInterface
     * @throws \Vonage\Client\Exception\Exception
     */
    public function transferCallWithNCCO(string $callId, NCCO $ncco): void
    {
        $this->api->update($callId, [
            'action' => 'transfer',
            'destination' => [
                'type' => 'ncco',
                'ncco' => $ncco->toArray()
            ],
        ]);
    }

    /**
     * @throws ClientExceptionInterface
     * @throws \Vonage\Client\Exception\Exception
     */
    public function transferCallWithUrl(string $callId, string $url): void
    {
        $this->api->update($callId, [
            'action' => 'transfer',
            'destination' => [
                'type' => 'ncco',
                'url' => [$url]
            ]
        ]);
    }

    /**
     * @throws ClientExceptionInterface
     * @throws \Vonage\Client\Exception\Exception
     */
    public function unearmuffCall(string $callId): void
    {
        $this->modifyCall($callId, CallAction::UNEARMUFF);
    }

    /**
     * @throws ClientExceptionInterface
     * @throws \Vonage\Client\Exception\Exception
     */
    public function unmuteCall(string $callId): void
    {
        $this->modifyCall($callId, CallAction::UNMUTE);
    }

    public function getRecording(string $url): StreamInterface
    {
        return $this->getAPIResource()->get($url, [], [], false, true);
    }
}
PK     t[1a      Voice/Webhook.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice;

class Webhook
{
    public const METHOD_GET = 'GET';
    public const METHOD_POST = 'POST';

    public function __construct(protected string $url, protected string $method = self::METHOD_POST)
    {
    }

    public function getMethod(): string
    {
        return $this->method;
    }

    public function getUrl(): string
    {
        return $this->url;
    }
}
PK     t[N    /  Voice/VoiceObjects/AdvancedMachineDetection.phpnu [        <?php

namespace Vonage\Voice\VoiceObjects;

use Vonage\Entity\Hydrator\ArrayHydrateInterface;

class AdvancedMachineDetection implements ArrayHydrateInterface
{
    public const MACHINE_BEHAVIOUR_CONTINUE = 'continue';
    public const MACHINE_BEHAVIOUR_HANGUP = 'hangup';
    public const MACHINE_MODE_DETECT = 'detect';
    public const MACHINE_MODE_DETECT_BEEP = 'detect_beep';
    public const BEEP_TIMEOUT_MIN = 45;
    public const BEEP_TIMEOUT_MAX = 120;
    protected array $permittedBehaviour = [self::MACHINE_BEHAVIOUR_CONTINUE, self::MACHINE_BEHAVIOUR_HANGUP];
    protected array $permittedModes = [self::MACHINE_MODE_DETECT, self::MACHINE_MODE_DETECT_BEEP];

    public function __construct(
        protected string $behaviour,
        protected int $beepTimeout,
        protected string $mode = 'detect'
    ) {
        if (!$this->isValidBehaviour($behaviour)) {
            throw new \InvalidArgumentException($behaviour . ' is not a valid behavior string');
        }

        if (!$this->isValidMode($mode)) {
            throw new \InvalidArgumentException($mode . ' is not a valid mode string');
        }

        if (!$this->isValidTimeout($beepTimeout)) {
            throw new \OutOfBoundsException('Timeout ' . $beepTimeout . ' is not valid');
        }
    }

    protected function isValidBehaviour(string $behaviour): bool
    {
        if (in_array($behaviour, $this->permittedBehaviour, true)) {
            return true;
        }

        return false;
    }

    protected function isValidMode(string $mode): bool
    {
        if (in_array($mode, $this->permittedModes, true)) {
            return true;
        }

        return false;
    }

    protected function isValidTimeout(int $beepTimeout): bool
    {
        $range = [
            'options' => [
                'min_range' => self::BEEP_TIMEOUT_MIN,
                'max_range' => self::BEEP_TIMEOUT_MAX
            ]
        ];

        if (filter_var($beepTimeout, FILTER_VALIDATE_INT, $range)) {
            return true;
        }

        return false;
    }

    public function fromArray(array $data): static
    {
        $this->isArrayValid($data);

        $this->behaviour = $data['behaviour'];
        $this->mode = $data['mode'];
        $this->beepTimeout = $data['beep_timeout'];

        return $this;
    }

    public function toArray(): array
    {
        return [
            'behavior' => $this->behaviour,
            'mode' => $this->mode,
            'beep_timeout' => $this->beepTimeout
        ];
    }

    protected function isArrayValid(array $data): bool
    {
        if (
            !array_key_exists('behaviour', $data)
            || !array_key_exists('mode', $data)
            || !array_key_exists('beep_timeout', $data)
        ) {
            return false;
        }

        return $this->isValidBehaviour($data['behaviour'])
               || $this->isValidMode($data['mode'])
               || $this->isValidTimeout($data['beep_timeout']);
    }
}
PK     t[#    $  Voice/Endpoint/EndpointInterface.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice\Endpoint;

use JsonSerializable;

interface EndpointInterface extends JsonSerializable
{

    public function getId(): string;

    /**
     * @return array<string, array>
     */
    public function toArray(): array;
}
PK     t[b\:      Voice/Endpoint/SIP.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice\Endpoint;

class SIP implements EndpointInterface
{
    /**
     * @var array<string, string>
     */
    protected $headers = [];

    public function __construct(protected string $id, array $headers = [])
    {
        $this->setHeaders($headers);
    }

    public static function factory(string $uri, array $headers = []): SIP
    {
        return new SIP($uri, $headers);
    }

    /**
     * @return array{type: string, uri: string, headers?: array<string, string>}
     */
    public function jsonSerialize(): array
    {
        return $this->toArray();
    }

    /**
     * @return array{type: string, uri: string, headers?: array<string, string>}
     */
    public function toArray(): array
    {
        $data = [
            'type' => 'sip',
            'uri' => $this->id,
        ];

        if (!empty($this->getHeaders())) {
            $data['headers'] = $this->getHeaders();
        }

        return $data;
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function getHeaders(): array
    {
        return $this->headers;
    }

    /**
     * @return $this
     */
    public function addHeader(string $key, string $value): self
    {
        $this->headers[$key] = $value;

        return $this;
    }

    /**
     * @return $this
     */
    public function setHeaders(array $headers): self
    {
        $this->headers = $headers;

        return $this;
    }
}
PK     t[Q`ML
  L
    Voice/Endpoint/Websocket.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice\Endpoint;

use function array_key_exists;

class Websocket implements EndpointInterface
{
    public const TYPE_16000 = 'audio/116;rate=16000';
    public const TYPE_8000 = 'audio/116;rate=8000';

    /**
     * @var string
     */
    protected $contentType;

    /**
     * @var array<string, string>
     */
    protected $headers = [];

    public function __construct(protected string $id, string $rate = self::TYPE_8000, array $headers = [])
    {
        $this->setContentType($rate);
        $this->setHeaders($headers);
    }

    public static function factory(string $uri, array $data = []): Websocket
    {
        $endpoint = new Websocket($uri);

        if (array_key_exists('content-type', $data)) {
            $endpoint->setContentType($data['content-type']);
        }

        if (array_key_exists('headers', $data)) {
            $endpoint->setHeaders($data['headers']);
        }

        return $endpoint;
    }

    /**
     * @return array{type: string, uri: string, content-type?: string, headers?: array<string, string>}
     */
    public function jsonSerialize(): array
    {
        return $this->toArray();
    }

    /**
     * @return array{type: s