tic $suffix = ['Filho', 'Neto', 'Sobrinho', 'Jr.'];

    /**
     * @example 'Jr.'
     */
    public static function suffix()
    {
        return static::randomElement(static::$suffix);
    }

    /**
     * A random CPF number.
     *
     * @see http://en.wikipedia.org/wiki/Cadastro_de_Pessoas_F%C3%ADsicas
     *
     * @param bool $formatted If the number should have dots/dashes or not.
     *
     * @return string
     */
    public function cpf($formatted = true)
    {
        $n = $this->generator->numerify('#########');
        $n .= check_digit($n);
        $n .= check_digit($n);

        return $formatted ? vsprintf('%d%d%d.%d%d%d.%d%d%d-%d%d', str_split($n)) : $n;
    }

    /**
     * A random RG number, following Sao Paulo state's rules.
     *
     * @see http://pt.wikipedia.org/wiki/C%C3%A9dula_de_identidade
     *
     * @param bool $formatted If the number should have dots/dashes or not.
     *
     * @return string
     *