[def: true] If it should return a formatted number or not.
     *
     * @return string
     */
    public static function landline($formatted = true)
    {
        $number = static::numerify(static::randomElement(static::$landlineFormats));

        if (!$formatted) {
            $number = strtr($number, ['-' => '']);
        }

        return $number;
    }

    /**
     * Randomizes between cellphone and landline numbers.
     *
     * @param bool $formatted [def: true] If it should return a formatted number or not.
     */
    public static function phone($formatted = true)
    {
        $options = static::randomElement([
            ['cellphone', false],
            ['cellphone', true],
            ['landline', null],
        ]);

        return call_user_func("static::{$options[0]}", $formatted, $options[1]);
    }

    /**
     * Generates a complete phone number.
     *
     * @param string $type      [def: landline] One of "landline" or "cellphone". Defaults to "landline" on invalid values.
     * @param bool   $formatted [def: true] If the number should be formatted or not.
     *
     * @return string
     */
    protected static function anyPhoneNumbPK     zFs[#h_m  m     Faker/Provider/pt_BR/Payment.phpnu [        number = ($type == 'cellphone') ?
            static::cellphone($formatted) :
            static::landline($formatted);

        return $formatted ? "($area) $number" : $area . $number;
    }

    /**
     * Concatenates {@link areaCode} and {@link cellphone} into a national cellphone number.
     *
     * @param bool $formatted [def: true] If it should return a formatted number or not.
     *
     * @return string
     */
    public static function cellphoneNumber($formatted = true)
    {
        return static::anyPhoneNumber('cellphone', $formatted);
    }

    /**
     * Concatenates {@link areaCode} and {@link landline} into a national landline number.
     *
     * @param bool $formatted [def: true] If it should return a formatted number or not.
     *
     * @return string
     */
    public static function landlineNumber($formatted = true)
    {
        return static::anyPhoneNumber('landline', $formatted);
    }

    /**
     * Randomizes between complete cellphone and landline numbers.
     */
    public function phoneNumber()
    {
        $method = static::randomElement(['cellphoneNumber', 'landlineNumber']);

        return call_user_func("static::$method", true);
    }

    /**
     * Randomizes between complete cellphone and landline numbers, cleared from formatting symbols.
     */
    public static function phoneNumberCleared()
    {
        $method = static::randomElement(['cellphoneNumber', 'landlineNumber']);

        return call_user_func("static::$method", false);
    }
}
PK     zFs[#h_m  m     Faker/Provider/pt_BR/Payment.phpnu [        <?php

namespace Faker\Provider\pt_BR;

class Payment extends \Faker\Provider\Payment
{
    protected static $cardVendors = [
        'Visa', 'Visa', 'Visa', 'Visa', 'Visa',
        'MasterCard', 'MasterCard', 'MasterCard', 'MasterCard', 'MasterCard',
        'American Express', 'Discover Card', 'Diners', 'Elo', 'Hipercard',
    ];

    // see https://gist.github.com/erikhenrique/5931368 / http://pt.stackoverflow.com/q/3715/26461
    protected static $cardParams = [
        'Visa' => [
            '4##############',
        ],
        'MasterCard' => [
            '5##############',
        ],
        'American Express' => [
            '34############',
            '37############',
        ],
        'Discover Card' => [
            '6011###########',
            '622############',
            '64#############',
            '65#############',
        ],
        'Diners' => [
            '301############',
            '301##########',
            '305############',
            '305##########',
            '36#############',
            '36###########',
            '38#############',
            '38###########',
        ],
        'Elo' => [
            '636368#########',
            '438935#########',
            '504175#########',
            '451416#########',
            '636297#########',
            '5067###########',
            '4576###########',
            '4011###########',
        ],
        'Hipercard' => [
            '38#############',
            '60#############',
        ],
        'Aura' => [
            '50#############',
        ],
    ];

    /**
     * I