    $n .= check_digit($n);

        return $formatted ? vsprintf('%d%d.%d%d%d.%d%d%d/%d%d%d%d-%d%d', str_split($n)) : $n;
    }
}
PK     zFs[|l    $  Faker/Provider/pt_BR/check_digit.phpnu [        <?php

namespace Faker\Provider\pt_BR;

/**
 * Calculates one MOD 11 check digit based on customary Brazilian algorithms.
 *
 * @see http://en.wikipedia.org/wiki/Check_digit
 * @see http://pt.wikipedia.org/wiki/CNPJ#Algoritmo_de_Valida.C3.A7.C3.A3o
 * @see http://en.wikipedia.org/wiki/Cadastro_de_Pessoas_F%C3%ADsicas#Validation
 *
 * @param int|string $numbers Numbers on which generate the check digit
 *
 * @return int
 */
function check_digit($numbers)
{
    $numbers = (string) $numbers;
    $length = strlen($numbers);
    $second_algorithm = $length >= 12;
    $verifier = 0;

    for ($i = 1; $i <= $length; ++$i) {
        if (!$second_algorithm) {
            $multiplier = $i + 1;
        } else {
            $multiplier = ($i >= 9) ? $i - 7 : $i + 1;
        }
        $verifier += $numbers[$length - $i] * $multiplier;
    }

    $verifier = 11 - ($verifier % 11);

    if ($verifier >= 10) {
        $verifier = 0;
    }

    return $verifier;
}
PK     zFs[-yD|  |  $  Faker/Provider/pt_BR/PhoneNumber.phpnu [        <?php

namespace Faker\Provider\pt_BR;

class PhoneNumber extends \Faker\Provider\PhoneNumber
{
    protected static $landlineFormats = ['2###-####', '3###-####', '4###-####'];

    /**
     * Since december 2016 all mobile phone numbers in brazil begin with 9 and landlines 2, 3 or 4.
     *
     * @see http://www.anatel.gov.br/Portal/exibirPortalPaginaEspecial.do?org.apache.struts.taglib.html.TOKEN=9594e1d11fbc996d52bda44e608bb744&codItemCanal=1794&pastaSelecionada=2984
     */
    protected static $cellphoneFormats = ['9####-####'];

    /**
     * Generates a 2-digit area code not composed by zeroes.
     *
     * @see http://www.anatel.gov.br/legislacao/resolucoes/16-2001/383-resolucao-263.
     *
     * @return string
     */
    public static function areaCode()
    {
        $areaCodes = [
            '11', '12', '13', '14', '15', '16', '17', '18', '19', '21', '22', '24',
            '27', '28', '31', '32', '33', '34', '35', '37', '38', '41', '42', '43',
            '44', '45', '46', '47', '48', '49', '51', '53', '54', '55', '61', '62',
            '63', '64', '65', '66', '67', '68', '69', '71', '73', '74', '75', '77',
            '79', '81', '82', '83', '84', '85', '86', '87', '88', '89', '91', '92',
            '93', '94', '95', '96', '97', '98', '99',
        ];

        return self::randomElement($areaCodes);
    }

    /**
     * Generates a 9-digit cellphone number without formatting characters.
     *
     * @param bool $formatted [def: true] If it should return a formatted number or not.
     *
     * @return string
     */
    public static function cellphone($formatted = true)
    {
        $number = static::numerify(static::randomElement(static::$cellphoneFormats));

        if (!$formatted) {
            $number = strtr($number, ['-' => '']);
        }

        return $number;
    }

  in brazil begin with 9 and landlines 2, 3 or 4.
     *
     * @see http://www.anatel.gov.br/Portal/exibirPortalPaginaEspecial.do?org.apache.struts.taglib.html.TOKEN=9594e1d11fbc996d52bda44e608bb744&codItemCanal=1794&pastaSelecionada=2984
     */
    protected static $cellphoneFormats = ['9####-####'];

    /**
     * Generates a 2-digit area code not composed by zeroes.
     *
     * @see http://www.anatel.gov.br/legislacao/resolucoes/16-2001/383-resolucao-263.
     *
     * @return string
     */
    public static function areaCode()
    {
        $areaCodes = [
            '11', '12', '13', '14', '15', '16', '17', '18', '19', '21', '22', '24',
            '27', '28', '31', '32', '33', '34', '35', '37', '38', '41', '42', '43',
            '44', '45', '46', '47', '48', '49', '51', '53', '54', '55', '61', '62',
            '63', '64', '65', '66', '67', '68', '69', '71', '73', '74', '75', '77',
            '79', '81', '82', '83', '84', '85', '86', '87', '88', '89', '91', '92',
            '93', '94', '95', '96', '97', '98', '99',
        ];

        return self::randomElement($areaCodes);
    }

    /**
     * Generates a 9-digit cellphone number without formatting characters.
     *
     * @param bool $formatted [def: true] If it should return a formatted number or not.
     *
     * @return string
     */
    public static function cellphone($formatted = true)
    {
        $number = static::numerify(static::randomElement(static::$cellphoneFormats));

        if (!$formatted) {
            $number = strtr($number, ['-' => '']);
        }

        return $number;
    }

    /**
     * Generates an 9-digit land