private string $url, private string $text = '')
    {
    }

    public function fromArray(array $data): ViberActionObject
    {
        $this->url = $data['url'];
        $this->text = $data['text'];

        return $this;
    }

    public function toArray(): array
    {
        return [
            'url' => $this->getUrl(),
            'text' => $this->getText()
        ];
    }

    public function getUrl(): string
    {
        return $this->url;
    }

    public function getText(): string
    {
        return $this->text;
    }
}
PK     t[d|C
  
  %  Messages/Channel/Viber/ViberImage.phpnu [        <?php

namespace Vonage\Messages\Channel\Viber;

use Vonage\Messages\Channel\Viber\MessageObjects\ViberActionObject;
use Vonage\Messages\MessageObjects\ImageObject;
use Vonage\Messages\Channel\BaseMessage;

class ViberImage extends BaseMessage
{
    use ViberServiceObjectTrait;

    protected string $channel = 'viber_service';
    protected string $subType = BaseMessage::MESSAGES_SUBTYPE_IMAGE;

    public function __construct(
        string $to,
        string $from,
        protected ImageObject $image,
        ?string $category = null,
      PK     FFs[Z >  >     Faker/Provider/sk_SK/Company.phpnu [        berActionObject = null
    ) {
        $this->to = $to;
        $this->from = $from;
        $this->category = $category;
        $this->ttl = $ttl;
        $this->type = $type;
        $this->action = $viberActionObject;
    }

    public function toArray(): array
    {
        $returnArray = $this->getBaseMessageUniversalOutputArray();
        $returnArray['image'] = $this->image->toArray();

        if ($this->requiresViberServiceObject()) {
            $this->getCategory() ? $returnArray['viber_service']['category'] = $this->getCategory(): null;
            $this->getTtl() ? $returnArray['viber_service']['ttl'] = $this->getTtl(): null;
            $this->getType() ? $returnArray['viber_service']['type'] = $this->getType(): null;
            $this->getAction() ? $returnArray['viber_service']['action'] = $this->getAction()->toArray(): null;
        }

        return array_filter($returnArray);
    }
}
PK     t[Lq5  5  $  Messages/Channel/Viber/ViberFile.phpnu [        <?php

namespace Vonage\Messages\Channel\Viber;

use Vonage\Messages\MessageObjects\FileObject;
use Vonage\Messages\Channel\BaseMessage;
class ViberFile extends BaseMessage
{
    use ViberServiceObjectTrait;

    protected string $channel = 'viber_service';
    protected string $subType = BaseMessage::MESSAGES_SUBTYPE_FILE;

    public function __construct(
        string $to,
        string $from,
        protected FileObject $fileObject
    ) {
        $this->to = $to;
        $this->from = $from;
    }

    public function toArray(): array
    {
        $returnArray = $this->getBaseMessageUniversalOutputArray();
        $returnArray['file'] = $this->fileObject->toArray();

        if ($this->requiresViberServiceObject()) {
            $this->getCategory() ? $returnArray['viber_service']['category'] = $this->getCategory(): null;
            $this->getTtl() ? $returnArray['viber_service']['ttl'] = $this->getTtl(): null;
            $this->getType() ? $returnArray['viber_service']['type'] = $this->getType(): null;
        }

        return $returnArray;
    }
}PK     t[*'  '  $  Messages/Channel/Viber/ViberText.phpnu [        <?php

namespace Vonage\Messages\Channel\Viber;

use Vonage\Messages\Channel\Viber\MessageObjects\ViberActionObject;
use Vonage\Messages\MessageTraits\TextTrait;
use Vonage\Messages\Channel\BaseMessage;

class ViberText extends BaseMessage
{
    use TextTrait;
    use ViberServiceObjectTrait;

    protected string $subType = BaseMessage::MESSAGES_SUBTYPE_TEXT;
    protected string $channel = 'viber_service';

    public function __construct(
        string $to,
        string $from,
        string $message,
        ?string $category = null,
        ?int $ttl = null,
        ?string $type = null,
        ?ViberActionObject $viberActionObject = null,
    ) {
        $this->to = $to;
        $this->from = $from;
        $this->text = $message;
        $this->category = $category;
        $this->ttl = $ttl;
        $this->type = $type;
        $this->action = $viberActionObject;
    }

    public function toArray(): array
    {
        $returnArray = $this->getBaseMessageUniversalOutputArray();
        $returnArray['text'] = $this->getText();

        if ($this->requiresViberServiceObject()) {
            $this->getCategory() ? $returnArray['viber_service']['category'] = $this->getCategory(): null;
            $this->getTtl() ? $returnArray['viber_service']['ttl'] = $this->getTtl(): null;
            $this->getType() ? $returnArray['viber_service']['type'] = $this->getType(): null;
            $this->getAction() ? $returnArray['viber_service']['action'] = $this->getAction()->toArray(): null;
        }

        return array_filter($returnArray);
    }
}
PK     t[(      Messages/Channel/Message.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Messages\Channel;

interface Message
{
    public function toArray(): array;
    public function getTo(): string;
    public function setTo(string $to): void;
    public function getFrom(): string;
    public function setFrom(string $from): void;
    public function getClientRef(): ?string;
    public function getChannel(): string;
    public function getSubType(): string;
    public function setClientRef(string $clientRef): void;

    /**
     * All message types have shared outputs required by the endpoint.
     * Child classes are required to call this before assembling their
     * own specific output
     *
     * @return array
     */
    public function getBaseMessageUniversalOutputArray(): array;
}
PK     t[f    !  Messages/Channel/MMS/MMSVideo.phpnu [        <?php

namespace Vonage\Messages\Channel\MMS;

use Vonage\Messages\MessageObjects\AudioObject;
use Vonage\Messages\MessageObjects\VideoObject;
use Vonage\Messages\Channel\BaseMessage;

class MMSVideo extends BaseMessage
{
    protected string $channel = 'mms';
    protected string $subType = BaseMessage::MESSAGES_SUBTYPE_VIDEO;

    public function __construct(
        string $to,
        string $from,
        protected VideoObject $videoObject
    ) {
        $this->to = $to;
        $this->from = $from;
    }

    public function toArray(): array
    {
        $returnArray = $this->getBaseMessageUniversalOutputArray();
        $returnArray['video'] = $this->videoObject->toArray();

        return $returnArray;
    }
}
PK     t[gl    !  Messages/Channel/MMS/MMSvCard.phpnu [        <?php

namespace Vonage\Me