  $response->getStatusCode()
            );
        }

        if ($statusCode >= 500 && $statusCode <= 599) {
            throw new ClientException\Server($responseBody['title'] . ': ' . $responseBody['detail']);
        }

        throw new ClientException\Request($responseBody['title'] . ': ' . $responseBody['detail']);
    }
}
PK     t[ȸ    +  Messages/Channel/WhatsApp/WhatsAppVideo.phpnu [        <?php

namespace Vonage\Messages\Channel\WhatsApp;

use Vonage\Messages\MessageObjects\VideoObject;
use Vonage\Messages\Channel\BaseMessage;

class WhatsAppVideo extends BaseMessage
{
    protected string $channel = 'whatsapp';
    protected string $subType = BaseMessage::MESSAGES_SUBTYPE_VIDEO;

    public function __construct(
        string $to,
        string $from,
        protected VideoObject $videoObject
    ) {
        $this->to = $to;
        $this->from = $from;
    }

    public function toArray(): array
    {
        $returnArray = $this->getBaseMessageUniversalOutputArray();
        $returnArray['video'] = $this->videoObject->toArray();

        return $returnArray;
    }
}PK     t[3)  )  ,  Messages/Channel/WhatsApp/WhatsPK     FFs[n0-  -    Faker/Provider/sk_SK/Person.phpnu [        p;

use Vonage\Messages\Channel\BaseMessage;

class WhatsAppCustom extends BaseMessage
{
    protected string $subType = BaseMessage::MESSAGES_SUBTYPE_CUSTOM;
    protected string $channel = 'whatsapp';

    public function __construct(
        string $to,
        string $from,
        protected array $custom
    ) {
        $this->to = $to;
        $this->from = $from;
    }

    public function setCustom(array $custom): void
    {
        $this->custom = $custom;
    }

    public function getCustom(): array
    {
        return $this->custom;
    }

    public function toArray(): array
    {
        $returnArray = $this->getBaseMessageUniversalOutputArray();
        $returnArray['custom'] = $this->getCustom();

        return $returnArray;
    }
}
PK     t[7c  c  .  Messages/Channel/WhatsApp/WhatsAppTemplate.phpnu [        <?php

namespace Vonage\Messages\Channel\WhatsApp;

use Vonage\Messages\MessageObjects\FileObject;
use Vonage\Messages\MessageObjects\TemplateObject;
use Vonage\Messages\Channel\BaseMessage;

class WhatsAppTemplate extends BaseMessage
{
    protected string $channel = 'whatsapp';
    protected string $subType = BaseMessage::MESSAGES_SUBTYPE_TEMPLATE;

    public function __construct(
        string $to,
        string $from,
        protected TemplateObject $templateObject,
        protected string $locale
    ) {
        $this->to = $to;
        $this->from = $from;
    }

    public function toArray(): array
    {
        $returnArray = [
            'template' => $this->templateObject->toArray(),
            'whatsapp' => [
                'policy' => 'deterministic',
                'locale' => $this->getLocale()
            ]
        ];

        return array_merge($this->getBaseMessageUniversalOutputArray(), $returnArray);
    }

    public function getLocale(): string
    {
        return $this->locale;
    }

    public function setLocale($locale): void
    {
        $this->locale = $locale;
    }
}PK     t[]z    +  Messages/Channel/WhatsApp/WhatsAppImage.phpnu [        <?php

namespace Vonage\Messages\Channel\WhatsApp;

use Vonage\Messages\MessageObjects\ImageObject;
use Vonage\Messages\Channel\BaseMessage;

class WhatsAppImage extends BaseMessage
{
    protected string $channel = 'whatsapp';
    protected string $subType = BaseMessage::MESSAGES_SUBTYPE_IMAGE;

    public function __construct(
        string $to,
        string $from,
        protected ImageObject $image
    ) {
        $this->to = $to;
        $this->from = $from;
    }

    public function toArray(): array
    {
        $returnArray = $this->getBaseMessageUniversalOutputArray();
        $returnArray['image'] = $this->image->toArray();

        return $returnArray;
    }
}
PK     t[ɖ    -  Messages/Channel/WhatsApp/WhatsAppSticker.phpnu [        <?php

namespace Vonage\Messages\Channel\WhatsApp;

use Vonage\Messages\Channel\BaseMessage;
use Vonage\Messages\Channel\WhatsApp\MessageObjects\StickerObject;

class WhatsAppSticker extends BaseMessage
{
    protected string $subType = BaseMessage::MESSAGES_SUBTYPE_STICKER;
    protected string $channel = 'whatsapp';

    public function __construct(
        string $to,
        string $from,
        protected StickerObject $sticker
    ) {
        $this->to = $to;
        $this->from = $from;
    }

    public function getSticker(): StickerObject
    {
        return $this->sticker;
    }

    public function setSticker(StickerObject $sticker): static
    {
        $this->sticker = $sticker;

        return $this;
    }

    public function toArray(): array
    {
        $returnArray = $this->getBaseMessageUniversalOutputArray();
        $returnArray['sticker'] = $this->getSticker()->toArray();

        return $returnArray;
    }
}
PK     t[(hjz    *  Messages/Channel/WhatsApp/WhatsAppFile.phpnu [        <?php

namespace Vonage\Messages\Channel\WhatsApp;

use Vonage\Messages\MessageObjects\FileObject;
use Vonage\Messages\Channel\BaseMessage;

class WhatsAppFile extends BaseMessage
{
    protected string $channel = 'whatsapp';
    protected string $subType = BaseMessage::MESSAGES_SUBTYPE_FILE;

    public function __construct(
        string $to,
        string $from,
        protected FileObject $fileObject
    ) {
        $this->to = $to;
        $this->from = $from;
    }

    public function toArray(): array
    {
        $returnArray = $this->getBaseMessageUniversalOutputArray();
        $returnArray['file'] = $this->fileObject->toArray();

        return $returnArray;
    }
}PK     t[    *  Messages/Channel/WhatsApp/WhatsAppText.phpnu [        <?php

namespace Vonage\Messages\Channel\WhatsApp;

use Vonage\Messages\MessageTraits\TextTrait;
use Vonage\Messages\Channel\BaseMessage;

class WhatsAppText extends BaseMessage
{
    use TextTrait;

    protected string $subType = BaseMessage::MESSAGES_SUBTYPE_TEXT;
    protected string $channel = 'whatsapp';

    public function __construct(
        string $to,
        string $from,
        string $text
    ) {
        $this->to = $to;
        $this->from = $from;
        $this->text = $text;
    }

    public function toArray(): array
    {
        $returnArray = $this->getBaseMessageUniversalOutputArray();
        $returnArray['text'] = $this->getText();

        return $returnArray;
    }
}
PK     t[t    :  Messages/Channel/WhatsApp/MessageObjects/StickerObject.phpnu [        <?php

namespace Vonage\Messages\Channel\WhatsApp\MessageObjects;

use Vonage\Entity\Hydrator\ArrayHydrateInterface;

class StickerObject implements ArrayHydrateInterface
{
    public const STICKER_URL = 'url';
    public  const STICKER_ID = 'id';

    private array $allowedTypes = [
        self::STICKER_URL,
        self::STICKER_ID
    ];

    public function __construct(private string $type, private string $value = '')
    {
        if (! in_array($type, $this->allowedTypes, true)) {
            throw new \InvalidArgumentException($type . ' is an invalid type of Sticker');
        }
    }

    public function fromArray(array $data): StickerObject
    {
        if (! in_array($data['type'], $this->allowedTypes, true)) {
            throw new \InvalidArgumentException($data['type'] . ' is an invalid type of Sticker');
        }

        return $this;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @param string $type
     */
    public function setType(string $type): void
    {
        $this->type = $type;
    }

    /**
     * @return string
     */
    public function getValue(): string
    {
        return $this->value;
    }

    /**
     * @param string $value
     */
    public function setValue(string $value): void
    {
        $this->value = $value;
    }

    public function toArray(): array
    {
        return [$this->getType() => $this->getValue()];
    }
}
PK     t['l޹    +  Messages/Channel/WhatsApp/WhatsAppAudio.phpnu [        <?php

namespace Vonage\Messages\Channel\WhatsApp;

use Vonage\Messages\MessageObjects\AudioObject;
use Vonage\Messages\Channel\BaseMessage;

class WhatsAppAudio extends BaseMessage
{
    protected string $channel = 'whatsapp';
    protected string $subType = BaseMessage::MESSAGES_SUBTYPE_AUDIO;

    public function __construct(
        string $to,
        string $from,
        protected AudioObject $audioObject
    ) {
        $this->to = $to;
        $this->from = $from;
    }

    public function toArray(): array
    {
        $returnArray = $this->getBaseMessageUniversalOutputArray();
        $returnArray['audio'] = $this->audioObject->toArray();

        return $returnArray;
    }
}PK     t[H
n    %  Messages/Channel/Viber/ViberVideo.phpnu [        <?php

namespace Vonage\Messages\Channel\Viber;

use Vonage\Messages\MessageObjects\VideoObject;
use Vonage\Messages\MessageTraits\TextTrait;
use Vonage\Messages\Channel\BaseMessage;

class ViberVideo extends BaseMessage
{
    use TextTrait;
    use ViberServiceObjectTrait;

    protected string $subType = BaseMessage::MESSAGES_SUBTYPE_VIDEO;
    protected string $channel = 'viber_service';
    protected string $thumbUrl = "";

    public function __construct(
        string $to,
        string $from,
        string $thumbUrl,
        protected VideoObject $videoObject
    ) {
        $this->to = $to;
        $this->from = $from;
        $this->thumbUrl = $thumbUrl;
    }

    public function toArray(): array
    {
        $returnArray = $this->getBaseMessageUniversalOutputArray();
        $videoArray = $this->videoObject->toArray();
        $videoArray['thumb_url'] = $this->thumbUrl;
        $returnArray['video'] = $videoArray;

        return $returnArray;
    }
}
PK     t[e$  $  2  Messages/Channel/Viber/ViberServiceObjectTrait.phpnu [        <?php

namespace Vonage\Messages\Channel\Viber;

use Vonage\Messages\Channel\Viber\MessageObjects\ViberActionObject;

trait ViberServiceObjectTrait
{
    private ?string $category = null;
    private ?int $ttl = null;
    private ?string $type = null;
    private ?ViberActionObject $action = null;

    public function requiresViberServiceObject(): bool
    {
        return $this->getCategory() || $this->getTtl() || $this->getType() || $this->getAction();
    }

    public function getCategory(): ?string
    {
        return $this->category;
    }

    public function setCategory(?string $category): static
    {
        $this->category = $category;

        return $this;
    }

    public function getTtl(): ?int
    {
        return $this->ttl;
    }

    public function setTtl(int $ttl): static
    {
        $this->ttl = $ttl;

        return $this;
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    public function setType(string $type): static
    {
        $this->type = $type;

        return $this;
    }

    public function getAction(): ?ViberActionObject
    {
        return $this->action;
    }

    public function setAction(ViberActionObject $viberActionObject): static
    {
        $this->action = $viberActionObject;

        return $this;
    }
}
PK     t[Pm    ;  Messages/Channel/Viber/MessageObjects/ViberActionObject.phpnu [        <?php

namespace Vonage\Messages\Channel\Viber\MessageObjects;

use Vonage\Entity\Hydrator\ArrayHydrateInterface;

class Viber