  *
     * @see http://en.wikipPK     Fs[hufh)  )     Faker/Provider/sv_SE/Company.phpnu [        birthdate
     * @param string    $gender    Person::GENDER_MALE || Person::GENDER_FEMALE
     *
     * @return string on format XXXXXX-XXXX
     */
    public function personalIdentityNumber(\DateTime $birthdate = null, $gender = null)
    {
        if (!$birthdate) {
            $birthdate = \Faker\Provider\DateTime::dateTimeThisCentury();
        }
        $datePart = $birthdate->format('ymd');
        $randomDigits = $this->getBirthNumber($gender);

        $checksum = Luhn::computeCheckDigit($datePart . $randomDigits);

        return $datePart . '-' . $randomDigits . $checksum;
    }

    /**
     * @param string $gender Person::GENDER_MALE || Person::GENDER_FEMALE
     *
     * @return string of three digits
     */
    protected function getBirthNumber($gender = null)
    {
        if ($gender && $gender === static::GENDER_MALE) {
            return (string) static::numerify('##') . static::randomElement([1, 3, 5, 7, 9]);
        }

        $zeroCheck = static function ($callback) {
            do {
                $randomDigits = $callback(PK     Fs[:    $  Faker/Provider/sv_SE/PhoneNumber.phpnu [        
        };

        if ($gender && $gender === static::GENDER_FEMALE) {
            return $zeroCheck(static function () {
                return (string) static::numerify('##') . static::randomElement([0, 2, 4, 6, 8]);
            });
        }