PRECATED
            );
        }

        if (array_key_exists('bargeIn', $data)) {
            $talk->setBargeIn(
                filter_var($data['bargeIn'], FILTER_VALIDATE_BOOLEAN, ['flags' => FILTER_NULL_ON_FAILURE])
            );
        }

        if (array_key_exists('premium', $data)) {
            $talk->setPremium(
                filter_var($data['premium'], FILTER_VALIDATE_BOOLEAN, ['flags' => FILTER_NULL_ON_FAILURE])
            );
        }

        if (array_key_exists('level', $data)) {
            $talk->setLevel(
                filter_var($data['level'], FILTER_VALIDATE_FLOAT, ['flags' => FILTER_NULL_ON_FAILURE])
            );
        }

        if (array_key_exists('loop', $data)) {
            $talk->setLoop(
                filter_var($data['loop'], FILTER_VALIDATE_INT, ['flags' => FILTER_NULL_ON_FAILURE])
            );
        }

        if (array_key_exists('PK     AFs[M      !  Faker/Provider/th_TH/Internet.phpnu [                $talk->setLanguage($data['language'], (int) $data['style']);
            } else {
                $talk->setLanguage($data['language']);
            }
        }

        return $talk;
    }

PK     AFs[Cid  id     Faker/Provider/th_TH/Address.phpnu [         }

    public function getLevel(): ?float
    {
        return $this->level;
    }

    public function getLoop(): ?int
    {
        return $this->loop;
    }

    public function getText(): string
    {
        return $this->text;
    }

    /**
     * @return array{action: string, bargeIn: bool, level: float, loop: int, text: string}
     */
    public function jsonSerialize(): array
    {
        return $this->toNCCOArray();
    }

    public function setBargeIn(bool $value): self
    {
        $this->bargeIn = $value;
        return $this;
    }

    /**
     * @return $this
     */
    public function setLevel(float $level): self
    {
        $this->level = $level;

        return $this;
    }

    public function setLoop(int $times): self
    {
        $this->loop = $times;

        return $this;
    }

    /**
     * @return $this
     */
    public function setPremium(bool $premium): self
    {
        $this->premium = $premium;

        return $this;
    }

    public function getPremium(): bool
    {
        return $this->premium;
    }

    /**
     * @return array{action: string, bargeIn: bool, level: string, loop: string, text: string, premium: string, language: string, style: string}
     */
    public function toNCCOArray(): array
    {
        $data = [
            'action' => 'talk',
            'text' => $this->getText(),
        ];

        if (!is_null($this->getBargeIn())) {
            $data['bargeIn'] = $this->getBargeIn() ? 'true' : 'false';
        }

        if (!is_null($this->getLevel())) {
            $data['level'] = (string)$this->getLevel();
        }

        if (!is_null($this->getLoop())) {
            $data['loop'] = (string)$this->getLoop();
        }

        if ($this->getLanguage()) {
            $data['language'] = $this->getLanguage();
            $data['style'] = (string) $this->getLanguageStyle();
        }

        if (!is_null($this->getPremium())) {
            $data['premium'] = $this->getPremium() ? 'true' : 'false';
        }

        return $data;
    }

    public function setLanguage(string $language, int $style = 0): self
    {
        $this->language = $language;
        $this->languageStyle = $style;

        return $this;
    }

    public function getLanguage(): ?string
    {
        return $this->language;
    }

    public function getLanguageStyle(): int
    {
        return $this->languageStyle;
    }
}
PK     t["      Voice/NCCO/Action/Record.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice\NCCO\Action;

use InvalidArgumentException;
use Vonage\Voice\Webhook;

use function array_key_exists;
use function filter_var;
use function preg_match;

class Record implements ActionInterface
{
    public const FORMAT_MP3 = "mp3";
    public const FORMAT_WAV = "wav";
    public const FORMAT_OGG = "ogg";
    public const SPLIT = 'conversation';

    /**
     * @var string Record::FORMAT_*
     */
    protected $format = 'mp3';

    /**
     * @var string Record::SPLIT
     */
    protected $split;

    /**
     * @var int
     */
    protected $channels;

    /**
     * @var int
     */
    protected $endOnSilence;

    /**
     * @var string '*'|'#'|1'|2'|'3'|'4'|'5'|'6'|'7'|'8'|'9'|'0'
     */
    protected $endOnKey;

    /**
     * @var int
     */
    protected $timeOut = 7200;

    /**
     * @var bool
     */
    protected $beepStart = false;

    /**
     * @var Webhook
     */
    protected $eventWebhook;

    /**
     * @return static
     */
    public static function factory(array $data): self
    {
        $action = new self();

        if (array_key_exists('format', $data)) {
            $action->setFormat($data['format']);
        }

        if (array_key_exists('split', $data)) {
            $action->setSplit($data['split']);
        }

        if (array_key_exists('channels', $data)) {
            $action->setChannels($data['channels']);
        }

        if (array_key_exists('endOnSilence', $data)) {
            $action->setEndOnSilence(
                filter_var($data['endOnSilence'], FILTER_VALIDATE_INT, FILTER_NULL_ON_FAILURE)
            );
        }

        if (array_key_exists('endOnKey', $data)) {
            $action->setEndOnKey($data['endOnKey']);
        }

        if (array_key_exists('timeOut', $data)) {
            $action->setTimeout($data['timeOut']);
        }

        if (array_key_exists('beepStart', $data)) {
            $action->setBeepStart(
                filter_var($data['beepStart'], FILTER_VALIDATE_BOOLEAN, ['flags' => FILTER_NULL_ON_FAILURE])
            );
        }

        if (array_key_exists('eventUrl', $data)) {
            if (array_key_exists('eventMethod', $data)) {
                $webhook = new Webhook($data['eventUrl'], $data['eventMethod']);
            } else {
                $webhook = new Webhook($data['eventUrl']);
            }

            $action->setEventWebhook($webhook);
        }

        return $action;
    }

    /**
     * @return array<string, mixed>
     */
    public function jsonSerialize(): array
    {
        return $this->toNCCOArray();
    }

    /**
     * @return array<string, mixed>
     */
    public function toNCCOArray(): array
    {
        $data = [
            'action' => 'record',
            'format' => $this->getFormat(),
            'timeOut' => (string)$this->getTimeout(),
            'beepStart' => $this->getBeepStart() ? 'true' : 'false',
        ];

        if ($this->getEndOnSilence()) {
            $data['endOnSilence'] = (string)$this->getEndOnSilence();
        }

        if ($this->getEndOnKey()) {
            $data['endOnKey'] = $this->getEndOnKey();
        }

        if ($this->getChannels()) {
            $data['channels'] = (string)$this->getChannels();
        }

        if ($this->getSplit()) {
            $data['split'] = $this->getSplit();
        }

        if ($this->getEventWebhook()) {
            $data['eventUrl'] = [$this->getEventWebhook()->getUrl()];
            $data['eventMethod'] = $this->getEventWebhook()->getMethod();
        }

        return $data;
    }

    public function getFormat(): string
    {
        return $this->format;
    }

    /**
     * @return $this
     */
    public function setFormat(string $format): self
    {
        $this->format = $format;

        return $this;
    }

    public function getSplit(): ?string
    {
        return $this->split;
    }

    /**
     * @return $this
     */
    public function setSplit(string $split): self
    {
        if ($split !== 'conversation') {
            throw new InvalidArgumentException('Split value must be "conversation" if enabling');
        }

        $this->split = $split;

        return $this;
    }

    public function getEndOnKey(): ?string
    {
        return $this->endOnKey;
    }

    /**
     * @return $this
     */
    public function setEndOnKey(string $endOnKey): self
    {
        $match = preg_match('/^[*#0-9]$/', $endOnKey);

        if ($match === 0 || $match === false) {
            throw new InvalidArgumentException('Invalid End on Key character');
        }

        $this->endOnKey = $endOnKey;

        return $this;
    }

    public function getEventWebhook(): ?Webhook
    {
        return $this->eventWebhook;
    }

    /**
     * @return $this
     */
    public function setEventWebhook(Webhook $eventWebhook): self
    {
        $this->eventWebhook = $eventWebhook;

        return $this;
    }

    public function getEndOnSilence(): ?int
    {
        return $this->endOnSilence;
    }

    /**
     * @return $this
     */
    public function setEndOnSilence(int $endOnSilence): self
    {
        if ($endOnSilence > 10 || $endOnSilence < 3) {
            throw new InvalidArgumentException('End On Silence value must be between 3 and 10 seconds, inclusive');
        }

        $this->endOnSilence = $endOnSilence;

        return $this;
    }

    public function getTimeout(): int
    {
        return $this->timeOut;
    }

    /**
     * @return $this
     */
    public function setTimeout(int $timeOut): self
    {
        if ($timeOut > 7200 || $timeOut < 3) {
            throw new InvalidArgumentException('TimeOut value must be between 3 and 7200 seconds, inclusive');
        }

        $this->timeOut = $timeOut;

        return $this;
    }

    public function getBeepStart(): bool
    {
        return $this->beepStart;
    }

    /**
     * @return $this
     */
    public function setBeepStart(bool $beepStart): self
    {
        $this->beepStart = $beepStart;

        return $this;
    }

    public function getChannels(): ?int
    {
        return $this->channels;
    }

    /**
     * @return $this
     */
    public function setChannels(int $channels): self
    {
        if ($channels > 32) {
            throw new InvalidArgumentException('Number of channels must be 32 or less');
        }

        if ($channels > 1) {
            $this->channels = $channels;
            $this->setSplit(self::SPLIT);
            $this->format = self::FORMAT_WAV;
        } else {
            $this->channels = null;
            $this->split = null;
        }

        return $this;
    }
}
PK     t[      Voice/NCCO/Action/Stream.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice\NCCO\Action;

use function array_key_exists;
use function filter_var;
use function is_null;

class Stream implements ActionInterface
{
    /**
     * @var bool
     */
    protected $bargeIn;

    /**
     * @var float
     */
    protected $level;

    /**
     * @var int
     */
    protected $loop;

    public function __construct(protected string $streamUrl)
    {
    }

    /**
     * @param array{streamUrl: string, bargeIn?: bool, level?: float, loop?: int, voiceName?: string} $data
     */
    public static function factory(string $streamUrl, array $data): Stream
    {
        $stream = new Stream($streamUrl);

        if (array_key_exists('bargeIn', $data)) {
            $stream->setBargeIn(
                filter_var($data['bargeIn'], FILTER_VALIDATE_BOOLEAN, ['flags' => FILTER_NULL_ON_FAILURE])
            );
        }

        if (array_key_exists('level', $data)) {
            $stream->setLevel(
                filter_var($data['level'], FILTER_VALIDATE_FLOAT, ['flags' => FILTER_NULL_ON_FAILURE])
            );
        }

        if (array_key_exists('loop', $data)) {
            $stream->setLoop(
                filter_var($data['loop'], FILTER_VALIDATE_INT, ['flags' => FILTER_NULL_ON_FAILURE])
            );
        }

        return $stream;
    }

    public function getBargeIn(): ?bool
    {
        return $this->bargeIn;
    }

    public function getLevel(): ?float
    {
        return $this->level;
    }

    public function getLoop(): ?int
    {
        return $this->loop;
    }

    public function getStreamUrl(): string
    {
        return $this->streamUrl;
    }

    /**
     * @return array{action: string, bargeIn: bool, level: float, loop: int, streamUrl: string}
     */
    public function jsonSerialize(): array
    {
        return $this->toNCCOArray();
    }

    /**
     * @return $this
     */
    public function setBargeIn(bool $value): self
    {
        $this->bargeIn = $value;

        return $this;
    }

    /**
     * @return $this
     */
    public function setLevel(float $level): self
    {
        $this->level = $level;

        return $this;
    }

    /**
     * @return $this
     */
    public function setLoop(int $times): self
    {
        $this->loop = $times;

        return $this;
    }

    /**
     * @return array{action: string, bargeIn: bool, level: float, loop: int, streamUrl: string}
     */
    public function toNCCOArray(): array
    {
        $data = [
            'action' => 'stream',
            'streamUrl' => [$this->getStreamUrl()],
        ];

        if (!is_null($this->getBargeIn())) {
            $data['bargeIn'] = $this->getBargeIn() ? 'true' : 'false';
        }

        if (!is_null($this->getLevel())) {
            $data['level'] = (string)$this->getLevel();
        }

        if (!is_null($this->getLoop())) {
            $data['loop'] = (string)$this->getLoop();
        }

        return $data;
    }
}
PK     t[7%  %    Voice/NCCO/Action/Input.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice\NCCO\Action;

use RuntimeException;
use Vonage\Voice\Webhook;

use function array_key_exists;
use function filter_var;
use function is_array;
use function is_null;

class Input implements ActionInterface
{
    /**
     * @var int
     */
    protected $dtmfTimeout;

    /**
     * @var int
     */
    protected $dtmfMaxDigits;

    /**
     * @var bool
     */
    protected $dtmfSubmitOnHash;

    /**
     * @var ?string
     */
    protected $speechUUID;

    /**
     * @var int
     */
    protected $speechEndOnSilence;

    /**
     * @var string
     */
    protected $speechLanguage;

    /**
     * @var array<string>
     */
    protected $speechContext;

    /**
     * @var ?int
     */
    protected $speechStartTimeout;

    /**
     * @var int
     */
    protected $speechMaxDuration;

    /**
     * @var ?Webhook
     */
    protected $eventWebhook;

    /**
     * @var bool
     */
    protected $enableSpeech = false;

    /**
     * @var bool
     */
    protected $enableDtmf = false;

    /**
     * @param array<array, mixed> $data
     */
    public static function factory(array $data): Input
    {
        $action = new self();

        if (array_key_exists('dtmf', $data)) {
            $dtmf = $data['dtmf'];
            $action->setEnableDtmf(true);

            if (array_key_exists('timeOut', $dtmf)) {
                $action->setDtmfTimeout((int)$dtmf['timeOut']);
            }

            if (array_key_exists('maxDigits', $dtmf)) {
                $action->setDtmfMaxDigits((int)$dtmf['maxDigits']);
            }

            if (array_key_exists('submitOnHash', $dtmf)) {
                $action->setDtmfSubmitOnHash(
                    filter_var($dtmf['submitOnHash'], FILTER_VALIDATE_BOOLEAN, ['flags' => FILTER_NULL_ON_FAILURE])
                );
            }
        }

        if (array_key_exists('speech', $data)) {
            $speech = $data['speech'];
            $action->setEnableSpeech(true);

            if (array_key_exists('uuid', $speech)) {
                $action->setSpeechUUID($speech['uuid'][0]);
            }

            if (array_key_exists('endOnSilence', $speech)) {
                $action->setSpeechEndOnSilence((int)$speech['endOnSilence']);
            }

            if (array_key_exists('language', $speech)) {
                $action->setSpeechLanguage($speech['language']);
            }

            if (array_key_exists('context', $speech)) {
                $action->setSpeechContext($speech['context']);
            }

            if (array_key_exists('startTimeout', $speech)) {
                $action->setSpeechStartTimeout((int)$speech['startTimeout']);
            }

            if (array_key_exists('maxDuration', $speech)) {
                $action->setSpeechMaxDuration((int)$speech['maxDuration']);
            }
        }

        if (array_key_exists('eventUrl', $data)) {
            if (is_array($data['eventUrl'])) {
                $data['eventUrl'] = $data['eventUrl'][0];
            }

            if (array_key_exists('eventMethod', $data)) {
                $webhook = new Webhook($data['eventUrl'], $data['eventMethod']);
            } else {
                $webhook = new Webhook($data['eventUrl']);
            }

            $action->setEventWebhook($webhook);
        }

        return $action;
    }

    /**
     * @return array<string, mixed>
     */
    public function jsonSerialize(): array
    {
        return $this->toNCCOArray();
    }

    /**
     * @return array<string, mixed>
     */
    public function toNCCOArray(): array
    {
        $data = [
            'action' => 'input',
        ];

        if ($this->getEnableDtmf() === false && $this->getEnableSpeech() === false) {
            throw new RuntimeException('Input NCCO action must have either speech or DTMF enabled');
        }

        if ($this->getEnableDtmf()) {
            $dtmf = [];

            if ($this->getDtmfTimeout()) {
                $dtmf['timeOut'] = $this->getDtmfTimeout();
            }

            if ($this->getDtmfMaxDigits()) {
                $dtmf['maxDigits'] = $this->getDtmfMaxDigits();
            }

            if (!is_null($this->getDtmfSubmitOnHash())) {
                $dtmf['submitOnHash'] = $this->getDtmfSubmitOnHash() ? 'true' : 'false';
            }

            $data['dtmf'] = (object)$dtmf;
        }

        if ($this->getEnableSpeech()) {
            $speech = [];

            if ($this->getSpeechUUID()) {
                $speech['uuid'] = [$this->getSpeechUUID()];
            }

            if ($this->getSpeechEndOnSilence()) {
                $speech['endOnSilence'] = $this->getSpeechEndOnSilence();
            }

            if ($this->getSpeechLanguage()) {
                $speech['language'] = $this->getSpeechLanguage();
            }

            if ($this->getSpeechMaxDuration()) {
                $speech['maxDuration'] = $this->getSpeechMaxDuration();
            }

            $context = $this->getSpeechContext();

            if (!empty($context)) {
                $speech['context'] = $context;
            }

            $startTimeout = $this->getSpeechStartTimeout();
            if ($startTimeout) {
                $speech['startTimeout'] = $startTimeout;
            }

            $data['speech'] = (object)$speech;
        }

        $eventWebhook = $this->getEventWebhook();

        if ($eventWebhook) {
            $data['eventUrl'] = [$eventWebhook->getUrl()];
            $data['eventMethod'] = $eventWebhook->getMethod();
        }

        return $data;
    }

    public function getDtmfTimeout(): ?int
    {
        return $this->dtmfTimeout;
    }

    /**
     * @return $this
     */
    public function setDtmfTimeout(int $dtmfTimeout): self
    {
        $this->setEnableDtmf(true);
        $this->dtmfTimeout = $dtmfTimeout;

        return $this;
    }

    public function getDtmfMaxDigits(): ?int
    {
        return $this->dtmfMaxDigits;
    }

    /**
     * @return $this
     */
    public function setDtmfMaxDigits(int $dtmfMaxDigits): self
    {
        $this->setEnableDtmf(true);
        $this->dtmfMaxDigits = $dtmfMaxDigits;

        return $this;
    }

    public function getDtmfSubmitOnHash(): ?bool
    {
        return $this->dtmfSubmitOnHash;
    }

    /**
     * @return $this
     */
    public function setDtmfSubmitOnHash(bool $dtmfSubmitOnHash): self
    {
        $this->setEnableDtmf(true);
        $this->dtmfSubmitOnHash = $dtmfSubmitOnHash;

        return $this;
    }

    public function getSpeechUUID(): ?string
    {
        return $this->speechUUID;
    }

    /**
     * @return $this
     */
    public function setSpeechUUID(string $speechUUID): self
    {
        $this->setEnableSpeech(true);
        $this->speechUUID = $speechUUID;

        return $this;
    }

    public function getSpeechEndOnSilence(): ?int
    {
        return $this->speechEndOnSilence;
    }

    /**
     * @return $this
     */
    public function setSpeechEndOnSilence(int $speechEndOnSilence): self
    {
        $this->setEnableSpeech(true);
        $this->speechEndOnSilence = $speechEndOnSilence;

        return $this;
    }

    public function getSpeechLanguage(): ?string
    {
        return $this->speechLanguage;
    }

    /**
     * @return $this
     */
    public function setSpeechLanguage(string $speechLanguage): self
    {
        $this->setEnableSpeech(true);
        $this->speechLanguage = $speechLanguage;

        return $this;
    }

    /**
     * @return array<string>
     */
    public function getSpeechContext(): ?array
    {
        return $this->speechContext;
    }

    /**
     * @param array<string> $speechContext Array of words to help with speech recognition
     *
     * @return Input
     */
    public function setSpeechContext(array $speechContext): self
    {
        $this->setEnableSpeech(true);
        $this->speechContext = $speechContext;

        return $this;
    }

    public function getSpeechStartTimeout(): ?int
    {
        return $this->speechStartTimeout;
    }

    /**
     * @return $this
     */
    public function setSpeechStartTimeout(int $speechStartTimeout): self
    {
        $this->setEnableSpeech(true);
        $this->speechStartTimeout = $speechStartTimeout;

        return $this;
    }

    public function getSpeechMaxDuration(): ?int
    {
        return $this->speechMaxDuration;
    }

    public function setSpeechMaxDuration(int $speechMaxDuration): self
    {
        $this->setEnableSpeech(true);
        $this->speechMaxDuration = $speechMaxDuration;

        return $this;
    }

    public function getEventWebhook(): ?Webhook
    {
        return $this->eventWebhook;
    }

    /**
     * @return $this
     */
    public function setEventWebhook(Webhook $eventWebhook): self
    {
        $this->eventWebhook = $eventWebhook;

        return $this;
    }

    public function getEnableSpeech(): bool
    {
        return $this->enableSpeech;
    }

    /**
     * @return $this
     */
    public function setEnableSpeech(bool $enableSpeech): Input
    {
        $this->enableSpeech = $enableSpeech;

        return $this;
    }

    public function getEnableDtmf(): bool
    {
        return $this->enableDtmf;
    }

    /**
     * @return $this
     */
    public function setEnableDtmf(bool $enableDtmf): Input
    {
        $this->enableDtmf = $enableDtmf;

        return $this;
    }
}
PK     t[p    %  Voice/NCCO/Action/ActionInterface.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice\NCCO\Action;

use JsonSerializable;

interface ActionInterface extends JsonSerializable
{
    /**
     * @return array<string, string>
     */
    public function toNCCOArray(): array;
}
PK     t[DGS  S    Voice/NCCO/Action/Pay.phpnu [        <?php

declare(strict_types=1);

namespace Vonage\Voice\NCCO\Action;

use InvalidArgumentException;

/**
 * @deprecated This will be removed in the next major version as it is being removed from the API
 */
class Pay implements ActionInterface
{
    protected const PERMITTED_VOICE_KEYS = ['language', 'style'];

    protected const PERMITTED_ERROR_KEYS = [
        'CardNumber' => [
            'InvalidCardType',
            'InvalidCardNumber',
            'Timeout'
        ],
        'ExpirationDate' => [
            'InvalidExpirationDate',
            'Timeout'
        ],
        'SecurityCode' => [
            'InvalidSecurityCode',
            'Timeout'
        ]
    ];

    /**
     * @var float
     */
    protected float $amount;

    /**
     * @var string
     */
    protected string $currency;

    /**
     * @var string
     */
    protected string $eventUrl;

    /**
     * @var array
     */
    protected array $prompts;

    /**
     * @var array
     */
    protected array $voice;

    /**
     * @return float
     */
    public function getAmount(): float
    {
        return $this->amount;
    }

    public function setAmount(float $amount): void
    {
        $this->amount = $amount;
    }

    public function getCurrency(): ?string
    {
        return $this->currency;
    }

    public function setCurrency(?string $currency): void
    {
        $this->currency = $currency;
    }

  