    */
    public function setTtl(int $ttl): self
    {
        if ($ttl < 20000 || $ttl > 604800000) {
            throw new InvalidArgumentException('SMS TTL must be in the range of 20000-604800000 milliseconds');
        }

        $this->ttl = $ttl;

        return $this;
    }

    public function getRequestDeliveryReceipt(): bool
    {
        return $this->requestDeliveryReceipt;
    }

    /**
     * @return $this
     */
    public function setRequestDeliveryReceipt(bool $requestDeliveryReceipt): self
    {
        $this->requestDeliveryReceipt = $requestDeliveryReceipt;

        return $this;
    }

    public function getDeliveryReceiptCallback(): ?string
    {
        return $this->deliveryReceiptCallback;
    }

    /**
     * @return $this
     */
    public function setDeliveryReceiptCallback(string $deliveryRecePK     @Fs[    $  Faker/Extension/CountryExtension.phpnu [        llback;
        $this->setRequestDeliveryReceipt(true);

        return $this;
    }

    public function getMessageClass(): int
    {
        return $this->messageClass;
    }

    /**
     * @return $this
     */
    public function setMessageClass(int $mePK     @Fs[G  G    Faker/Provider/th_TH/Person.phpnu [                   throw new InvalidArgumentException('Message Class must be 0-3');
        }

        $this->messageClass = $messageClass;

        return $this;
    }

    public function getClientRef(): string
    {
        return $this->clientRef;
    }

    /**
     * @return $this
     */
    public function setClientRef(string $clientRef): self
    {
        if (strlen($clientRef) > 40) {
            throw new InvalidArgumentException('Client Ref can be no more than 40 characters');
        }

        $this->clientRef = $clientRef;

        return $this;
    }

    /**
     * This adds any additional options to an individual SMS request
     * This allows the child classes to set their special request options,
     * and then filter through here for additional request options;
     */
    protected function appendUniversalOptions(array $data): array
    {
        $data = array_merge($data, [
            'to' => $this->getTo(),
            'from' => $this->getFrom(),
            'type' => $this->getType(),
            'ttl' => $this->getTtl(),
            'status-report-req' => (int)$this->getRequestDeliveryReceipt(),
        ]);

        if ($this->getRequestDeliveryReceipt() && !is_null($this->getDeliveryReceiptCallback())) {
            $data['callback'] = $this->getDeliveryReceiptCallback();
        }

        if (!is_null($this->messageClass)) {
            $data['message-class'] = $this->getMessageClass();
        }

        if ($this->accountRef) {
            $data['account-ref'] = $this->getAccountRef();
        }

        if ($this->clientRef) {
            $data['client-ref'] = $this->getClientRef();
        }

        return $data;
    }

    public function getFrom(): string
    {
        return $this->from;
    }

    public function getTo(): string
    {
        return $this->to;
    }

    public function getAccountRef(): ?string
    {
        return $this->accountRef;
    }

    /**
     * @return $this
     */
    public function setAccountRef(string $accountRef): OutboundMessage
    {
        $this->accountRef = $accountRef;

        return $this;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function setType(string $type): OutboundMessage
    {
        $this->type = $type;

        return $this;
    }
}
PK     t[E$      SMS/Message/Binary.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\SMS\Message;

class Binary extends OutboundMessage
{
    /**
     * @var string
     */
    protected string $type = 'binary';

    public function __construct(string $to, string $from, protected string $body, protected string $udh, protected ?int $protocolId = null)
    {
        parent::__construct($to, $from);
    }

    /**
     * @return mixed
     */
    public function toArray(): array
    {
        $data = [
            'body' => $this->getBody(),
            'udh' => $this->getUdh(),
        ];

        if ($this->getProtocolId()) {
            $data['protocol-id'] = $this->getProtocolId();
        }

        $data = $this->appendUniversalOptions($data);

        return $data;
    }

    public function getBody(): string
    {
        return $this->body;
    }

    public function getUdh(): string
    {
        return $this->udh;
    }

    public function getProtocolId(): ?int
    {
        return $this->protocolId;
    }
}
PK     t[:Ů	  	    Network/Number/Callback.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Network\Number;

use BadMethodCallException;
use Vonage\Client\Callback\Callback as BaseCallback;

use function substr;

/**
 * @method null|string getType()
 * @method bool hasType()
 * @method null|string getNetwork()
 * @method bool hasNetwork()
 * @method null|string getNetworkName()
 * @method bool hasNetworkName()
 * @method null|string getValid()
 * @method bool hasValid()
 * @method null|string getPorted()
 * @method bool hasPorted()
 * @method null|string getReachable()
 * @method bool hasReachable()
 * @method null|string getRoaming()
 * @method bool hasRoaming()
 * @method null|string getRoamingCountry()
 * @method bool hasRoamingCountry()
 * @method null|string getRoamingNetwork()
 * @method bool hasRoamingNetwork()
 */
class Callback extends BaseCallback
{
    protected $expected = ['request_id', 'callback_part', 'callback_total_parts', 'number', 'status'];
    protected $optional = [
        'Type' => 'number_type',
        'Network' => 'carrier_network_code',
        'NetworkName' => 'carrier_network_name',
        'Valid' => 'valid',
        'Ported' => 'ported',
        'Reachable' => 'reachable',
        'Roaming' => 'roaming',
        'RoamingCountry' => 'roaming_country_code',
        'RoamingNetwork' => 'roaming_network_code',
    ];

    public function getId()
    {
        return $this->data['request_id'];
    }

    public function getCallbackTotal()
    {
        return $this->data['callback_total_parts'];
    }

    public function getCallbackIndex()
    {
        return $this->data['callback_part'];
    }

    public function getNumber()
    {
        return $this->data['number'];
    }

    /**
     * @param $name
     * @param $args
     */
    public function __call($name, $args)
    {
        $type = substr($name, 0, 3);
        $property = substr($name, 3);

        if (!isset($this->optional[$property])) {
            throw new BadMethodCallException('property does not exist: ' . $property);
        }

        $property = $this->optional[$property];
        return match ($type) {
            'get' => $this->data[$property] ?? null,
            'has' => isset($this->data[$property]),
            default => throw new BadMethodCallException('method does not exist: ' . $name),
        };
    }
}
PK     t[9      Network/Number/Request.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Network\Number;

use Vonage\Client\Request\AbstractRequest;
use Vonage\Client\Request\WrapResponseInterface;
use Vonage\Client\Response\Error;
use Vonage\Client\Response\ResponseInterface;

use function implode;

class Request extends AbstractRequest implements WrapResponseInterface
{
    public const FEATURE_TYPE = 'type';
    public const FEATURE_VALID = 'valid';
    public const FEATURE_REACHABLE = 'reachable';
    public const FEATURE_CARRIER = 'carrier';
    public const FEATURE_PORTED = 'ported';
    public const FEATURE_ROAMING = 'roaming';
    public const FEATURE_SUBSCRIBER = 'subscriber';

    /**
     * @var array
     */
    protected $params;

    /**
     * @param $number
     * @param $callback
     */
    public function __construct($number, $callback, array $features = [], $timeout = null, $method = null, $ref = null)
    {
        $this->params['number'] = $number;
        $this->params['callback'] = $callback;
        $this->params['callback_timeout'] = $timeout;
        $this->params['callback_method'] = $method;
        $this->params['client_ref'] = $ref;

        if (!empty($features)) {
            $this->params['features'] = implode(',', $features);
        }
    }

    public function getURI(): string
    {
        return '/ni/json';
    }

    public function wrapResponse(ResponseInterface $response): ResponseInterface
    {
        if ($response->isError()) {
            return new Error($response->getData());
        }

        return new Response($response->getData());
    }
}
PK     t[_Yl      Network/Number/Response.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Network\Number;

use BadMethodCallException;
use InvalidArgumentException;
use Vonage\Client\Response\Response as BaseResponse;

use function array_merge;
use function count;

class Response extends BaseResponse
{
    protected $callbacks = [];

    public function __construct(array $data, array $callbacks = [])
    {
        //add expected keys
        $this->expected = array_merge($this->expected, [
            'request_id',
            'number',
            'request_price',
            'remaining_balance',
            'callback_total_parts'
        ]);

        parent::__construct($data);

        foreach ($callbacks as $callback) {
            if (!($callback instanceof Callback)) {
                throw new InvalidArgumentException('callback must be of type: Vonage\Network\Number\Callback');
            }

            if ($callback->getId() !== $this->getId()) {
                throw new InvalidArgumentException('callback id must match request id');
            }
        }

        $this->callbacks = $callbacks;
    }

    public function getCallbackTotal()
    {
        return $this->data['callback_total_parts'];
    }

    public function isComplete(): bool
    {
        return count($this->callbacks) === $this->getCallbackTotal();
    }

    public function getPrice()
    {
        return $this->data['request_price'];
    }

    public function getBalance()
    {
        return $this->data['remaining_balance'];
    }

    public function getNumber()
    {
        return $this->data['number'];
    }

    public function getId()
    {
        return $this->data['request_id'];
    }

    public function getStatus()
    {
        return $this->data['status'];
    }

    /**
     * @param $name
     * @param $args
     *
     * @todo This looks somewhat illogical
     */
    public function __call($name, $args)
    {
        if (empty($this->callbacks)) {
            throw new BadMethodCallException('can not check for response data without callback data');
        }

        foreach ($this->callbacks as $callback) {
            if ($last = $callback->$name()) {
                return $last;
            }
        }

        /** @noinspection PhpUndefinedVariableInspection */
        return $last;
    }

    public function getCallbacks(): array
    {
        return $this->callbacks;
    }

    public static function addCallback(Response $response, callable $callback): Response
    {
        $callbacks = $response->getCallbacks();
        $callbacks[] = $callback;

        return new static($response->getData(), $callbacks);
    }
}
PK     t[#  #    Voice/CallAction.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice;

/**
 * Collection of actions that can be used to modify a call
 */
class CallAction
{
    public const EARMUFF = 'earmuff';
    public const HANGUP = 'hangup';
    public const MUTE = 'mute';
    public const UNEARMUFF = 'unearmuff';
    public const UNMUTE = 'unmute';
}
PK     t[D&"  "    Voice/NCCO/NCCOFactory.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice\NCCO;

use InvalidArgumentException;
use Vonage\Voice\Endpoint\EndpointFactory;
use Vonage\Voice\NCCO\Action\ActionInterface;
use Vonage\Voice\NCCO\Action\Connect;
use Vonage\Voice\NCCO\Action\Conversation;
use Vonage\Voice\NCCO\Action\Input;
use Vonage\Voice\NCCO\Action\Notify;
use Vonage\Voice\NCCO\Action\Record;
use Vonage\Voice\NCCO\Action\Stream;
use Vonage\Voice\NCCO\Action\Talk;

class NCCOFactory
{
    /**
     * @param $data
     */
    public function build($data): ActionInterface
    {
        switch ($data['action']) {
            case 'connect':
                $factory = new EndpointFactory();
                $endpoint = $factory->create($data['endpoint'][0]);

                if (null !== $endpoint) {
                    return Connect::factory($endpoint);
                }

                throw new InvalidArgumentException("Malformed NCCO Action " . $data['endpoint'][0]);
            case 'conversation':
                return Conversation::factory($data['name'], $data);
            case 'input':
                return Input::factory($data);
            case 'notify':
                return Notify::factory($data['payload'], $data);
            case 'record':
                return Record::factory($data);
            case 'stream':
                return Stream::factory($data['streamUrl'], $data);
            case 'talk':
                return Talk::factory($data['text'], $data);
            default:
                throw new InvalidArgumentException("Unknown NCCO Action " . $data['action']);
        }
    }
}
PK     t[%,L  L    Voice/NCCO/NCCO.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice\NCCO;

use JsonSerializable;
use Vonage\Entity\Hydrator\ArrayHydrateInterface;
use Vonage\Voice\NCCO\Action\ActionInterface;

class NCCO implements ArrayHydrateInterface, JsonSerializable
{
    /**
     * @var array<ActionInterface>
     */
    protected $actions = [];

    /**
     * @return $this
     */
    public function addAction(ActionInterface $action): self
    {
        $this->actions[] = $action;
        return $this;
    }

    public function fromArray(array $data): void
    {
        $factory = new NCCOFactory();

        foreach ($data as $rawNCCO) {
            $action = $factory->build($rawNCCO);
            $this->addAction($action);
        }
    }

    /**
     * @return array<array<string, string>>
     */
    public function jsonSerialize(): array
    {
        return $this->toArray();
    }

    /**
     * @return array<array<string, string>>
     */
    public function toArray(): array
    {
        $data = [];

        foreach ($this->actions as $action) {
            $data[] = $action->toNCCOArray();
        }

        return $data;
    }
}
PK     t[B    "  Voice/NCCO/Action/Conversation.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Voice\NCCO\Action;

use Vonage\Voice\Webhook;

use function array_key_exists;
use function filter_var;
use function is_array;
use function is_null;

class Conversation implements ActionInterface
{
    /**
     * @var ?string
     */
    protected $musicOnHoldUrl;

    /**
     * @var bool
     */
    protected $startOnEnter;

    /**
     * @var bool
     */
    protected $endOnExit;

    /**
     * @var bool
     */
    protected $record;

    /**
     * @var ?array<string>
     */
    protected $canSpeak;

    /**
     * @var ?array<string>
     */
    protected $canHear;

    /**
     * @var Webhook
     */
    protected $eventWebhook;

    public function __construct(protected string $name)
    {
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getMusicOnHoldUrl(): ?string
    {
        return $this->musicOnHoldUrl;
    }

    /**
     * @return $this
     */
    public function setMusicOnHoldUrl(string $musicOnHoldUrl): self
    {
        $this->musicOnHoldUrl = $musicOnHoldUrl;

        return $this;
    }

    public function getStartOnEnter(): ?bool
    {
        return $this->startOnEnter;
    }

    /**
     * @return $this
     */
    public function setStartOnEnter(bool $startOnEnter): self
    {
        $this->startOnEnter = $startOnEnter;

        return $this;
    }

    public function getEndOnExit(): ?bool
    {
        return $this->endOnExit;
    }

    /**
     * @return $this
     */
    public function setEndOnExit(bool $endOnExit): self
    {
        $this->endOnExit = $endOnExit;

        return $this;
    }

    public function getRecord(): ?bool
    {
        return $this->record;
    }

    /**
     * @return $this
     */
    public function setRecord(bool $record): self
    {
        $this->record = $record;

        return