
     * @throws ClientException\Exception
     * @throws ClientException\Request
     * @throws ClientException\Server
     */
    protected function control($verification, string $cmd): Verification
    {
        if (is_array($verification)) {
            trigger_error(
                'Passing an array for parameter 1 to Vonage\Verification\Client::control() is deprecated,' .
                'please pass a string ID PK     DFs[y57    !  Faker/Provider/zh_CN/Internet.phpnu [        ification instanceof Verification) {
            trigger_error(
                'Passing a Verification object for parameter 1 to Vonage\Verification\Client::control() ' .
                'is deprecated, please pass a string ID instead',
                E_USER_DEPRECATED
            );
        }

        $api = $this->getApiResource();
        $verification = $this->createVerification($verification);

        $params = [
            'request_id' => $verification->getRequestId(),
            'cmd' => $cmd
        ];

        $data = $api->create($params, '/control/json');
        $this->processReqRes($verification, $api->getLastRequest(), $api->getLastResponse(), false)PK     EFs[jR{       Faker/Provider/zh_CN/Address.phpnu [         @param $verification
     * @param $data
     *
     * @throws ClientException\Request
     * @throws ClientException\Server
     */
    protected function checkError($verification, $data)
    {
        if (!isset($data['status'])) {
            $e = new ClientException\Request('unexpected response from API');
            $e->setEntity($data);

            throw $e;
        }

        //normalize errors (client vrs server)
        switch ($data['status']) {
            // These exist because `status` is valid in both the error
            // response and a success response, but serve different purposes
            // in each case
            case 'IN PROGRESS':
            case 'SUCCESS':
            case 'FAILED':
            case 'EXPIRED':
            case 'CANCELLED':
            case '0':
                return $verification;
            case '5':
                $e = new ClientException\Server($data['error_text'], (int)$data['status']);
                $e->setEntity($data);
                break;
            default:
                $e = new ClientException\Request($data['error_text'], (int)$data['status']);
                $e->setEntity($data);

                if (array_key_exists('request_id', $data)) {
                    $e->setRequestId($data['request_id']);
                }

                if (array_key_exists('network', $data)) {
                    $e->setNetworkId($data['network']);
                }

                break;
        }

        $e->setEntity($verification);

        throw $e;
    }

    /**
     * @param bool $replace
     */
    protected function processReqRes(
        Verification $verification,
        RequestInterface $req,
        ResponseInterface $res,
        $replace = true
    ): void {
        @$verification->setClient($this);

        if ($replace || !@$verification->getRequest()) {
            @$verification->setRequest($req);
        }

        if ($replace || !@$verification->getResponse()) {
            @$verification->setResponse($res);
        }

        if ($res->getBody()->isSeekable()) {
            $res->getBody()->rewind();
        }
    }

    /**
     * Creates a verification object from a variety of sources
     *
     * @param $verification
     */
    protected function createVerification($verification): Verification
    {
        if ($verification instanceof Verification) {
            return $verification;
        }

        if (is_array($verification)) {
            return $this->createVerificationFromArray($verification);
        }

        if (is_string($verification)) {
            return new Verification($verification);
        }

        throw new RuntimeException('Unable to create Verification object from source data');
    }

    /**
     * @param $array
     */
    protected function createVerificationFromArray($array): Verification
    {
        if (!is_array($array)) {
            throw new RuntimeException('verification must implement `' . VerificationInterface::class .
                '` or be an array`');
        }

        foreach (['number', 'brand'] as $param) {
            if (!isset($array[$param])) {
                throw new InvalidArgumentException('missing expected key `' . $param . '`');
            }
        }

        $number = $array['number'];
        $brand = $array['brand'];

        unset($array['number'], $array['brand']);

        return @new Verification($number, $brand, $array);
    }
}
PK     t[!_      Verify/RequestPSD2.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Verify;

use InvalidArgumentException;
use Vonage\Entity\Hydrator\ArrayHydrateInterface;

use function array_key_exists;
use function strlen;

class RequestPSD2 implements ArrayHydrateInterface
{
    public const PIN_LENGTH_4 = 4;
    public const PIN_LENGTH_6 = 6;

    public const WORKFLOW_SMS_TTS_TSS = 1;
    public const WORKFLOW_SMS_SMS_TSS = 2;
    public const WORKFLOW_TTS_TSS = 3;
    public const WORKFLOW_SMS_SMS = 4;
    public const WORKFLOW_SMS_TTS = 5;
    public const WORKFLOW_SMS = 6;
    public const WORKFLOW_TTS = 7;

    /**
     * @var string
     */
    protected $country;

    /**
     * @var int
     */
    protected $codeLength;

    /**
     * @var string
     */
    protected $locale;

    /**
     * @var int
     */
    protected $pinExpiry;

    /**
     * @var int
     */
    protected $nextEventWait;

    /**
     * @var int
     */
    protected $workflowId;

    public function __construct(protected string $number, protected string $payee, protected string $amount, int $workflowId = null)
    {
        if ($workflowId) {
            $this->setWorkflowId($workflowId);
        }
    }

    public function getCountry(): ?string
    {
        return $this->country;
    }

    /**
     * @return $this
     */
    public function setCountry(string $country): self
    {
        if (strlen($country) !== 2) {
            throw new InvalidArgumentException('Country must be in two character format');
        }

        $this->country = $country;

        return $this;
    }

    public function getCodeLength(): ?int
    {
        return $this->codeLength;
    }

    /**
     * @return $this
     */
    public function setCodeLength(int $codeLength): self
    {
        if ($codeLength !== 4 || $codeLength !== 6) {
            throw new InvalidArgumentException('Pin length must be either 4 or 6 digits');
        }

        $this->codeLength = $codeLength;

        return $this;
    }

    public function getLocale(): ?string
    {
        return $this->locale;
    }

    /**
     * @return $this
     */
    public function setLocale(string $locale): self
    {
        $this->locale = $locale