
        return $this->pinExpiry;
    }

    /**
     * @return $this
     */
    public function setPinExpiry(int $pinExpiry): self
    {
        if ($pinExpiry < 60 || $pinExpiry > 3600) {
            throw new InvalidArgumentException('Pin expiration must be between 60 and 3600 seconds');
        }

        $this->pinExpiry = $pinExpiry;

        return $this;
    }

    public function getNextEventWait(): ?int
    {
        return $this->nextEventWait;
    }

    /**
     * @return $this
     */
    public function setNextEventWait(int $nextEventWait): self
    {
        if ($nextEventWait < 60 || $nextEventWait > 3600) {
            throw new InvalidArgumentException('Next Event time must be between 60 and 900 seconds');
        }

        $this->nextEventWait = $nextEventWait;

        return $this;
    }

    public function getWorkflowId(): ?int
    {
        return $this->workflowId;
    }

    /**
     * @return $this
     */
    public function setWorkflowId(int $workflowId): self
    {
        if ($workflowId < 1 || $workflowId > 7) {
            throw new InvalidArgumentException('Workflow ID must be from 1 to 7');
        }

        $this->workflowIdPK     EFs[Xv  v    Faker/Provider/zh_CN/Color.phpnu [         string
    {
        return $this->number;
    }

    public function getPayee(): string
    {
        return $this->payee;
    }

    public function getAmount(): string
    {
        return $this->amount;
    }

    public function fromArray(array $data): void
    {
        if (array_key_exists('code_length', $data)) {
            $this->setCodeLength($data['code_length']);
        }

        if (array_key_exists('pin_expiry', $data)) {
            $this->setPinExpiry($data['pin_expiry']);
        }

        if (array_key_exists('next_event_wait', $data)) {
            $this->setNextEventWait($data['next_event_wait']);
        }

        if (array_key_exists('workflow_id', $data)) {
            $this->setWorkflowId($data['workflow_id']);
        }

        if (array_key_exists('country', $data)) {
            $this->setCountry($data['country']);
        }

        if (array_key_exists('lg', $data)) {
            $this->setLocale($data['lg']);
        }
    }

    /**
     * @return string[]
     */
    public function toArray(): array
    {
        $data = [
            'number' => $this->getNumber(),
            'amount' => $this->getAmount(),
            'payee' => $this->getPayee(),
        ];

        if ($this->getCodeLength()) {
            $data['code_length'] = $this->getCodeLength();
        }

        if ($this->getPinExpiry()) {
            $data['pin_expiry'] = $this->getPinExpiry();
        }

        if ($this->getNextEventWait()) {
            $data['next_event_wait'] = $this->getNextEventWait();
        }

        if ($this->getWorkflowId()) {
            $data['workflow_id'] = $this->getWorkflowId();
        }

        if ($this->getCountry()) {
            $data['country'] = $this->getCountry();
        }

        if ($this->getLocale()) {
            $data['lg'] = $this->getLocale();
        }

        return $data;
    }
}
PK     t[:1^       Verify/ExceptionErrorHandler.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Verify;

use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Vonage\Client\Exception\Request;
use Vonage\Client\Exception\Server;

use function json_decode;

/**
 * Error handler for API requests returned by the Verify API
 */
class ExceptionErrorHandler
{
    /**
     * @todo This should throw a Server exception instead of Request, fix next major release
     * @throws Request
     */
    public function __invoke(ResponseInterface $respo