$type]['webhooks'][$constant] = [
                        'address' => $webhook->getUrl(),
                        'http_method' => $webhook->getMethod(),
                    ];

                    if (!is_null($webhook->getConnectionTimeout())) {
                        $capabilities[$type]['webhooks'][$constant]['connection_timeout'] = $webhook->getConnectionTimeout();
                    }

                    if (!is_null($webhook->getSocketTimeout())) {
                        $capabilities[$type]['webhooks'][$constant]['socket_timeout'] = $webhook->getSocketTimeout();
                    }
                }
            }
        }

        // Handle other Voice capabilities outside of that needlessly complicated webhook loop
        if (!is_null($this->getVoiceConfig()->getRegion())) {
            $capabilities['voice']['region'] = $this->getVoiceConfig()->getRegion();
        }

        if (!is_null($this->getVoiceConfig()->getConversationsTtl())) {
            $capabilities['voice']['conversations_ttl'] = $this->getVoiceConfig()->getConversationsTtl();
        }

        if (!is_null($this->getVoiceConfig()->getSignedCallbacks())) {
            $capabilPK     DFs[{%  {%     Faker/Provider/zh_CN/Company.phpnu [        ();
        }

        // Handle VBC specifically
        if ($this->getVbcConfig()->isEnabled()) {
            $capabilities['vbc'] = new StdClass();
        }

        // Workaround API bug. It expects an object and throws 500
        // if it gets an array
        if (!count($capabilities)) {
            $capabilities = (object)$capabilities;
        }

        return [
            'id' => $this->getId(),
            'name' => $this->getName(),
            'keys' => [
                'public_key' => $this->getPublicKey()
            ],
            'capabilities' => $capabilities
        ];
    }
}
PK     t[      Application/MessagesConfig.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Application;

use function trigger_error;

class MessagesConfig
{
    public const INBOUND = 'inbound_url';
    public const STATUS = 'status_url';

    /**
     * @var array
     */
    protected $webhooks = [];

    public function setWebhook($type, $url, $method = null): self
    {
        if (!$url instanceof Webhook) {
            trigger_error(
                'Passing a string URL and method are deprecated, please pass a Webhook object instead',
                E_USER_DEPRECATED
            );

            $url = new Webhook($url, $method);
        }

        $this->webhooks[$type] = $url;

        return $this;
    }

    public function getWebhook($type)
    {
        return $this->webhooks[$type] ?? null;
    }
}
PK     t[.>      Verify/ClientFactory.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Verify;

use Psr\Container\ContainerInterface;
use Vonage\Client\APIResource;
use Vonage\Client\Credentials\Handler\BasicHandler;
use Vonage\Client\Credentials\Handler\KeypairHandler;
use Vonage\Client\Credentials\Handler\TokenBodyHandler;

class ClientFactory
{

    public function __invoke(ContainerInterface $container): Client
    {
        /** @var APIResource $api */
        $api = $container->make(APIResource::class);
        $api
            ->setIsHAL(false)
            ->setBaseUri('/verify')
            ->setErrorsOn200(true)
            ->setAuthHandler(new TokenBodyHandler())
            ->setExceptionErrorHandler(new ExceptionErrorHandler());

        return new Client($api);
    }
}
PK     t[,2  2    Verify/Client.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage\Verify;

use InvalidArgumentException;
use Psr\Http\Client\ClientExceptionInterface;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use RuntimeException;
use Vonage\Client\APIClient;
use Vonage\Client\APIResource;
use Vonage\Client\ClientAwareInterface;
use Vonage\Client\ClientAwareTrait;
use Vonage\Client\Exception as ClientException;

use function get_class;
use function is_array;
use function is_null;
use function is_string;
use function serialize;
use function trigger_error;
use function unserialize;

class Client implements ClientAwareInterface, APIClient
{
    use ClientAwareTrait;

    public function __construct(protected ?APIResource $api = null)
    {
    }

    /**
     * Shim to handle older instantiations of this class
     * Will change in v3 to just return the required API object
     */
    public function getApiResource(): APIResource
    {
        if (is_null($this->api)) {
            $api = new APIResource();
            $api->setClient($this->getClient())
                ->setIsHAL(false)
                ->setBaseUri('/verify');
            $this->api = $api;
        }

        return $this->api;
    }

    /**
     * @param string|array|Verification|Request $verification
     *
     * @throws ClientExceptionInterface
     * @throws ClientException\Exception
     * @throws ClientException\Request
     * @throws ClientException\Server
     */
    public function start($verification): Verification
    {
        if (is_array($verification)) {
            trigger_error(
                'Passing an array to Vonage\Verification\Client::start() is deprecated, ' .
                'please pass a Vonage\Verify\Request object instead',
                E_USER_DEPRECATED
            );
        } elseif (is_string($verification)) {
            trigger_error(
                'Passing a string to Vonage\Verification\Client::start() is deprecated, ' .
                'please pass a Vonage\Verify\Request object instead',
                E_USER_DEPRECATED
            );
        }

        if ($verification instanceof Request) {
            // Reformat to an array to work with v2.x code, but prep for v3.0.0
            $verification = $verification->toArray();
        }

        $api = $this->getApiResource();
        $verification = $this->createVerification($verification);
        $response = $api->create($verification->toArray(), '/json');

        $this->processReqRes($verification, $api->getLastRequest(), $api->getLastResponse(), true);

        return $this->checkError($verification, $response);
    }

    /**
     * @throws ClientExceptionInterface
     * @throws ClientException\Exception
     * @throws ClientException\Request
     * @throws ClientException\Server
     *
     * @return array{request_id: string, status: string}
     */
    public function requestPSD2(RequestPSD2 $request): array
    {
        $api = $this->getApiResource();
        $response = $api->create($request->toArray(), '/psd2/json');

        $this->checkError($request, $response);

        return $response;
    }

    /**
     * @param string|Verification $verification
     *
     * @throws ClientExceptionInterface
     * @throws ClientException\Exception
     * @throws ClientException\Request
     * @throws ClientException\Server
     */
    public function search($verification)
    {
        if ($verification instanceof Verification) {
            trigger_error(
                'Passing a Verification object to Vonage\Verification\Client::search() is deprecated, ' .
                'please pass a string ID instead',
                E_USER_DEPRECATED
            );
        }

        $api = $this->getApiResource();
        $verification = $this->createVerification($verification);

        $params = [
            'request_id' => $verification->getRequestId()
        ];

        $data = $api->create($params, '/search/json');
        $this->processReqRes($verification, $api->getLastRequest(), $api->getLastResponse(), true);

        return $this->checkError($verification, $data);
    }

    /**
     * @param $verification
     *
     * @throws ClientExceptionInterface
     * @throws ClientException\Exception
     * @throws ClientException\Request
     * @throws ClientException\Server
     */
    public function cancel($verification): Verification
    {
        if ($verification instanceof Verification) {
            trigger_error(
                'Passing a Verification object to Vonage\Verification\Client::cancel() is deprecated, ' .
                'please pass a string ID instead',
                E_USER_DEPRECATED
            );
        }

        return $this->control($verification, 'cancel');
    }

    /**
     * @param $verification
     *
     * @throws ClientExceptionInterface
     * @throws ClientException\Exception
     * @throws ClientException\Request
     * @throws ClientException\Server
     */
    public function trigger($verification): Verification
    {
        if ($verification instanceof Verification) {
            trigger_error(
                'Passing a Verification object to Vonage\Verification\Client::trigger() is deprecated, ' .
                'please pass a string ID instead',
                E_USER_DEPRECATED
            );
        