eConfig());
            $data = $this->getResponseData();

            if (isset($data['voice']['webhooks'])) {
                foreach ($data['voice']['webhooks'] as $webhook) {
                    $this->voiceConfig->setWebhook(
                        $webhook['endpoint_type'],
                        $webhook['endpoint'],
                        $webhook['http_method']
                    );
                }
            }
        }

        return $this->voiceConfig;
    }

    /**
     * @throws Exception
     */
    public function getMessagesConfig(): MessagesConfig
    {
        if (!isset($this->messagesConfig)) {
            $this->setMessagesConfig(new MessagesConfig());
            $data = $this->getResponseData();

            if (isset($data['messages']['webhooks'])) {
                foreach ($data['messages']['webhooks'] as $webhook) {
                    $this->getMessagesConfig()->setWebhook(
                        $webhook['endpoint_type'],
                        $webhook['endpoint'],
                        $webhook['http_method']
                    );
                }
            }
        }

        return $this->messagesConfig;
    }

PK     DFs[L      Faker/Provider/zh_CN/Person.phpnu [        cConfig
    {
        if (!isset($this->rtcConfig)) {
            $this->setRtcConfig(new RtcConfig());
            $data = $this->getResponseData();

            if (isset($data['rtc']['webhooks'])) {
                foreach ($data['rtc']['webhooks'] as $webhook) {
                    $this->getRtcConfig()->setWebhook(
                        $webhook['endpoint_type'],
                        $webhook['endpoint'],
                        $webhook['http_method']
                    );
                }
            }
        }

        return $this->rtcConfig;
    }

    public function getVbcConfig(): VbcConfig
    {
        if (!isset($this->vbcConfig)) {
            $this->setVbcConfig(new VbcConfig());
        }

        return $this->vbcConfig;
    }

    public function setPublicKey(?string $key): self
    {
        $this->keys['public_key'] = $key;

        return $this;
    }

    public function getPublicKey(): ?string
    {
        return $this->keys['public_key'] ?? null;
    }

    public function getPrivateKey(): ?string
    {
        return $this->keys['private_key'] ?? null;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function jsonSerialize(): array
    {
        return $this->toArray();
    }

    public function __toString(): string
    {
        return (string)$this->getId();
    }

    public function fromArray(array $data): void
    {
        $this->name = $data['name'];
        $this->id = $data['id'] ?? null;
        $this->keys = $data['keys'] ?? [];

        if (isset($data['capabilities'])) {
            $capabilities = $data['capabilities'];

            //todo: make voice  hydrate-able
            $this->voiceConfig = new VoiceConfig();
            if (isset($capabilities['voice']['webhooks'])) {
                foreach ($capabilities['voice']['webhooks'] as $name => $details) {
                    $this->voiceConfig->setWebhook($name, new Webhook($details['address'], $details['http_method']));
                }
            }

            //todo: make messages  hydrate-able
            $this->messagesConfig = new MessagesConfig();
            if (isset($capabilities['messages']['webhooks'])) {
                foreach ($capabilities['messages']['webhooks'] as $name => $details) {
                    $this->messagesConfig->setWebhook($name, new Webhook($details['address'], $details['http_method']));
                }
            }

            //todo: make rtc  hydrate-able
            $this->rtcConfig = new RtcConfig();
            if (isset($capabilities['rtc']['webhooks'])) {
                foreach ($capabilities['rtc']['webhooks'] as $name => $details) {
                    $this->rtcConfig->setWebhook($name, new Webhook($details['address'], $details['http_method']));
                }
            }

            if (isset($capabilities['vbc'])) {
                $this->getVbcConfig()->enable();
            }
        }
    }

    public function toArray(): array
    {
        // Build up capabilities that are set
        $availableCapabilities = [
            'voice' => [VoiceConfig::ANSWER, VoiceConfig::EVENT],
            'messages' => [MessagesConfig::INBOUND, MessagesConfig::STATUS],
            'rtc' => [RtcConfig::EVENT]
        ];

        $capabilities = [];

        foreach ($availableCapabilities as $type => $values) {
            $configAccessorMethod = 'get' . ucfirst($type) . 'Config';

            foreach ($values as $constant) {
                /** @var Webhook|\Vonage\Voice\Webhook $webhook */
                $webhook = $this->$configAccessorMethod()->getWebhook($constant);

                if ($webhook) {
                    if (!isset($capabilities[$type])) {
                        $capabilities[$t