8';

    protected static function explode($text)
    {
        $chars = [];

        foreach (preg_split('//u', str_replace(PHP_EOL, '', $text)) as $char) {
            if (!empty($char)) {
                $chars[] = $char;
            }
        }

        return $chars;
    }

    protected static function strlen($text)
    {
        return function_exists('mb_strlen')
            ? mb_strlen($text, static::$encoding)
            : count(static::explode($text));
    }

    protected static function validStart($word)
    {
        return !in_array($word, static::$notBeginPunct, false);
    }

    protected static function appendEnd($text)
    {
        $mbAvailable = extension_loaded('mbstring');

        // extract the last char of $text
        if ($mbAvailable) {
            // in order to support php 5.3, third param use 1 instead of null
            // https://secure.php.net/manual/en/function.mb-substr.php#refsect1-function.mb-substr-changelog
            $last = mb_substr($text, mb_strlen($text, static::$encoding) - 1, 1, static::$encoding);
        } else {
            $chars = static::utf8Encoding($text);
            $last = $chars[count($chars) - 1];
  PK     Fs[imu  u    Faker/Provider/zh_TW/Color.phpnu [        
        if (in_array($last, static::$notEndPunct, false)) {
            if ($mbAvailable) {
                $text = mb_substr($text, 0, mb_strlen($text, static::$encoding) - 1, static::$encoding);
            } else {
                array_pop($chars);
                $text = implode('', $chars);
            }
        }

        // if the last char is not a valid punctuation, append a default one.
        return in_array($last, static::$endPunct, false) ? $text : $text . '。';
    }

    /**
     * Convert original string to utf-8 encoding.
     *
     * @param string $text
     *
     * @return array
     */
    protected static function utf8Encoding($text)
    {
        $encoding = [];

        $chars = str_split($text);

        $countChars = count($chars);

        for ($i = 0; $i < $countChars; ++$i) {
            $temp = $chars[$i];

            $ord = ord($chars[$i]);

            switch (true) {
                case $ord > 251:
                    $temp .= $chars[++$i];
                    // no break
                case $ord > 247:
                    $temp .= $chars[++$i];
                    // no break
                case $ord > 239:
                    $temp .= $chars[++$i];
                    // no break
                case $ord > 223:
                    $temp .= $chars[++$i];
                    // no break
                case $ord > 191:
                    $temp .= $chars[++$i];
            }

            $encoding[] = $temp;
        }

        return $encoding;
    }
}
PK     Fs[imu  u    Faker/Provider/zh_TW/Color.phpnu [        <?php

namespace Faker\Provider\zh_TW;

class Color extends \Faker\Provider\Color
{
    /**
     * @see http://zh.wikipedia.org/zh-tw/%E9%A2%9C%E8%89%B2%E5%88%97%E8%A1%A8
     */
    protected static $safeColorNames = [
        '黑色', '粟色', '綠色', '藏青', '橄欖色',
        '紫', '鳧綠', '鮮綠色', '藍色', '銀色',
        '灰色', '黃色', '品紅', '水色', '白色',
    ];

    protected static $allColorNames = [
        '黑色', '昏灰', '灰色', '暗灰', '銀色', '亮灰色',
        '庚斯博羅灰', '白煙色', '白色', '雪色', '鐵灰色',
        '沙棕', '玫瑰褐', '亮珊瑚色', '印度紅', '褐色',
        '耐火磚紅', '栗色', '暗紅', '鮮紅', '紅色', '柿子橙',
        '霧玫瑰色', '鮭紅', '腥紅', '蕃茄紅', '暗鮭紅',
        '珊瑚紅', '橙紅', '亮鮭紅', '朱紅', '赭黃', '熱帶橙',
        '駝色', '杏黃', '椰褐', '海貝色', '鞍褐', '巧克力色',
        '燃橙', '陽橙', '粉撲桃色', '沙褐', '古銅色', '亞麻色',
        '蜜橙', '秘魯色', '烏賊墨色', '赭色', '