streetNameFormats = [
        '{{lastName}}{{streetSuffix}}',
        '{{lastName}}{{streetSuffix}}',
        '{{firstName}}{{streetSuffix}}',
        '{{firstName}}{{streetSuffix}}',
        '{{streetPrefix}}{{streetSuffix}}',
        '{{streetPrefix}}{{streetSuffix}}',
        '{{streetPrefix}}{{streetSuffix}}',
        '{{streetPrefix}}{{streetSuffix}}',
        '{{lastName}} {{streetSuffixWord}}',
    ];

    /**
     * @var array Swedish street address formats
     */
    protected static $streetAddressFormats = [
        '{{streetName}} {{buildingNumber}}',
    ];

    /**
     * @var array Swedish address formats
     */
    protected static $addressFormats = [
        "{{streetAddress}}\n{{postcode}} {{city}}",
    ];

    /**
     * Randomly return a real city name
     *
     * @return string
     */
    public static function cityName()
    {
        return static::randomElement(static::$cityNames);
    }

    public static function streetSuffixWord()
    {
        return static::randomElement(static::$streetSuffixWord);
    }

    public static function streetPrefix()
    {
        return static::randomElement(static::$streetPrefix);
    }

    /**
  PK     Fs[,:   :     Faker/Provider/zh_TW/Person.phpnu [          public static function buildingNumber()
    {
        return static::toUpper(static::bothify(static::randomElement(static::$buildingNumber)));
    }
}
PK     Fs[WH    !  Faker/Provider/zh_TW/DateTime.phpnu [        <?php

namespace Faker\Provider\zh_TW;

class DateTime extends \Faker\Provider\DateTime
{
    public static function amPm($max = 'now')
    {
        return static::dateTime($max)->format('a') === 'am' ? '上午' : '下午';
    }

    public static function dayOfWeek($max = 'now')
    {
        $map = [
            'Sunday' => '星期日',
            'Monday' => '星期一',
            'Tuesday' => '星期二',
            'Wednesday' => '星期三',
            'Thursday' => '星期四',
            'Friday' => '星期五',
            'Saturday' => '星期六',
        ];
        $week = static::dateTime($max)->format('l');

        return $map[$week] ?? $week;
    }

    public static function monthName($max = 'now')
    {
        $map = [
            'January' => '一月',
            'February' => '二月',
            'March' => '三月',
            'April' => '四月',
            'May' => '五月',
            'June' => '六月',
            'July' => '七月',
            'August' => '八月',
            'September' => '九月',
            'October' => '十月',
            'November' => '十一月',
            'December' => '十二月',
        ];
        $month = static::dateTime($max)->format('F');

        return $map[$month] ?? $month;
    }
}
PK     Fs[,:   :     Faker/Provider/zh_TW/Person.phpnu [        <?php

namespace Faker\Provider\zh_TW;

class Person extends \Faker\Provider\Person
{
    /**
     * @see https://zh.wikipedia.org/wiki/%E4%B8%AD%E8%8F%AF%E6%B0%91%E5%9C%8B%E5%9C%8B%E6%B0%91%E8%BA%AB%E5%88%86%E8%AD%89
     */
    public static $idBirthplaceCode = [
        'A' => 10,
        'B' => 11,
        'C' => 12,
        'D' => 13,
        'E' => 14,
        'F' => 15,
        'G' => 16,
        'H' => 17,
        'I' => 34,
        'J' => 18,
        'K' => 19,
        'M' => 21,
        'N' => 22,
        'O' => 35,
        'P' => 23,
        'Q' => 24,
        'T' => 27,
        'U' => 28,
        'V' => 29,
        'W' => 32,
        'X' => 30,
        'Z' => 33,
    ];

    /**
     * @see https://zh.wikipedia.org/wiki/%E4%B8%AD%E8%8F%AF%E6%B0%91%E5%9C%8B%E5%9C%8B%E6%B0%91%E8%BA%AB%E5%88%86%E8%AD%89
     */
    public static $idDigitValidator = [1, 9, 8, 7, 6, 5, 4, 3, 2, 1, 1];

    protected static $maleNameFormats = [
        '{{lastName}}{{firstNameMale}}',
    ];

    protected static $femaleNameFormats = [
        '{{lastName}}{{firstNameFemale}}',
    ];

    protected static $titleMale = ['先生', '博士', '教授'];
    protected static $titleFemale = ['小姐', '太太', '博士', '教授'];

    /**
     * @see http://zh.wikipedia.org/wiki/%E7%99%BE%E5%AE%B6%E5%A7%93
     */
    protected static $lastName = [
        '趙', '錢', '孫', '李', '周', '吳', '鄭', '王', '馮',
        '陳', '褚', '衛', '蔣', '沈', '韓', '楊', '朱', '秦',
        '尤', '許', '何', '呂', '施', '張', '孔', '曹', '嚴',
        '華', '金', '魏', '陶', '姜', '戚', '謝', '鄒', '喻',
        '柏', '水', '竇', '章', '雲', '蘇', '潘', '葛',
        '奚', '范', '彭', '郎', '魯', '韋', '昌', '馬',
        '苗', '鳳', '花', '方', '俞', '任', '袁', '柳',
        '酆', '鮑', '史', '唐', '費', '廉', '岑', '薛',
        '雷', '賀', '倪', '湯', '滕', '殷', '羅', '畢',
        '郝', '鄔', '安', '常', '樂', '于', '時', '傅',
        '皮', '卞', '齊', '康', '伍', '余', '元', '卜',
        '顧', '孟', '平', '黃', '和', '穆', '蕭', '尹',
        '姚', '邵', '湛', '汪', '祁', '毛', '禹', '狄',
        '米', '貝', '明', '臧', '計', '伏', '成', '戴',
        '談', '宋', '茅', '龐', '熊', '紀', '舒', '屈',
        '項', '祝', '董', '梁', '杜', '阮', '藍', '閔',
        '席', '季', '麻', '強', '賈', '路', '婁', '危',
        '江', '童', '顏', '郭', '梅', '盛', '林', '刁',
        '鍾', '徐', '丘', '駱', '高', '夏', '蔡', '田',
        '樊', '胡', '凌', '霍', '虞', '萬', '支', '柯',
        '昝', '管', '盧', '莫', '經', '房', '裘', '繆',
        '干', '解', '應', '宗', '丁', '宣', '賁', '鄧',
        '郁', '單', '杭', '洪', '包', '諸', '左', '石',
        '崔', '吉', '鈕', '龔', '程', '嵇', '邢', '滑',
        '裴', '陸', '榮', '翁', '荀', '羊', '於', '惠',
        '甄', '麴', '家', '封', '芮', '羿', '儲', '靳',
        '汲', '邴', '糜', '松', '井', '段', '富', '巫',
        '烏', '焦', '巴', '弓', '牧', '隗', '山', '谷',
        '車', '侯', '宓', '蓬', '全', '郗', '班', '仰',
        '秋', '仲', '伊', '宮', '甯', '仇', '欒', '暴',
        '甘', '鈄', '厲', '戎', '祖', '武', '符', '劉',
        '景', '詹', '束', '龍', '葉', '幸', '司', '韶',
        '郜', '黎', '薊', '薄', '印', '宿', '白', '懷',
        '蒲', '邰', '從', '鄂', '索', '咸', '籍', '賴',
        '卓', '藺', '屠', '蒙', '池', '喬', '陰', '鬱',
        '胥', '能', '蒼', '雙', '聞', '莘', '黨', '翟',
        '譚', '貢', '勞', '逄', '姬', '申', '扶', '堵',
        '冉', '宰', '酈', '雍', '郤', '璩', '桑', '桂',
        '濮', '牛', '壽', '通', '邊', '扈', '燕', '冀',
        '郟', '浦', '尚', '農', '溫', '別', '莊', '晏',
        '柴', '瞿', '閻', '充', '慕', '連', '茹', '習',
        '宦', '艾', '魚', '容', '向', '古', '易', '慎',
        '戈', '廖', '庾', '終', '暨', '居', '衡', '步',
        '都', '耿', '滿', '弘', '匡', '國', '文', '寇',
        '廣', '祿', '闕', '東', '歐', '殳', '沃', '利',
        '蔚', '越', '夔', '隆', '師', '鞏', '厙', '聶',
        '晁', '勾', '敖', '融', '冷', '訾', '辛', '闞',
        '那', '簡', '饒', '空', '曾', '毋', '沙', '乜',
        '養', '鞠', '須', '豐', '巢', '關', '蒯', '相',
        '查', '后', '荊', '紅', '游', '竺', '權', '逯',
        '蓋', '益', '桓', '公', '万俟', '司馬', '上官',
        '歐陽', '夏侯', '諸葛', '聞人', '東方', '赫連',
        '皇甫', '尉遲', '公羊', '澹臺', '公冶', '宗政',
        '濮陽', '淳于', '單于', '太叔', '申屠', '公孫',
        '仲孫', '軒轅', '令狐', '鍾離', '宇文', '長孫',
        '慕容', '鮮于', '閭丘', '司徒', '司空', '亓官',
        '司寇', '仉', '督', '子車', '顓孫', '端木', '巫馬',
        '公西', '漆雕', '樂正', '壤駟', '公良', '拓跋',
        '夾谷', '宰父', '穀梁', '晉', '楚', '閆', '法',
        '汝', '鄢', '涂', '欽', '段干', '百里', '東郭',
        '南門', '呼延', '歸', '海', '羊舌', '微生', '岳',
        '帥', '緱', '亢', '況', '後', '有', '琴', '