<?php

namespace Spatie\FlareClient\FlareMiddleware;

use Closure;
use Spatie\FlareClient\Report;
use Symfony\Component\Process\Process;
use Throwable;

class AddGitInformation
{
    protected ?string $baseDir = null;

    public function handle(Report $report, Closure $next)
    {
        try {
            $this->baseDir = $this->getGitBaseDirectory();

            if (! $this->baseDir) {
                return $next($report);
            }

            $report->group('git', [
                'hash' => $this->hash(),
                'message' => $this->message(),
                'tag' => $this->tag(),
                'remote' => $this->remote(),
                'isDirty' => ! $this->isClean(),
            ]);
        } catch (Throwable) {
        }

        return $next($report);
    }

    protected function hash(): ?string
    {
        return $this->command("git log --pretty=format:'%H' -n 1") ?: null;
    }

    protected function message(): ?string
    {
        return $this->command("git log --pretty=format:'%s' -n 1") ?: null;
    }

    protected function tag(): ?string
    {
        return $this->command('git describe --tags --abbrev=0') ?: null;
    }

    protected function remote(): ?string
    {
       s $fieldName) {
            if (isset($context['request_data']['body'][$fieldName])) {
                $context['request_data']['body'][$fieldName] = '<CENSORED>';
            }
        }

        $report->userProvidedContext($context);

        return $next($report);
    }
}
PK     Ps[A;  ;  %  FlareMiddleware/AddGitInformation.phpnu [        <?php

namespace Spatie\FlareClient\FlareMiddleware;

use Closure;
use Spatie\FlareClient\Report;
use Symfony\Component\Process\Process;
use Throwable;

class AddGitInformation
{
    protected ?string $baseDir = null;

    public function handle(Report $report, Closure $next)
    {
        try {
            $this->baseDir = $this->getGitBaseDirectory();

            if (! $this->baseDir) {
                return $next($report);
            }

            $report->group('git', [
                'hash' => 