    protected function tag(): ?string
    {
        return $this->command('git describe --tags --abbrev=0') ?: null;
    }

    protected function remote(): ?string
    {
        return $this->command('git config --get remote.origin.url') ?: null;
    }

    protected function isClean(): bool
    {
        return empty($this->command('git status -s'));
    }

    protected function getGitBaseDirectory(): ?string
    {
        /** @var Process $process */
        $process = Process::fromShellCommandline("echo $(git rev-parse --show-toplevel)")->setTimeout(1);

        $process->run();

        if (! $process->isSuccessful()) {
            return null;
        }

        $directory = trim($process->getOutput());

        if (! file_exists($directory)) {
            return null;
        }

        return $directory;
 