h.s[<b,(	  (	  #  Formatter/BitcoinMoneyFormatter.phpnu [        <?php

declare(strict_types=1);

namespace Money\Formatter;

use Money\Currencies;
use Money\Currencies\BitcoinCurrencies;
use Money\Exception\FormatterException;
use Money\Money;
use Money\MoneyFormatter;
use Money\Number;

use function str_pad;
use function strlen;
use function strpoPK     h.s[	@    #  Formatter/DecimalMoneyFormatter.phpnu [        BitcoinMoneyFormatter implements MoneyFormatter
{
    private int $fractionDigits;

    private Currencies $currencies;

    public function __construct(int $fractionDigits, Currencies $currencies)
    {
        $this->fractionDigits = $fractionDigits;
        $this->currencies     = $currencies;
    }

    public function format(Money $money): string
    {
        if ($money->getCurrency()->getCode() !== BitcoinCurrencies::CODE) {
            throw new FormatterException('Bitcoin Formatter can only format Bitcoin currency');
        }

        $valueBase = $money->getAmount();
        $negative  = false;

        if ($valueBase[0] === '-') {
            $negative  = true;
            $valueBase = substr($valueBase, 1);
   PK     h.s[    %  Formatter/AggregateMo