 PK     bYx[+@  @    Promise/HttpRejectedPromise.phpnu [        PK     bYx[y)       Promise/HttpFulfilledPromise.phpnu [        PK     bYx[Mҗ      Exception/RequestAwareTrait.phpnu [        PK     bYx[lF  F    Exception/HttpException.phpnu [        PK     bYx[      Exception/NetworkException.phpnu [        PK     bYx[skYI      HttpAsyncClient.phpnu [        PK     bYx[FsD      HttpClient.phpnu [        PK     |x[qN      Autoloader.phpnu [        <?php
declare(strict_types=1);
/**
 * Vonage Nexmo Bridge
 *
 * @copyright Copyright (c) 2020 Vonage, Inc. (http://vonage.com)
 * @license   https://github.com/nexmo/vonage-php-nexmo-bridge/blob/master/LICENSE MIT License
 */

namespace Vonage\NexmoBridge;

use \ArrayObject;
use Closure;
use Composer\Autoload\ClassLoader;
use \RuntimeException;

/**
 * Alias legacy Nexmo classes/interfaces/traits to Vonage equivalents.
 */
class Autoloader
{
    /**
     * Attach autoloaders for managing legacy Nexmo artifacts.
     *
     * We attach two autoloaders:
     *
     * - The first is _prepended_ to handle new classes and add aliases for
     *   legacy classes. PHP expects any interfaces implemented, classes
     *   extended, or traits used when declaring class_alias() to exist and/or
     *   be autoloadable already at the time of declaration. If not, it will
     *   raise a fatal error. This autoloader helps mitigate errors in such
     *   situations.
     *
     * - The second is _appended_ in order to create aliases for legacy
     *   classes.
     */

     /**
      * @var array<string, string>
      */
    protected static $namespaces = ['Nexmo\\' => 'Vonage\\'];

    /**
     * @var array<string, string>
     */
    protected static $namespacesReversed = ['Vonage\\' => 'Nexmo\\'];

    public static function load() : void
    {
        $loaded = new ArrayObject([]);

        spl_autoload_register(self::createPrependAutoloader(
            static::$namespacesReversed,
            self::getClassLoader(),
            $loaded
        ), true, true);

        spl_autoload_register(self::createAppendAutoloader(
            static::$namespaces,
            $loaded
        ));
    }

    /**
     * @throws RuntimeException
     */
    private static function getClassLoader() : ClassLoader
    {
        if (getenv('COMPOSER_VENDOR_DIR') !== false && file_exists(getenv('COMPOSER_VENDOR_DIR') . '/autoload.php')) {
            return include getenv('COMPOSER_VENDOR_DIR') . '/autoload.php';
        }

        if (file_exists(__DIR__ . '/../../../autoload.php')) {
            return include __DIR__ . '/../../../autoload.php';
        }

        if (file_exists(__DIR__ . '/../vendor/autoload.php')) {
            return include __DIR__ . '/../vendor/autoload.php';
        }

        throw new RuntimeException('Cannot detect composer autoload. Please run composer install');
    }

    /**
     * @param array<string, string> $namespaces Namespaces to flip between
     * @return Closure(string): void
     */
    private static function createPrependAutoloader(
        array $namespaces,
        ClassLoader $classLoader,
        ArrayObject $loaded
    ) : Closure {
        /**
         * @param  string $class Class name to autoload
         * @return void
         */
        return static function (string $class) use ($namespaces, $classLoader, $loaded) : void {
            if (isset($loaded[$class])) {
                return;
            }

            $segments = explode('\\', $class);

            $i = 0;
            $check = '';

            while (isset($segments[$i + 1], $namespaces[$check . $segments[$i] . '\\'])) {
                $check .= $segments[$i] . '\\';
                ++$i;
            }

            if ($check === '') {
                return;
            }

            if ($classLoader->loadClass($class)) {
                $legacy = $namespaces[$check]
                    . strtr(substr($class, strlen($check)), [
                        'Vonage' => 'Nexmo',
                    ]);
                class_alias($class, $legacy);
            }
        };
    }

    /**
     * @param array<string, string> $namespaces Namespaces to flip between
     * @return Closure(string): void
     */
    private static function createAppendAutoloader(array $namespaces, ArrayObject $loaded) : Closure
    {
        /**
         * @param  string $class Class name to autoload
         * @return void
         */
        return static function (string $class) use ($namespaces, $loaded) : void {
            $segments = explode('\\', $class);

            $i = 0;
            $check = '';

            // We are checking segments of the namespace to match quicker
            while (isset($segments[$i + 1], $namespaces[$check . $segments[$i] . '\\'])) {
                $check .= $segments[$i] . '\\';
                ++$i;
            }

            if ($check === '') {
                return;
            }

            $alias = $namespaces[$check]
                . strtr(substr($class, strlen($check)), [
                    'Nexmo' => 'Vonage',
                ]);

            $loaded[$alias] = true;
            if (class_exists($alias) || interface_exists($alias) || trait_exists($alias)) {
                class_alias($alias, $class);
            }
        };
    }
}
PK       un[C	  C	                  Invoice.phpnu [        PK       un[ !
    	            ~	  Order.phpnu [        PK       un[Vd$                
  Stakeholder.phpnu [        PK       un[X!                    Iin.phpnu [        PK       un[ 
U  U              [  Plan.phpnu [        PK       un[s                  Transfer.phpnu [        PK       un[,)
  
                Utility.phpnu [        PK       un[YJ    
            $  Refund.phpnu [        PK       un[]毖                '  Card.phpnu [        PK       un[G?    
            k)  Entity.phpnu [        PK       un[eW                1@  Customer.phpnu [        PK       un[XR                >C  Resource.phpnu [        PK       un[j0	  	               H  Collection.phpnu [        PK       un[--ݝ                YQ  Subscription.phpnu [        PK       un[    
            _Z  QrCode.phpnu [        PK       un[+.)j9  9              v`  Request.phpnu [        PK       un[hKD                o  Item.phpnu [        PK       un[JY;F  F              r  PaymentPage.phpnu [        PK       un[]VѼ                5u  Account.phpnu [        PK       un[NJ                ,z  Webhook.phpnu [        PK       un[=;
  
              `  FundAccount.phpnu [        PK       un[S  S                VirtualAccount.phpnu [        PK       un[{O                  >  ArrayableInterface.phpnu [        PK       un[멁                5  Payment.phpnu [        PK       un[?(G,  ,  	            R  Addon.phpnu [        PK       un[NE                  Errors/Error.phpnu [        PK       un[rm   m   %              Errors/SignatureVerificationError.phpnu [        PK       un[qޜ                M  Errors/ErrorCode.phpnu [        PK       un[2QJ   J                 Errors/ServerError.phpnu [        PK       un[Y/q  q                Errors/BadRequestError.phpnu [        PK       un[1K   K               d  Errors/GatewayError.phpnu [        PK       un[ǡ                  Product.phpnu [        PK       un[!/qF  F                Api.phpnu [        PK       un[!"                =  PaymentLink.phpnu [        PK       un[k    	            s  Token.phpnu [        PK       un[cNS                  Settlement.phpnu [        PK       7vn[m4t:j  j                Validator/GenericValidator.phpnu [        PK       7vn[C                 s  Validator/ValidatorInterface.phpnu [        PK       7vn[L                  Codec/OrderedTimeCodec.phpnu [        PK       7vn[o	c
  c
                Codec/StringCodec.phpnu [        PK       7vn[8Gb=N  N               3  Codec/TimestampLastCombCodec.phpnu [        PK       7vn[                  Codec/GuidStringCodec.phpnu [        PK       8vn[h                  Codec/CodecInterface.phpnu [        PK       8vn[{N
  N
  !             Codec/TimestampFirstCombCodec.phpnu [        PK       8vn[ve  e               Uuid.phpnu [        PK       8vn[<f=  =              x UuidFactory.phpnu [        PK       8vn[|l7?5  5               DeprecatedUuidMethodsTrait.phpnu [        PK       9vn[                 Rfc4122/UuidV4.phpnu [        PK       9vn[cM?  ?              ~ Rfc4122/NilUuid.phpnu [        PK       9vn[.%	  %	                Rfc4122/UuidV8.phpnu [        PK       9vn[}u                g  Rfc4122/UuidV3.phpnu [        PK       9vn[/                } Rfc4122/TimeTrait.phpnu [        PK       9vn[_~v                O Rfc4122/UuidV2.phpnu [        PK       :vn[f[                Y Rfc4122/UuidV1.phpnu [        PK       :vn[J  J              o' Rfc4122/Fields.phpnu [        PK       :vn[>x
  x
              > Rfc4122/VariantTrait.phpnu [        PK       :vn[z                I Rfc4122/UuidV5.phpnu [        PK       :vn['                Q Rfc4122/NilTrait.phpnu [        PK       :vn[*                U Rfc4122/Validator.phpnu [        PK       :vn[	                [ Rfc4122/VersionTrait.phpnu [        PK       :vn[f>                a Rfc4122/UuidBuilder.phpnu [        PK       :vn[Z#  #              t Rfc4122/FieldsInterface.phpnu [        PK       ;vn[w=                 Rfc4122/UuidInterface.phpnu [        PK       ;vn[>  >              x Rfc4122/MaxUuid.phpnu [        PK       ;vn[
  
               Rfc4122/UuidV6.phpnu [        PK       ;vn[bn                H Rfc4122/MaxTrait.phpnu [        PK       ;vn[;  ;               Rfc4122/UuidV7.phpnu [        PK       ;vn[1}l                 Math/BrickMathCalculator.phpnu [        PK       ;vn[Zj                M Math/RoundingMode.phpnu [        PK       ;vn[GU~  ~              1 Math/CalculatorInterface.phpnu [        PK       ;vn[`    "             Provider/NodeProviderInterface.phpnu [        PK       <vn[Xw  w  #             Provider/Time/FixedTimeProvider.phpnu [        PK       <vn[v    $             Provider/Time/SystemTimeProvider.phpnu [        PK       <vn[*    *             Provider/Dce/SystemDceSecurityProvider.phpnu [        PK       <vn[d    )             Provider/DceSecurityProviderInterface.phpnu [        PK       <vn[    $            W Provider/Node/RandomNodeProvider.phpnu [        PK       <vn[Co%X  X  $             Provider/Node/StaticNodeProvider.phpnu [        PK       <vn[Ma  a  &            n Provider/Node/FallbackNodeProvider.phpnu [        PK       =vn[wk6Z  Z  (            %
 Provider/Node/NodeProviderCollection.phpnu [        PK       =vn[}1T    $             Provider/Node/SystemNodeProvider.phpnu [        PK       =vn[fT6  6  "            ) Provider/TimeProviderInterface.phpnu [        PK       =vn[=D  D  !            C, Exception/TimeSourceException.phpnu [        PK       =vn[N    (            . Exception/InvalidUuidStringException.phpnu [        PK       =vn[Y  Y              1 Exception/NameException.phpnu [        PK       =vn[ouR  R  #            4 Exception/InvalidBytesException.phpnu [        PK       =vn[M?  ?  +            07 Exception/UnsupportedOperationException.phpnu [        PK       =vn[oc  c  "            9 Exception/DceSecurityException.phpnu [        PK       @vn[3tN    #            < Exception/RandomSourceException.phpnu [        PK       @vn[T  T              ? Exception/DateTimeException.phpnu [        PK       @vn[veD  D  &            gB Exception/BuilderNotFoundException.phpnu [        PK       @vn[H%_B  B  (            E Exception/UnableToBuildUuidException.phpnu [        PK       @vn[. S  S              G Exception/NodeException.phpnu [        PK       @vn[TE9    &            9J Exception/InvalidArgumentException.phpnu [        PK       @vn[R    $            )L Exception/UuidExceptionInterface.phpnu [        PK       @vn[0  0              3N FeatureSet.phpnu [        PK       @vn[yy    "            4 Fields/SerializableFieldsTrait.phpnu [        PK       Avn[t4                U Fields/FieldsInterface.phpnu [        PK       Avn[j                 Guid/GuidBuilder.phpnu [        PK       Avn[·o[  [              Y Guid/Fields.phpnu [        PK       Avn[o    
             Guid/Guid.phpnu [        PK       Avn[fE  E              / Lazy/LazyUuidFromString.phpnu [        PK       Avn[#<                & UuidFactoryInterface.phpnu [        PK       Bvn[96  6              T DegradedUuid.phpnu [        PK       Bvn[_~P#  #               Type/Integer.phpnu [        PK       Bvn[{  {              -! Type/NumberInterface.phpnu [        PK       Bvn[{ޕ                # Type/TypeInterface.phpn