st|\GuzzleHttp\Promise\Promise
     */
    public function __call($method, $parameters)
    {
        return $this->pool[] = $this->asyncRequest()->$method(...$parameters);
    }
}
PK     Hs[L    +  Illuminate/Http/Client/RequestException.phpnu [        <?php

namespace Illuminate\Http\Client;

use GuzzleHttp\Psr7\Message;

class RequestException extends HttpClientException
{
    /**
     * The response instance.
     *
     * @var \Illuminate\Http\Client\Response
     */
    public $response;

    /**
     * Create a new exception instance.
     *
     * @param  \Illuminate\Http\Client\Response  $response
     * @return void
     */
    public function __construct(Response $response)
    {
        parent::__construct($this->prepareMessage($response), $response->status());

        $this->response = $response;
    }

    /**
     * Prepare the exception message.
     *
     * @param  \Illuminate\Http\Client\Response  $response
     * @return string
     */
    protected function prepareMessage(Response $response)
    {
        $message = "HTTP request returned status code {$response->status()}";

        $summary = Message::bodySummary($response->toPsrResponse());

        return is_null($summary) ? $message : $message .= ":\n{$summary}\n";
    }
}
PK     Hs[v,q   q   .  Illuminate/Http/Client/HttpClientException.phpnu [        <?php

namespace Illuminate\Http\Client;

use Exception;

class HttpClientException extends Exception
{
    //
}
PK     Hs[

  

  8  Illuminate/Http/Client/Concerns/DeterminesStatusCode.phpnu [        <?php

namespace Illuminate\Http\Client\Concerns;

trait DeterminesStatusCode
{
    /**
     * Determine if the response code was 200 "OK" response.
     *
     * @return bool
     */
    public function ok()
    {
        return $this->status() === 200;
    }

    /**
     * Determine if the response code was 201 "Created" response.
     *
     * @return bool
     */
    public function created()
    {
        return $this->status() === 201;
    }

    /**
     * Determine if the response code was 202 "Accepted" response.
     *
     * @return bool
     */
    public function accepted()
    {
        return $this->status() === 202;
    }

    /**
     * Determine if the response code was the given status code and the body has no content.
     *
     * @param  int  $status
     * @return bool
     */
    public function noContent($status = 204)
    {
        return $this->status() === $status && $this->body() === '';
    }

    /**
     * Determine if the response code was a 301 "Moved Permanently".
     *
     * @return bool
     */
    public function movedPermanently()
    {
        return $this->status() === 301;
    }

    /**
     * Determine if the response code was a 302 "Found" response.
     *
     * @return bool
     */
    public function found()
    {
        return $this->status() === 302;
    }

    /**
     * Determine if the response code was a 304 "Not Modified" response.
     *
     * @return bool
     */
    public function notModified()
    {
        return $this->status() === 304;
    }

    /**
     * Determine if the response was a 400 "Bad Request" response.
     *
     * @return bool
     */
    public function badRequest()
    {
        return $this->status() === 400;
    }

    /**
 