Pagination/composer.jsonnu [        PK       Hs[q'    3            }h Illuminate/Pagination/PaginationServiceProvider.phpnu [        PK       Hs[α3  3               k Illuminate/Pagination/LICENSE.mdnu [        PK       Hs[@'  '  .            Gp Illuminate/Pagination/LengthAwarePaginator.phpnu [        PK       Hs[O5    )            ̈ Illuminate/Pagination/CursorPaginator.phpnu [        PK       Hs[`    #             Illuminate/Pagination/Paginator.phpnu [        PK       Hs[	_;  ;  1            T Illuminate/Pagination/AbstractCursorPaginator.phpnu [        PK       Hs[z                 @ Illuminate/Pagination/Cursor.phpnu [        PK       Hs[y
    0            . Illuminate/Notifications/RoutesNotifications.phpnu [        PK       Hs[2CU      )             Illuminate/Notifications/Notification.phpnu [        PK       Hs[oh  h  8             Illuminate/Notifications/NotificationServiceProvider.phpnu [        PK       Hs["    =             Illuminate/Notifications/Console/NotificationTableCommand.phpnu [        PK       Hs[G	    9             Illuminate/Notifications/Console/stubs/notifications.stubnu [        PK       Hs[<b]  ]  4            

 Illuminate/Notifications/SendQueuedNotifications.phpnu [        PK       Hs[L@    5             Illuminate/Notifications/HasDatabaseNotifications.phpnu [        PK       Hs[r      1            <! Illuminate/Notifications/DatabaseNotification.phpnu [        PK       Hs[`|Fz  z  ;            , Illuminate/Notifications/DatabaseNotificationCollection.phpnu [        PK       Hs[%3    6            / Illuminate/Notifications/Channels/BroadcastChannel.phpnu [        PK       Hs[tn$  n$  1            7 Illuminate/Notifications/Channels/MailChannel.phpnu [        PK       Hs[_    5            \ Illuminate/Notifications/Channels/DatabaseChannel.phpnu [        PK       Hs[v9  9  8            d Illuminate/Notifications/resources/views/email.blade.phpnu [        PK       Hs[	{    /            wi Illuminate/Notifications/NotificationSender.phpnu [        PK       Hs[z=    &             Illuminate/Notifications/composer.jsonnu [        PK       Hs[<q  q  6             Illuminate/Notifications/Events/NotificationFailed.phpnu [        PK       Hs[C:Ao  o  4             Illuminate/Notifications/Events/NotificationSent.phpnu [        PK       Hs[gֱ
  
  @            h Illuminate/Notifications/Events/BroadcastNotificationCreated.phpnu [        PK       Hs[<    7            v Illuminate/Notifications/Events/NotificationSending.phpnu [        PK       Hs[α3  3  #             Illuminate/Notifications/LICENSE.mdnu [        PK       Hs[jx    #             Illuminate/Notifications/Action.phpnu [        PK       Hs[KYk  k  0      API
     *
     *
     * @phpstan-param string|array<int|string>    $users
     * @phpstan-param value-of<Level::VALUES>|value-of<Level::NAMES>|Level|LogLevel::* $highPriorityLevel
     * @phpstan-param value-of<Level::VALUES>|value-of<Level::NAMES>|Level|LogLevel::* $emergencyLevel
     */
    public function __construct(
        string $token,
        $users,
        ?string $title = null,
        int|string|Level $level = Level::Critical,
        bool $bubble = true,
        bool $useSSL = true,
        int|string|Level $highPriorityLevel = Level::Critical,
        int|string|Level $emergencyLevel = Level::Emergency,
        int $retry = 30,
        int $expire = 25200,
        bool $persistent = false,
        float $timeout = 0.0,
        float $writingTimeout = 10.0,
        ?float $connectionTimeout = null,
        ?int $chunkSize = null
    ) {
        $connectionString = $useSSL ? 'ssl://api.pushover.net:443' : 'api.pushover.net:80';
        parent::__construct(
            $connectionString,
            $level,
            $bubble,
            $persistent,
            $timeout,
            $writingTimeout,
            $connectionTimeout,
            $chunkSize
        );

        $this->token = $token;
        $this->users = (array) $users;
        $this->title = $title ?? (string) gethostname();
        $this->highPriorityLevel = Logger::toMonologLevel($highPriorityLevel);
        $this->emergencyLevel = Logger::toMonologLevel($emergencyLevel);
        $this->retry = $retry;
        $this->expire = $expire;
    }

    protected function generateDataStream(LogRecord $record): string
    {
        $content = $this->buildContent($record);

        return $this->buildHeader($content) . $content;
    }

    private function buildContent(LogRecord $record): string
    {
        // Pushover has a limit of 512 characters on title and message combined.
        $maxMessageLength = 512 - strlen($this->title);

        $message = ($this->useFormattedMessage) ? $record->formatted : $record->message;
        $message = Utils::substr($message, 0, $maxMessageLength);

        $timestamp = $record->datetime->getTimestamp();

        $dataArray = [
            'token' => $this->token,
            'user' => $this->user,
            'message' => $message,
            'title' => $this->title,
            'timestamp' => $timestamp,
        ];

        if ($record->level->value >= $this->emergencyLevel->value) {
            $dataArray['priority'] = 2;
            $dataArray['retry'] = $this->retry;
            $dataArray['expire'] = $this->expire;
        } elseif ($record->level->value >= $this->highPriorityLevel->value) {
            $dataArray['priority'] = 1;
        }

        // First determine the available parameters
        $context = array_intersect_key($record->context, $this->parameterNames);
        $extra = array_intersect_key($record->extra, $this->parameterNames);

        // Least important info should be merged with subsequent info
        $dataArray = array_merge($extra, $context, $dataArray);

        // Only pass sounds that are supported by the API
        if (isset($dataArray['sound']) && !in_array($dataArray['sound'], $this->sounds, true)) {
            unset($dataArray['sound']);
        }

        return http_build_query($dataArray);
    }

    private function buildHeader(string $content): string
    {
        $header = "POST /1/messages.json HTTP/1.1\r\n";
        $header .= "Host: api.pushover.net\r\n";
        $header .= "Content-Type: application/x-www-form-urlencoded\r\n";
        $header .= "Content-Length: " . strlen($content) . "\r\n";
        $header .= "\r\n";

        return $header;
    }

    protected function write(LogRecord $record): void
    {
        foreach ($this->users as $user) {
            $this->user = $user;

            parent::write($record);
            $this->closeSocket();
        }

        $this->user = null;
    }

    /**
     * @param int|string|Level|LogLevel::* $level
     * @return $this
     *
     * @phpstan-param value-of<Level::VALUES>|value-of<Level::NAMES>|Level|LogLevel::* $level
     */
    public function setHighPriorityLevel(int|string|Level $level): self
    {
        $this->highPriorityLevel = Logger::toMonologLevel($level);

        return $this;
    }

    /**
     * @param int|string|Level|LogLevel::* $level
     * @return $this
     *
     * @phpstan-param value-of<Level::VALUES>|value-of<Level::NAMES>|Level|LogLevel::* $level
     */
    public function setEmergencyLevel(int|string|Level $level): self
    {
        $this->emergencyLevel = Logger::toMonologLevel($level);

        return $this;
    }

    /**
     * Use the formatted message?
     *
     * @return $this
     */
    public function useFormattedMessage(bool $useFormattedMessage): self
    {
        $this->useFormattedMessage = $useFormattedMessage;

        return $this;
    }
}
