<?php declare(strict_types=1);

/*
 * This file is part of the Monolog package.
 *
 * (c) Jordi Boggiano <j.boggiano@seld.be>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Monolog\Handler;

use Monolog\Formatter\LineFormatter;
use Monolog\Formatter\FormatterInterface;
use Monolog\Level;
use Monolog\LogRecord;
use Predis\Client as Predis;
use Redis;

/**
 * Logs to a Redis key using rpush
 *
 * usage example:
 *
 *   $log = new Logger('application');
 *   $redis = new RedisHandler(new Predis\Client("tcp://localhost:6379"), "logs", "prod");
 *   $log->pushHandler($redis);
 *
 * @author Thomas Tourlourat <thomas@tourlourat.com>
 */
class RedisHandler extends AbstractProcessingHandler
{
    /** @var Predis<Predis>|Redis */
    private Predis|Redis $redisClient;
    private string $redisKey;
    protected int $capSize;

    /**
hpnu [        PK       Hs[j$"  "  $            	Illuminate/Validation/Rules/File.phpnu [        PK       Hs[b\#U  U  &            	Illuminate/Validation/Rules/Unique.phpnu [        PK       Hs[Lu
  
  $            P	Illuminate/Validation/Rules/Enum.phpnu [        PK       Hs[v3&  3&  (            	Illuminate/Validation/Rules/Password.phpnu [        PK       Hs[K    )            9	Illuminate/Validation/Rules/ExcludeIf.phpnu [        PK       Hs[
>    %            	Illuminate/Validation/Rules/NotIn.phpnu [        PK       Hs[z'^#  #  ,            	Illuminate/Validation/Rules/ProhibitedIf.phpnu [        PK       Hs[α3  3               	Illuminate/Validation/LICENSE.mdnu [        PK       Hs[w5k    #            	Illuminate/Validation/Validator.phpnu [        PK       Hs[#DS      /            u
Illuminate/Validation/UnauthorizedException.phpnu [        PK       Hs[C~-<    ;            T
Illuminate/Validation/DatabasePresenceVerifierInterface.phpnu [        PK       Hs[S]    3            ޜ
Illuminate/Validation/ValidationServiceProvider.phpnu [        PK       Hs[쎦    /            Υ
Illuminate/Validation/ClosureValidationRule.phpnu [        PK       Hs[/:k                ӭ
Illuminate/Cookie/CookieJar.phpnu [        PK       Hs[pd  d  '            
Illuminate/Cookie/CookieValuePrefix.phpnu [        PK       Hs["#                
Illuminate/Cookie/composer.jsonnu [        PK       Hs[]5  5  +            	
Illuminate/Cookie/CookieServiceProvider.phpnu [        PK       