<?php declare(strict_types=1);

/*
 * This file is part of the Monolog package.
 *
 * (c) Jordi Boggiano <j.boggiano@seld.be>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Monolog\Handler;

use Monolog\Level;
use Monolog\Utils;
use Monolog\LogRecord;

/**
 * Logs to syslog service.
 *
 * usage example:
 *
 *   $log = new Logger('application');
 *   $syslog = new SyslogHandler('myfacility', 'local6');
 *   $formatter = new LineFormatter("%channel%.%level_name%: %message% %extra%");
 *   $syslog->setFormatter($formatter);
 *   $log->pushHandler($syslog);
 *
 * @author Sven Paulus <sven@karlsruhe.org>
 */
class SyslogHandler extends AbstractSyslogHandler
{
    protected string $ident;
    protected int $logopts;

    /**
     * @param string|int $facility Either one of the names of the keys in $this->facilities, or a LOG_* facility constant
     * @param int     ds[p>  >  $            !!Exceptions/TokenExpiredException.phpnu [        PK       ds[g	S(  S(  %            "!Providers/AbstractServiceProvider.phpnu [        PK       es[@`    "            IK!Providers/LumenServiceProvider.phpnu [        PK       es[;                N!Providers/JWT/Provider.phpnu [        PK       es[.)q  q              i]!Providers/JWT/Lcobucci.phpnu [        PK       es[ +  +              $}!Providers/Auth/Illuminate.phpnu [        PK       es[K2                 !Providers/Storage/Illuminate.phpnu [        PK       es[3    $            !Providers/LaravelServiceProvider.