<?php declare(strict_types=1);

/*
 * This file is part of the Monolog package.
 *
 * (c) Jordi Boggiano <j.boggiano@seld.be>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Monolog\Handler\SyslogUdp;

use Monolog\Utils;
use Socket;

class UdpSocket
{
    protected const DATAGRAM_MAX_LENGTH = 65023;

    protected string $ip;
    protected int $port;
    protected ?Socket $socket = null;

    public function __construct(string $ip, int $port = 514)
    {
        $this->ip = $ip;
        $this->port = $port;
    }

    public function write(string $line, string $header = ""): void
    {
        $this->send($this->assembleMessage($line, $header));
    }

    public function close(): void
    {
        if ($this->socket instanceof Socket) {
            socket_close($this->socket);
            $this->socket = null;
        }
    }

    protected function getSocket(): Socket
    {
        if (null !== $this->socket) {
            return $this->socket;
        }

        $domain = AF_INET;
        $protocol = SOL_UDP;
        // Check if we are usingluminate/Database/Schema/PostgresSchemaState.phpnu [        PK       \Hs[
1  1  /             Illuminate/Database/Schema/MySqlSchemaState.phpnu [        PK       \Hs[6R#g	  g	  /            N Illuminate/Database/Schema/ColumnDefinition.phpnu [        PK       \Hs[q#:  :  .            % Illuminate/Database/Schema/IndexDefinition.phpnu [        PK       \Hs[0c
  
  0            ' Illuminate/Database/Schema/SqliteSchemaState.phpnu [        PK       \Hs[4    +            2 Illuminate/Database/Schema/MySqlBuilder.phpnu [        PK       \Hs[0    .            J? Illuminate/Database/Schema/PostgresBuilder.phpnu [        PK       \Hs[nѻ:2  :2  &            uX Illuminate/Database/Schema/Builde