<?php declare(strict_types=1);

/*
 * This file is part of the Monolog package.
 *
 * (c) Jordi Boggiano <j.boggiano@seld.be>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Monolog;

use Closure;
use DateTimeZone;
use Fiber;
use Monolog\Handler\HandlerInterface;
use Monolog\Processor\ProcessorInterface;
use Psr\Log\LoggerInterf[        PK       mn[5^  ^  5            F
 Extension/CommonMark/Parser/Inline/BacktickParser.phpnu [        PK       mn[Ɗ>d  d  1            	
 Extension/CommonMark/Parser/Inline/BangParser.phpnu [        PK       mn[9E    3            
 Extension/CommonMark/Parser/Inline/EntityParser.phpnu [        PK       mn[W    >            B
 Extension/CommonMark/Parser/Block/ThematicBreakStartParser.phpnu [        PK       mn[Ce    =             Extension/CommonMark/Parser/Block/IndentedCodeStartParser.phpnu [        PK       mn[ᄖ    9             Extension/CommonMark/Parser/Block/ThematicBreakParser.phpnu [        PK       mn[Y  Y  ;             Extension/CommonMark/Parser/Block/BlockQuoteStartParser.phpnu [        PK       mn[nL    3             Extension/CommonMark/Parser/Block/HeadingParser.phpnu [        PK       mn[ϲdD	  D	  5             Extension/CommonMark/Parser/Block/ListBlockParser.phpnu [        PK       mn[Xѷ    ;              Extension/CommonMark/Parser/Block/FencedCodeStartParser.phpnu [        PK       mn[}V  V  :            % Extension/CommonMark/Parser/Block/HtmlBlockStartParser.phpnu [        PK       mn[}v##{  {  4            . Extension/CommonMark/Parser/Block/ListItemParser.phpnu [        PK       mn[7Bq
  
  6            n: Extension/CommonMark/Parser/Block/FencedCodeParser.phpnu [        PK       mn[F4$k  k  :            E Extension/CommonMark/Parser/Block/ListBlockStartParser.phpnu [        PK       mn[{j    5            [ Extension/CommonMark/Parser/Block/HtmlBlockParser.phpnu [        PK       mn[*P	  	  8            d Extension/CommonMark/Parser/Block/HeadingStartParser.phpnu [        PK       mn[Kz*  *  6            -o Extension/CommonMark/Parser/Block/BlockQuoteParser.phpnu [        PK       mn[:A    8            u Extension/CommonMark/Parser/Block/IndentedCodeParser.phpnu [        PK       mn[(    5            ~ Extension/CommonMark/Renderer/Inline/CodeRenderer.phpnu [        PK       mn[S>qL9
  9
  5             Extension/CommonMark/Renderer/Inline/LinkRenderer.phpnu [        PK       mn[?    9             Extension/CommonMark/Renderer/Inline/EmphasisRenderer.phpnu [        PK       mn[]    6             Extension/CommonMark/Renderer/Inline/ImageRenderer.phpnu [        PK       mn[ 2  2  ;            < Extension/CommonMark/Renderer/Inline/HtmlInlineRenderer.phpnu [        PK       mn[yZ'    7            ٩ Extension/CommonMark/Renderer/Inline/StrongRenderer.phpnu [        PK       mn[    =             Extension/CommonMark/Renderer/Block/ThematicBreakRenderer.phpnu [        PK       mn[>9@	  	  9            c Extension/CommonMark/Renderer/Block/ListBlockRenderer.phpnu [        PK       mn[@4)  )  :            j Extension/CommonMark/Renderer/Block/FencedCodeRenderer.phpnu [        PK       mn[n3`c  c  <             Extension/CommonMark/Renderer/Block/IndentedCodeRenderer.phpnu [        PK       mn[&t+  +  9             Extension/CommonMark/Renderer/Block/HtmlBlockRenderer.phpnu [        PK       mn[@	%    :            ` Extension/CommonMark/Renderer/Block/BlockQuoteRenderer.phpnu [        PK       mn[    7            _ Extension/CommonMark/Renderer/Block/HeadingRenderer.phpnu [        PK       mn[#t2  2  8             Extension/CommonMark/Renderer/Block/ListItemRenderer.phpnu [        PK       mn[hN    G              Extension/CommonMark/Delimiter/Processor/EmphasisDelimiterProcessor.phpnu [        PK       mn[x    /            , Extension/CommonMark/Node/Inline/HtmlInline.phpnu [        PK       mn[    +            , Extension/CommonMark/Node/Inline/Strong.phpnu [        PK       mn[	<̋    -            t Extension/CommonMark/Node/Inline/Emphasis.phpnu [        PK       mn[놘o  o  8             Extension/CommonMark/Node/Inline/AbstractWebResource.phpnu [        PK       mn[P2U  U  *             Extension/CommonMark/Node/Inline/Image.phpnu [        PK       mn[h6  6  )            E Extension/CommonMark/Node/Inline/Code.phpnu [        PK       mn[0֝T  T  )             Extension/CommonMark/Node/Inline/Link.phpnu [        PK       mn[>l>    .             Extension/CommonMark/Node/Block/FencedCode.phpnu [        PK       mn[>    1             Extension/CommonMark/Node/Block/ThematicBreak.phpnu [        PK       mn[`I    .            ! Extension/CommonMark/Node/Block/BlockQuote.phpnu [        PK       mn[щ8    -            # Extension/CommonMark/Node/Block/ListBlock.phpnu [        PK       mn[_8  8  ,            X) Extension/CommonMark/Node/Block/ListData.phpnu [        PK       mn[[    0            - Extension/CommonMark/Node/Block/IndentedCode.phpnu [        PK       mn[0'  '  -            41 Extension/CommonMark/Node/Block/HtmlBlock.phpnu [        PK       mn[5i@  @  ,            8 Extension/CommonMark/Node/Block/ListItem.phpnu [        PK       mn[t>Pb  b  +            T< Extension/CommonMark/Node/Block/Heading.phpnu [        PK       mn[;    (            @ Extension/Autolink/AutolinkExtension.phpnu [        PK       mn[_    *            9C Extension/Autolink/EmailAutolinkParser.phpnu [        PK       mn[    (            <I Extension/Autolink/UrlAutolinkParser.phpnu [        PK       mn[C@    7            ~e Extension/HeadingPermalink/HeadingPermalinkRenderer.phpnu [        PK       mn[rE{    /            q Extension/HeadingPermalink/HeadingPermalink.phpnu [        PK       mn[    8            u Extension/HeadingPermalink/HeadingPermalinkProcessor.phpnu [        PK       mn[COS  S  8            ^ Extension/HeadingPermalink/HeadingPermalinkExtension.phpnu [        PK       mn[2"?
  
  ,             Extension/SmartPunct/SmartPunctExtension.phpnu [        PK       mn[Тr  r  #             Extension/SmartPunct/DashParser.phpnu [        PK       mn[
4$O  O  '             Extension/SmartPunct/EllipsesParser.phpnu [        PK       mn[K{A  A              ` Extension/SmartPunct/Quote.phpnu [        PK       mn[mk2  2  6             Extension/SmartPunct/ReplaceUnpairedQuotesListener.phpnu [        PK       mn[%d;	  ;	  '             Extension/SmartPunct/QuoteProcessor.phpnu [        PK       mn[,K
  
  $             Extension/SmartPunct/QuoteParser.phpnu [        PK       mn[v                / Exception/LogicException.phpnu [        PK       mn[&D    !             Exception/CommonMarkException.phpnu [        PK       mn[ V                 Exception/IOException.phpnu [        PK       mn[
    )             Exception/AlreadyInitializedException.phpnu [        PK       mn[    (             Exception/MissingDependencyException.phpnu [        PK       mn[]w    )             Exception/UnexpectedEncodingException.phpnu [        PK       mn[5OV5  5               Renderer/HtmlRenderer.phpnu [        PK       mn[쓲                ' Renderer/HtmlDecorator.phpnu [        PK       mn[:Qd    &            ` Renderer/DocumentRendererInterface.phpnu [        PK       mn[=;  ;               e Renderer/Inline/TextRenderer.phpnu [        PK       mn[w    #             Renderer/Inline/NewlineRenderer.phpnu [        PK       mn[{5    "             Renderer/NodeRendererInterface.phpnu [        PK       mn[    $             Renderer/Block/ParagraphRenderer.phpnu [        PK       mn[v|    #             Renderer/Block/DocumentRenderer.phpnu [        PK       mn[f*    '            # Renderer/ChildNodeRendererInterface.phpnu [        PK       mn[@ɥ    (            7 Renderer/NoMatchingRendererException.phpnu [        PK       mn[    &            4 Renderer/MarkdownRendererInterface.phpnu [        PK       mn[i >                b Xml/FallbackNodeXmlRenderer.phpnu [        PK       mn[a*D  D              _ Xml/MarkdownToXmlConverter.phpnu [        PK       mn[}"F  F               Xml/XmlRenderer.phpnu [        PK       mn[	&*b  b               z+ Xml/XmlNodeRendererInterface.phpnu [        PK       mn[                ,. Delimiter/DelimiterStack.phpnu [        PK       mn[!x,                 qL Delimiter/DelimiterInterface.phpnu [        PK       mn[                Q Delimiter/Delimiter.phpnu [        PK       mn[&1F7i  i  4            ] Delimiter/Processor/DelimiterProcessorCollection.phpnu [        PK       mn[sm    =            xi Delimiter/Processor/DelimiterProcessorCollectionInterface.phpnu [        PK       mn[pjʥ    3            o Delimiter/Processor/DelimiterProcessorInterface.phpnu [        PK       mn[a    3            { Delimiter/Processor/StaggeredDelimiterProcessor.phpnu [        PK       mn[d(p  p              w Delimiter/DelimiterParser.phpnu [        PK       mn[i                4 ConverterInterface.phpnu [        PK       mn[A2hێ                  Event/DocumentPreRenderEvent.phpnu [        PK       mn[
V2                k Event/DocumentParsedEvent.phpnu [        PK       mn[t  t                Event/DocumentPreParsedEvent.phpnu [        PK       mn[oF/                T Event/DocumentRenderedEvent.phpnu [        PK       mn[/E                ' Event/ListenerData.phpnu [        PK       mn[0!                 Event/AbstractEvent.phpnu [        PK       mn[
                # CommonMarkConverter.phpnu [        PK       mn[
    #             GithubFlavoredMarkdownConverter.phpnu [        PK       mn[
2ސ    $             Node/RawMarkupContainerInterface.phpnu [        PK       mn[j4L  L              - Node/StringContainerHelper.phpnu [        PK       mn[c  c  
             Node/Node.phpnu [        PK       mn[ 0b  b              g Node/NodeIterator.phpnu [        PK       mn[5                 Node/Query.phpnu [        PK       mn[     !            < Node/StringContainerInterface.phpnu [        PK       mn[jW  W  '            
 Node/Inline/AbstractStringContainer.phpnu [        PK       mn[i    "             Node/Inline/DelimitedInterface.phpnu [        PK       mn[P30                 Node/Inline/AbstractInline.phpnu [        PK       mn[CN                $ Node/Inline/Newline.phpnu [        PK       mn[j}RM  M               Node/Inline/Text.phpnu [        PK       mn[~    "             Node/Inline/AdjacentTextMerger.phpnu [        PK       mn[,                s Node/NodeWalker.phpnu [        PK       mn[hWn  n              O Node/Query/AndExpr.phpnu [        PK       mn[w
]    "             Node/Query/ExpressionInterface.phpnu [        PK       mn[sWk  k              
 Node/Query/OrExpr.phpnu [        PK       mn[v
                 Node/Block/Paragraph.phpnu [        PK       mn[t                 Node/Block/AbstractBlock.phpnu [        PK       mn[wQ    "             Node/Block/TightBlockInterface.phpnu [        PK       mn[Ҽƨ                 Node/Block/Document.phpnu [        PK       mn[Ks}  }              # Node/NodeWalkerEvent.phpnu [        PK       S(s[maW                  ! ClockInterface.phpnu [        PK       S(s[    	            " error_lognu [        PK       L)s[;)	S                B helpers.phpnu [        PK       L)s[wL  L  	            E Table.phpnu [        PK       L)s[COx5      0            K Exceptions/NonInteractiveValidationException.phpnu [        PK       L)s[n֮                }L PasswordPrompt.phpnu [        PK       L)s[y^                P SearchPrompt.phpnu [        PK       L)s[N                ` Note.phpnu [        PK       L)s[                c SelectPrompt.phpnu [        PK       L)s[                p Spinner.phpnu [        PK       L)s[B\                ~ MultiSearchPrompt.phpnu [        PK       L)s[i+ᩭ                 p Output/BufferedConsoleOutput.phpnu [        PK       L)s[G                m Output/ConsoleOutput.phpnu [        PK       M)s[ڞ
  
              V Concerns/Themes.phpnu [        PK       M)s["ΉBf
  f
               Concerns/FakesInputOutput.phpnu [        PK       M)s[Q_                3 Concerns/Events.phpnu [        PK       M)s[                g Concerns/Interactivity.phpnu [        PK       M)s[CM                 Concerns/Fallback.phpnu [        PK       M)s[|^9  9               Concerns/TypedValue.phpnu [        PK       M)s[K                 Concerns/Scrolling.phpnu [        PK       M)s[L                 Concerns/Colors.phpnu [        PK       M)s[]                : Concerns/Cursor.phpnu [        PK       M)s[Y*-                5 Concerns/Termwind.phpnu [        PK       M)s[3>                 Concerns/Truncation.phpnu [        PK       M)s[eMc  c               Concerns/Erase.phpnu [        PK       M)s[ilI  I              k ConfirmPrompt.phpnu [        PK       N)s[ L  L               TextPrompt.phpnu [        PK       N)s[葻o/  /                SuggestPrompt.phpnu [        PK       N)s[I                 Progress.phpnu [        PK       N)s[Ct                ! Terminal.phpnu [        PK       N)s[%z                * MultiSelectPrompt.phpnu [        PK       N)s[*l1C  C              9 Key.phpnu [        PK       N)s[                  H? Themes/Contracts/Scrolling.phpnu [        PK       N)s[^@    )            b@ Themes/Default/PasswordPromptRenderer.phpnu [        PK       N)s[	|4A    ,            xG Themes/Default/MultiSearchPromptRenderer.phpnu [        PK       N)s[qꮕ    '            _ Themes/Default/SearchPromptRenderer.phpnu [        PK       O)s[n    "            q Themes/Default/SpinnerRenderer.phpnu [        PK       O)s[.a                }u Themes/Default/NoteRenderer.phpnu [        PK       O)s[X'
  
  &            { Themes/Default/Concerns/DrawsBoxes.phpnu [        PK       O)s[<'    +             Themes/Default/Concerns/DrawsScrollbars.phpnu [        PK       O)s[uԘ6  6               X Themes/Default/TableRenderer.andler;
    }

    /**
     * Adds a log record at an arbitrary level.
     *
     * This method allows for compatibility with common interfaces.
     *
     * @param mixed             $level   The log level (a Monolog, PSR-3 or RFC 5424 level)
     * @param string|Stringable $message The log message
     * @param mixed[]           $context The log context
     *
     * @phpstan-param Level|LogLevel::* $level
     */
    public function log($level, string|\Stringable $message, array $context = []): void
    {
        if (!$level instanceof Level) {
            if (!is_string($level) && !is_int($level)) {
                throw new \InvalidArgumentException('$level is expected to be a string, int or '.Level::class.' instance');
            }

            if (isset(self::RFC_5424_LEVELS[$level])) {
                $level = self::RFC_5424_LEVELS[$level];
            }

            $level = static::toMonologLevel($level);
        }

        $this->addRecord($level, (string) $message, $context);
    }

    /**
     * Adds a log record at the DEBUG level.
     *
     * This method allows for compatibility with common interfaces.
     *
     * @param string|Stringable $message The log message
     * @param mixed[]           $context The log context
     */
    public function debug(string|\Stringable $message, array $context = []): void
    {
        $this->addRecord(Level::Debug, (string) $message, $context);
    }

    /**
     * Adds a log record at the INFO level.
     *
     * This method allows for compatibility with common interfaces.
     *
     * @param string|Stringable $message The log message
     * @param mixed[]           $context The log context
     */
    public function info(string|\Stringable $message, array $context = []): void
    {
        $this->addRecord(Level::Info, (string) $message, $context);
    }

    /**
     * Adds a log record at the NOTICE level.
     *
     * This method allows for compatibility with common interfaces.
     *
     * @param string|Stringable $message The log message
     * @param mixed[]           $context The log context
     */
    public function notice(string|\Stringable $message, array $context = []): void
    {
        $this->addRecord(Level::Notice, (string) $message, $context);
    }

    /**
     * Adds a log record at the WARNING level.
     *
     * This method allows for compatibility with common interfaces.
     *
     * @param string|Stringable $message The log message
     * @param mixed[]           $context The log context
     */
    public function warning(string|\Stringable $message, array $context = []): void
    {
        $this->addRecord(Level::Warning, (string) $message, $context);
    }

    /**
     * Adds a log record at the ERROR level.
     *
     * This method allows for compatibility with common interfaces.
     *
     * @param string|Stringable $message The log message
     * @param mixed[]           $context The log context
     */
    public function error(string|\Stringable $message, array $context = []): void
    {
        $this->addRecord(Level::Error, (string) $message, $context);
    }

    /**
     * Adds a log record at the CRITICAL level.
     *
     * This method allows for compatibility with common interfaces.
     *
     * @param string|Stringable $message The log message
     * @param mixed[]           $context The log context
     */
    public function critical(string|\Stringable $message, array $context = []): void
    {
        $this->addRecord(Level::Critical, (string) $message, $context);
    }

    /**
     * Adds a log record at the ALERT level.
     *
     * This method allows for compatibility with common interfaces.
     *
     * @param string|Stringable $message The log message
     * @param mixed[]           $context The log context
     */
    public function alert(string|\Stringable $message, array $context = []): void
    {
        $this->addRecord(Level::Alert, (string) $message, $context);
    }

    /**
     * Adds a log record at the EMERGENCY level.
     *
     * This method allows for compatibility with common interfaces.
     *
     * @param string|Stringable $message The log message
     * @param mixed[]           $context The log context
     */
    public function emergency(string|\Stringable $message, array $context = []): void
    {
        $this->addRecord(Level::Emergency, (string) $message, $context);
    }

    /**
     * Sets the timezone to be used for the timestamp of log records.
     *
     * @return $this
     */
    public function setTimezone(DateTimeZone $tz): self
    {
        $this->timezone = $tz;

        return $this;
    }

    /**
     * Returns the timezone to be used for the timestamp of log records.
     */
    public function getTimezone(): DateTimeZone
    {
        return $this->timezone;
    }

    /**
     * Delegates exception management to the custom exception handler,
     * or throws the exception if no custom handler is set.
     */
    protected function handleException(Throwable $e, LogRecord $record): void
    {
        if (null === $this->exceptionHandler) {
            throw $e;
        }

        ($this->exceptionHandler)($e, $record);
    }

    /**
     * @return array<string, mixed>
     */
    public function __serialize(): array
    {
        return [
            'name' => $this->name,
            'handlers' => $this->handlers,
            'processors' => $this->processors,
            'microsecondTimestamps' => $this->microsecondTimestamps,
            'timezone' => $this->timezone,
            'exceptionHandler' => $this->exceptionHandler,
            'logDepth' => $this->logDepth,
            'detectCycles' => $this->detectCycles,
        ];
    }

    /**
     * @param array<string, mixed> $data
     */
    public function __unserialize(array $data): void
    {
        foreach (['name', 'handlers', 'processors', 'microsecondTimestamps', 'timezone', 'exceptionHandler', 'logDepth', 'detectCycles'] as $property) {
            if (isset($data[$property])) {
                $this->$property = $data[$property];
            }
        }

        $this->fiberLogDepth = new \WeakMap();
    }
}
