 null)
    {
        $this->setNode($node ?: $this->nodeInstanceByValue());
    }

    public function setNode(NodeInterface $node)
    {
        $this
            ->emptyStack()
            ->pushNode($node);

        return $this;
    }

    public function getNode()
    {
        return $this->nodeStack[\count($this->nodeStack) - 1];
    }

    public function leaf($value = null)
    {
        $this->getNode()->addChild(
            $this->nodeInstanceByValue($value)
        );

        return $this;
    }

    public function leafs($value1 /*,  $value2, ... */)
    {
        foreach (\func_get_args() as $value) {
            $this->leaf($value);
        }

        return $this;
    }

    public function tree($value = null)
    {
        $node = $this->nodeInstanceByValue($value);
        $this->getNode()->addChild($node);
        $this->pushNode($node);

        return $this;
    }

    public function end()
    {
        $this->popNode();

        return $this;
    }

    public function nodeInstanceByValue($value = null)
    {
        return new Node($value);
    }

    public function value($value)
    {
        $this->getNode()->setValue($value);

        return $this;
    }

    private function emptyStack()
    {
        $this->nodeStack = [];

        return $this;
    }

    private function pushNode(NodeInterface $node)
    {
        \array_push($this->nodeStack, $node);

        return $this;
    }

    private function popNode()
    {
        return \array_pop($this->nodeStack);
    }
}
PK     Qs[{i      Node/NodeInterface.phpnu [        <?php

/**
 * Copyright (c) 2013-2020 Nicolò Martini
 *
 * For the full copyright and license information, please view
 * the LICENSE.md file that was distributed with this source code.
 *
 * @see https://github.com/nicmart/Tree
 */

namespace Tr *
     * @return array
     */
    public function getAncestors();

    /**
     * Retrieves all ancestors of node as well as the node itself.
     *
     * @return Node[]
     */
    public function getAncestorsAndSelf();

    /**
     * Retrieves all neighboring nodes, excluding the current node.
     *
     * @return array
     */
    public function getNeighbors();

    /**
     * Returns all neighboring nodes, including the current node.
     *
     * @return Node[]
     */
    public function getNeighborsAndSelf();

    /**
     * Return true if the node is the root, false otherwise.
     *
     * @return bool
     */
    public function isRoot();

    /**
     * Return true if the node is a child, false otherwise.
     *
     * @return bool
     */
    public function isChild();

    /**
     * Return true if the node has no children, false otherwise.
     *
     * @return bool
     */
    public function isLeaf();

    /**
     * Return the distance from the current node to the root.
     *
     * @return int
     */
    public function getDepth();

    /**
     * Return the height of the tree whose root is this node.
     *
     * @return int
     */
    public function getHeight();

    /**
     * Accept method for the visitor pattern (see http://en.wikipedia.org/wiki/Visitor_pattern).
     *
     * @param Visitor $visitor
     */
    public function accept(Visitor $visitor);
}
