    /  Exception/UnresolvableCurrencyPairException.phpnu [         }

    public function parse(string $money, Currency|null $fallbackCurrency = null): Money
    {
        if (strpos($money, BitcoinCurrencies::SYMBOL) === false) {
PK     g.s[s$      Exception/ParserException.phpnu [        <?php declare(strict_types=1);
/*
 * This file is part of phpunit/php-code-coverage.
 *
 * (c) Sebastian Bergmann <sebastian@phpunit.de>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace SebastianBergmann\CodeCoverage;

use RuntimeException;

final class ParserException extends RuntimeException implements Exception
{
}
PK     g.s[R	    /  Exception/UnresolvableCurrencyPairException.phpnu [        imal = strlen($decimal);
         PK     g.s[n       Exception/FormatterException.phpnu [         str_pad('', ($lengthDecimal - $decimalSeparator - $this->fractionDigits - 1) *PK     g.s[aҺ>  >    Exchange.phpnu [        '', $this->fractionDigits, '0');
        }

        if (substr($decimal, 0, 1) === '-') {
            $decimal = '-' . lPK     g.s[ŜV$  V$  
  Number.phpnu [           $decimal = ltrim($decimal, '0');
        }

        if ($decimal === '') {
            $decimal = '0';
        }

        /** @psalm-var numeric-string $decimal */
        return new Money($decimal, $currency);
    }
}
PK     g.s[aҺ>  >    Exchange.phpnu [        <?php

declare(strict_types=1);

namespace Money;

use Money\Exception\UnPK     g.s[n       Exception/FormatterException.phpnu [        /UnknownCurrencyException.phpnu [        ir.
 */
interface Exchange
{
    /**
     * Returns a currency pair for the passed currencies with the rate coming from a third-party source.
     *
     * @throws UnresolvableCurrencyPairException When there is PK     g.s[ŜV$  V$  
  Number.phpnu [          g.s[&        Exception/ParserException.phpnu [        $counterCurrency): CurrencyPair;
}
PK     g.s[ѳ    &  Exception/UnknownCurrencyException.phpnu [        <?php

declare(strict_types=1);

namespace Money\Exception;

use DomainException;
use Money\Exception;

/**
 * Thrown when trying PK     g.s[R	    /  Exception/UnresolvableCurrencyPairException.phpnu [        inException implements Exception
{
}
PK     g.s[&        Exception/ParserException.phpnu [        <?php

declare(strict_types=1);

namespace Money\Exception;

use Money\Exception;
use RuntimeException;

/**
 * Thrown when a string cannot be parsed to a Money object.
 */
final class ParserException extends RuntimeException implements Exception
{
}
PK     g.s[R	    /  Exception/UnresolvableCurrencyPairException.phpnu [        <?php

declare(strict_types=1);

namespace Money\Exception;

use InvalidArgumentException;
use Money\Currency;
use Money\Exception;

use function sprintf;

/**
 * Thrown when there is no currency pair (rate) available for the given currencies.
 */
final class UnresolvableCurrencyPairException extends InvalidArgumentExceptionPK     g.s[n       Exception/FormatterException.phpnu [        s.
     */
    public static function createFromCurrencies(Currency $baseCurrency, Currency $counterCurrency): UnresolvableCurrencyPairException
    {
        $message = sprintf(
            'Cannot resolve a currency pair for currencies: %s/%s',
            PK     g.s[ŜV$  V$  
  Number.phpnu [        tCode()
        );

        return new self($message);
    }
}
PK     g.s[n       Exception/FormatterException.phpnu [        <?php

declare(strict_types=1);

namespace Money\Exception;

use Money\Exception;
use RuntimeException;

/**
 * Thrown when a Money object cannot be formatted into a string.
 */
final class FormatterException extends RuntimeException implements Exception
{
}
PK     g.s[ŜV$  V$  
  Number.phpnu [        <?php

declare(strict_types=1);

namespace Money;

use InvalidArgumentException;

use function abs;
use function explode;
use function is_int;
use function ltrim;
use function min;
use function rtrim;
use function sprintf;
use function str_pad;
use function strlen;
use function substr;

/**
 * Represents a numeric value.
 *
 * @internal this is an internal utility of the library, and may vary at any time. It is mostly used to internally validate
 *           that a number is represented at digits, but by improving type system integration, we may be able to completely
 *           get rid of it.
 *
 * @psalm-immutable
 */
final class Number
{
    /** @psalm-var numeric-string */
    private string $integerPart;

    /** @psalm-var numeric-string|'' */
    private string $fractionalPart;
    private const NUMBERS = [0 => 1, 1 => 1, 2 => 1, 3 => 1, 4 => 1, 5 => 1, 6 => 1, 7 => 1, 8 => 1, 9 => 1];

    public function __construct(string $integerPart, string $fractionalPart = '')
    {
        if ($integerPart === '' && $fractionalPart === '') {
            throw new InvalidArgumentException('Empty number is invalid');
        }

        $this->integerPart    = self::parseIntegerPart($integerPart);
        $this->fractionalPart = self::parseFractionalPart($fractionalPart);
    }

    /** @psalm-pure */
    public static function fromString(string $number): self
    {
        $portions = explode('.', $number, 2);

        return new self(
            $portions[0],
            rtrim($portions[1] ?? '', '0')
        );
    }

    /** @psalm-pure */
    public static function fromFloat(float $number): self
    {
        return self::fromString(sprintf('%.14F', $number));
    }

    /** @psalm-pure */
    public static function fromNumber(int|string $number): self
    {
        if (is_int($number)) {
            return new self((string) $number);
        }

        return self::fromString($number);
    }

    public function isDecimal(): bool
    {
        return $this->fractionalPart !== '';
    }

    public function isInteger(): bool
    {
        return $this->fractionalPart === '';
    }

    public function isHalf(): bool
    {
        return $this->fractionalPart === '5';
    }

    public function isCurrentEven(): bool
    {
        $lastIntegerPartNumber = (int) $this->integerPart[strlen($this->integerPart) - 1];

        return $lastIntegerPartNumber % 2 === 0;
    }

    public function isCloserToNext(): bool
    {
        if ($this->fractionalPart === '') {
            return false;
        }

        return $this->fractionalPart[0] >= 5;
    }

    /** @psalm-return numeric-string */
    public function __toString(): string
    {
        if ($this->fractionalPart === '') {
            return $this->integerPart;
        }

        /** @psalm-suppress LessSpecificReturnStatement this operation is guaranteed to pruduce a numeric-string, but inference can't understand it */
        return $this->integerPart . '.' . $this->fractionalPart;
    }

    public function isNegative(): bool
    {
        return $this->integerPart[0] === '-';
    }

    /** @psalm-return numeric-string */
    public function getIntegerPart(): string
    {
        return $this->integerPart;
    }

    /** @psalm-return numeric-string|'' */
    public function getFractionalPart(): string
    {
        return $this->fractionalPart;
    }

    /** @psalm-return numeric-string */
    public function getIntegerRoundingMultiplier(): string
    {
        if ($this->integerPart[0] === '-') {
            return '-1';
        }

        return '1';
    }

    public function base10(int $number): self
    {
        if ($this->integerPart === '0' && ! $this->fractionalPart) {
            return $this;
        }

        $sign        = '';
        $integerPart = $this->integerPart;

        if ($integerPart[0] === '-') {
            $sign        = '-';
            $integerPart = substr($integerPart, 1);
        }

        if ($number >= 0) {
            $integerPart       = ltrim($integerPart, '0');
            $lengthIntegerPart = strlen($integerPart);
            $integers          = $lengthIntegerPart - min($number, $lengthIntegerPart);
            $zeroPad           = $number - min($number, $lengthIntegerPart);

            return new self(
                $sign . substr($integerPart, 0, $integers),
                rtrim(str_pad('', $zeroPad, '0') . substr($integerPart, $integers) . $this->fractionalPart, '0')
            );
        }

        $number               = abs($number);
        $lengthFractionalPart = strlen($this->fractionalPart);
        $fractions            = $lengthFractionalPart - min($number, $lengthFractionalPart);
        $zeroPad              = $number - min($number, $lengthFractionalPart);

        return new self(
            $sign . ltrim($integerPart . substr($this->fractionalPart, 0, $lengthFractionalPart - $fractions) . str_pad('', $zeroPad, '0'), '0'),
            substr($this->fractionalPart, $lengthFractionalPart - $fractions)
        );
    }

    /**
     * @psalm-return numeric-string
     *
     * @psalm-pure
     *
     * @psalm-suppress MoreSpecificReturnType      this operation is guaranteed to pruduce a numeric-string, but inference 