])) {
            return $this->formatters['*']->format($money);
        }

        throw new FormatterException('No formatter found for currency ' . $currencyCode);
    }
}
PK     h.s[q  q  +  Formatter/IntlLocalizedDecimalFormatter.phpnu [        <?php

declare(strict_types=1);

namespace Money\Formatter;

use Money\Currencies;
use Money\Money;
use Money\MoneyFormatter;
use NumberFormatter;

use function assert;
use function is_string;
use function str_pad;
use function strlen;
use function substr;

/**
 * Formats a Money object using intl extension.
 */
final class IntlLocalizedDecimalFormatter implements MoneyFormatter
{
    private NumberFormatter $formatter;

    private Currencies $currencies;

    public function __construct(NumberFormatter $formatter, Currencies $currencies)
    PK     h.s[5  5    MoneyFormatter.phpnu [        s = $currencies;
    }

    public function format(Money $money): string
    {
        $valueBase = $money->getAmount();
        $negative  = $valueBase[0] === '-';

        if ($negative) {
            $valueBase = substr($valueBase, 1);
        }

        $subunit     = $this->currencies->subunitFor($moneyPK     h.s[:|ǻ      PHPUnit/Comparator.phpnu [        if ($valueLength > $subunit) {
            $formatted     = substr($valueBase, 0, $valueLength - $subunit);
            $decimalDigits = substr($valueBase, $valueLength - $subunit);

           PK     h.s[
_  _     Formatter/IntlMoneyFormatter.phpnu [        igits;
            }
        } elPK     h.s[5  5    MoneyFormatter.phpnu [        Length, '0') . $valueBase;
        }

        if ($negative) {
            $formatted = '-' . $formatted;
        }

        $formatted = $this->formatter->format((float) $formatted);

        assert(is_string($formatted) && $formatted !== '');

        return $formatted;
    }
}
PK     h.s[
_  _    PK     h.s[:|ǻ      PHPUnit