   *
     * @return void
     */
    public function setUrl($mUrl)
    {
        $this->mUrl = $mUrl;
    }

    /**
     * @param string $sPrefix
     *
     * @return void
     */
    public function setPrefix($sPrefix)
    {
        $this->sPrefix = $sPrefix;
    }

    /**
     * @return string
     */
    public function atRuleName()
    {
        return 'namespace';
    }

    /**
     * @return array<int, string>
     */
    public function atRuleArgs()
    {
        $aResult = [$this->mUrl];
        if ($this->sPrefix) {
            array_unshift($aResult, $this->sPrefix);
        }
        return $aResult;
    }

    /**
     * @param array<array-key, Comment> $aComments
     *
     * @return void
     */
    public function addComments(array $aComments)
    {
        $this->aComments = array_merge($this->aComments, $aComments);
    }

    /**
     * @return array<array-key, Comment>
     */
    public function getComments()
    {
        return $this->aComments;
    }

    /**
     * @param array<array-key, Comment> $aComments
     *
     * @return void
     */
    public function setComments(array $aComments)
    {
        $this->aComments = $aComments;
    }
}
PK     EAs[\k
  k
    Property/Selector.phpnu [        <?php

namespace Sabberworm\CSS\Property;

/**
 * Class representing a single CSS selector. Selectors have to be split by the comma prior to being passed into this
 * class.
 */
class Selector
{
    /**
     * regexp for specificity calculations
     *
     * @var string
     */
    const NON_ID_ATTRIBUTES_AND_PSEUDO_CLASSES_RX = '/
        (\.[\w]+)                   # classes
        |
        \[(\w+)                     # attributes
        |
        (\:(                        # pseudo classes
            link|visited|active
            |hover|focus
            |lang
            |target
            |enabled|disabled|checked|indeterminate
            |root
            |nth-child|nth-last-child|nth-of-type|nth-last-of-type
            |first-child|last-child|first-of-type|last-of-type
            |only-child|only-of-type
            |empty|contains
        ))
        /ix';

    /**
     * regexp for specificity calculations
     *
     * @var string
     */
    const ELEMENTS_AND_PSEUDO_ELEMENTS_RX = '/
        ((^|[\s\+\>\~]+)[\w]+   # elements
        |
        \:{1,2}(                # pseudo-elements
            after|before|first-letter|first-line|selection
        ))
        /ix';

    /**
     * regexp for specificity calculations
     *
     * @var string
     */
    const SELECTOR_VALIDATION_RX = '/
        ^(
            (?:
                [a-zA-Z0-9\x{00A0}-\x{FFFF}_^$|*="\'~\[\]()\-\s\.:#+>]* # any sequence of valid unescaped characters
                (?:\\\\.)?                                              # a single escaped character
                (?:([\'"]).*?(?<!\\\\)\2)?                              # a quoted text like [id="example"]
            )*
        )$
        /ux';

    /**
     * @var string
     */
    private $sSelector;

    /**
     * @var int|null
     */
    private $iSpecificity;

    /**
     * @param string $sSelector
     *
     * @return bool
     */
    public static function isValid($sSelector)
    {
        return preg_match(static::SELECTOR_VALIDATION_RX, $sSelector);
    }

    /**
     * @param string $sSelector
     * @param bool $bCalculateSpecificity
     */
    public function __constr