l|int $port The port to use with the new instance; a null valPK     0s[iP:^:(  :(    ServerRequestInterface.phpnu [        PK     0s[жJ      StreamInterface.phpnu [        PK     0s[_87  7    RequestInterface.phpnu [        PK     5s[Hf      Console/PublishCommand.phpnu [        PK     5s[8\$  $  7  Console/Concerns/InteractsWithDockerComposeServices.phpnu [        PK     5s[p]      Console/InstallCommand.phpnu [        PK     5s[PQ      Console/AddCommand.phpnu [        PK     5s[Fߠ5      SailServiceProvider.phpnu [        PK     :s[;ɽ,    2  Visitor/CyclomaticComplexityCalculatingVisitor.phpnu [        PK     :s[%#2
  
  (  Visitor/ComplexityCalculatingVisitor.phpnu [        PK     :s[h    +  Complexity/ComplexityCollectionIterator.phpnu [        PK     :s[ ;  ;    Complexity/Complexity.phpnu [        PK     :s[Z	  	  #  Complexity/ComplexityCollection.phpnu [        PK     :s[vt  t    Exception/Exception.phpnu [        PK     :s[ PK     0s[iP:^:(  :(    ServerRequestInterface.phpnu [        "    !  ConfigurationBuilderInterface.phpnu [        PK     :s[A[eo2  2  !  MutableConfigurationInterface.phpnu [        PK     :s[_W      ConfigurationInterface.phpnu [        PK     :s[v/^  ^  !  Exception/ValidationException.phpnu [        PK     :s[    +  Exception/InvalidConfigurationException.phpnu [        PK     :s[߈C    $  Exception/UnknownOptionException.phpnu [        PK     :s[Ė    -  Exception/ConfigurationExceptionInterface.phpnu [        PK     :s[F      Configuration.phpnu [        PK     :s[
J  J    SchemaBuilderInterface.phpnu [        PK     :s[7      ConfigurationAwareInterface.phpnu [        PK     :s[1A7    "  ConfigurationProviderInterface.phpnu [        PK     :s[N"  "    ReadOnlyConfiguration.phpnu [        PK     @s[l"  "    HandlerStack.phpnu [        PK     @s[DS       RedirectMiddleware.phpnu [        PK     @s[      RetryMiddleware.phpnu [        PK     @s[GLs  s    MessageFormatter.phpnu [        PK     @s[L+l  l    Pool.phpnu [        PK     @s[[$O  $O  
  Client.phpnu [        <?php

/**
 * Vonage Client Library for PHP
 *
 * @copyright Copyright (c) 2016-2022 Vonage, Inc. (http://vonage.com)
 * @license https://github.com/Vonage/vonage-php-sdk-core/blob/master/LICENSE.txt Apache License 2.0
 */

declare(strict_types=1);

namespace Vonage;

use Composer\InstalledVersions;
use Http\Client\HttpClient;
use InvalidArgumentException;
use Laminas\Diactoros\Request;
use Laminas\Diactoros\Uri;
use Lcobucci\JWT\Token;
use Psr\Container\ContainerInterface;
use Psr\Http\Client\ClientExceptionInterface;
use Psr\Http\Client\ClientInterface;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Psr\Log\LoggerInterface;
use Psr\Log\LogLevel;
use RuntimeException;
use Vonage\Account\ClientFactory;
use Vonage\Application\ClientFactory as ApplicationClientFactory;
use Vonage\Client\APIResource;
use Vonage\Client\Credentials\Basic;
use Vonage\Client\Credentials\Container;
use Vonage\Client\Credentials\CredentialsInterface;
use Vonage\Client\Credentials\Handler\BasicHandler;
use Vonage\Client\Credentials\Handler\SignatureBodyFormHandler;
use Vonage\Client\Credentials\Handler\SignatureBodyHandler;
use Vonage\Client\Credentials\Handler\SignatureQueryHandler;
use Vonage\Client\Credentials\Handler\TokenBodyFormHandler;
use Vonage\Client\Credentials\Handler\TokenBodyHandler;
use Vonage\Client\Credentials\Handler\TokenQueryHandler;
use Vonage\Client\Credentials\Keypair;
use Vonage\Client\Credentials\SignatureSecret;
use Vonage\Client\Exception\Exception as ClientException;
use Vonage\Client\Factory\FactoryInterface;
use Vonage\Client\Factory\MapFactory;
use Vonage\Conversion\ClientFactory as ConversionClientFactory;
use Vonage\Entity\EntityInterface;
use Vonage\Insights\ClientFactory as InsightsClientFactory;
use Vonage\Meetings\ClientFactory as MeetingsClientFactory;
use Vonage\Numbers\ClientFactory as NumbersClientFactory;
use Vonage\Redact\ClientFactory as RedactClientFactory;
use Vonage\Secrets\ClientFactory as SecretsClientFactory;
use Vonage\SMS\ClientFactory as SMSClientFactory;
use Vonage\Subaccount\ClientFactory as SubaccountClientFactory;
use Vonage\Messages\ClientFactory as MessagesClientFactory;
use Vonage\Users\ClientFactory as UsersClientFactory;
use Vonage\Verify\ClientFactory as VerifyClientFactory;
use Vonage\Verify2\ClientFactory as Verify2ClientFactory;
use Vonage\Verify\Verification;
use Vonage\Voice\ClientFactory as VoiceClientFactory;
use Vonage\Logger\{LoggerAwareInterface, LoggerTrait};

use function array_key_exists;
use function array_merge;
use function call_user_func_array;
use function http_build_query;
use function implode;
use function is_null;
use function json_encode;
use function method_exists;
use function set_error_handler;
use function str_replace;
use function strpos;

/**
 * Vonage API Client, allows access to the API from PHP.
 *
 * @method Account\Client account()
 * @method Meetings\Client meetings()
 * @method Messages\Client messages()
 * @method Application\Client applications()
 * @method Conversion\Client conversion()
 * @method Insights\Client insights()
 * @method Numbers\Client numbers()
 * @method Redact\Client redact()
 * @method Secrets\Client secrets()
 * @method SMS\Client sms()
 * @method Subaccount\Client subaccount()
 * @method Users\Client users()
 * @method Verify\Client  verify()
 * @method Verify2\Client  verify2()
 * @method Voice\Client voice()
 *
 * @property string restUrl
 * @property string apiUrl
 */
class Client implements LoggerAwareInterface
{
    use LoggerTrait;

    public const BASE_API = 'https://api.nexmo.com';
    public const BASE_REST = 'https://rest.nexmo.com';

    /**
     * API Credentials
     *
     * @var CredentialsInterface
     */
    protected $credentials;

    /**
     * Http Client
     *
     * @var HttpClient
     */
    protected $client;

    /**
     * @var bool
     */
    protected $debug = false;

    /**
     * @var ContainerInterface
     */
    protected $factory;

    /**
     * @var LoggerInterface
     */
    protected $logger;

    /**
     * @var array
     */
    protected $options = ['show_deprecations' => false, 'debug' => false];

    /**
     * @string
     */
    public $apiUrl;

    /**
     * @string
     */
    public $restUrl;

    /**
     * Create a new API client using the provided credentials.
     */
    public function __construct(
        CredentialsInterface $credentials,
        $options = [],
        ?ClientInterface $client = null
    ) {
        if (is_null($client)) {
            // Since the user did not pass a client, try and make a client
            // using the Guzzle 6 adapter or Guzzle 7 (depending on availability)
            list($guzzleVersion) = explode('@', InstalledVersions::getVersion('guzzlehttp/guzzle'), 1);
            $guzzleVersion = (float) $guzzleVersion;

            if ($guzzleVersion >= 6.0 && $guzzleVersion < 7) {
                /** @noinspection CallableParameterUseCaseInTypeContextInspection */
                /** @noinspection PhpUndefinedNamespaceInspection */
                /** @noinspection PhpUndefinedClassInspection */
                $client = new \Http\Adapter\Guzzle6\Client();
            }

            if ($guzzleVersion >= 7.0 && $guzzleVersion < 8.0) {
                $client = new \GuzzleHttp\Client();
            }
        }

        $this->setHttpClient($client);

        // Make sure we know how to use the credentials
        if (
            !($credentials instanceof Container) &&
            !($credentials instanceof Basic) &&
            !($credentials instanceof SignatureSecret) &&
            !($credentials instanceof Keypair)
        ) {
            throw new RuntimeException('unknown credentials type: ' . $credentials::class);
        }

        $this->credentials = $credentials;

        $this->options = array_merge($this->options, $options);

        // If they've provided an app name, validate it
        if (isset($options['app'])) {
            $this->validateAppOptions($options['app']);
        }

        // Set the default URLs. Keep the constants for
        // backwards compatibility
        $this->apiUrl = static::BASE_API;
        $this->restUrl = static::BASE_REST;

        // If they've provided alternative URLs, use that instead
        // of the defaults
        if (isset($options['base_rest_url'])) {
            $this->restUrl = $options['base_rest_url'];
        }

        if (isset($options['base_api_url'])) {
            $this->apiUrl = $options['base_api_url'];
        }

        if (isset($options['debug'])) {
            $this->debug = $options['debug'];
        }

        $this->setFactory(
            new MapFactory(
                [
                    // Registered Services by name
                    'account' => ClientFactory::class,
                    'applications' => ApplicationClientFactory::class,
                    'conversion' => ConversionClientFactory::class,
                    'insights' => InsightsClientFactory::class,
                    'numbers' => NumbersClientFactory::class,
                    'meetings' => MeetingsClientFactory::class,
                    'messages' => MessagesClientFactory::class,
                    'redact' => RedactClientFactory::class,
                    'secrets' => SecretsClientFactory::class,
                    'sms' => SMSClientFactory::class,
                    'subaccount' => SubaccountClientFactory::class,
                    'users' => UsersClientFactory::class,
                    'verify' => VerifyClientFactory::class,
                    'verify2' => Verify2ClientFactory::class,
                    'voice' => VoiceClientFactory::class,

                    // Additional 