ch ($files as $file) {
            if ($file instanceof SplFileInfo) {
                $view = $file->getRelativePathname();
                $view = str_replace($extensionsWithDots, '', $view);
                $view = str_replace('/', '.', $view);
                $views[] = $view;
            }
        }

        return $views;
    }
}
PK     os[xl    ;  Solutions/SolutionProviders/SailNetworkSolutionProvider.phpnu [        <?php

namespace Spatie\LaravelIgnition\Solutions\SolutionProviders;

use Spatie\Ignition\Contracts\BaseSolution;
use Spatie\Ignition\Contracts\HasSolutionsForThrowable;
use Throwable;

class SailNetworkSolutionProvider implements HasSolutionsForThrowable
{
    public function canSolve(Throwable $throwable): bool
    {
        return app()->runningInConsole()
            && str_contains($throwable->getMessage(), 'php_network_getaddresses')
            && file_exists(base_path('vendor/bin/sail'))
      f::REGEX, $throwable->getMessage(), $matches);

        $invalidController = $matches[1] ?? null;

        $suggestedController = $this->findRelatedController($invalidController);

        if ($suggestedController === $invalidController) {
            return [
                BaseSolution::create("`{$invalidController}` is not invokable.")
                    ->setSolutionDescription("The controller class `{$invalidController}` is not invokable. Did you forget to add the `__invoke` method or is the controller's method missing in your routes file?"),
            ];
        }

        if ($suggestedController) {
            return [
                BaseSolution::create("`{$invalidController}` was not found.")
                    ->setSolutionDescription("Controller class `{$invalidController}` for one of your routes was not found. Did you mean `{$suggestedController}`?"),
            ];
        }

        return [
            BaseSolution::create("`{$invalidController}` was not found.")
                ->setSolutionDescription("Controller class `{$invalidController}` for one of your routes was not found. Are you sure this controller exists and is imported correctly?"),
        ];
    }

    protected function findRelatedController(string $invalidController): ?string
    {
        $composerClassMap = app(ComposerClassMap::class);

        $controllers = collect($composerClassMap->listClasses())
            ->filter(function (string $file, string $fqcn) {
                return Str::endsWith($fqcn, 'Controller');
            })
            ->mapWithKeys(function (string $file, string $fqcn) {
                return [$fqcn => class_basename($fqcn)];
            })
            ->toArray();

        $basenameMatch = StringComparator::findClosestMatch($controllers, $invalidController, 4);

        $controllers = array_flip($controllers);

        $fqcnMatch = StringComparator::findClosestMatch($controllers, $invalidController, 4);

        return $fqcnMatch ?? $basenameMatch;
    }
}
