issingClass): void
    {
        $this->foundClass = $this->composerClassMap->searchClassMap($missingClass);

        if (is_null($this->foundClass)) {
            $this->foundClass = $this->composerClassMap->searchPsrMaps($missingClass);
        }
    }
}
PK     os[=fR  R  F  Solutions/SolutionProviders/RunningLaravelDuskInProductionProvider.phpnu [        <?php

namespace Spatie\LaravelIgnition\Solutions\SolutionProviders;

use Exception;
use Spatie\Ignition\Contracts\BaseSolution;
use Spatie\Ignition\Contracts\HasSolutionsForThrowable;
use Throwable;

class RunningLaravelDuskInProductionProvider implements HasSolutionsForThrowable
{
    public function canSolve(Throwable $throwable): bool
    {
        if (! $throwable instanceof Exception) {
            return false;
        }

        return $throwable->getMessage() === 'It is unsafe to run Dusk in production.';
    }

    public function getSolutions(Throwable $throwable): array
    {
        return [
            BaseSolution::create()
                ->setSolutionTitle('Laravel Dusk should not be run in production.')
                ->setSolutionDescription('Install the dependencies with the `--no-dev` flag.'),

            BaseSolution::create()
                ->setSolutionTitle('Laravel Dusk can be run in other environments.')
                ->setSolutionDescription('Consider setting the `APP_ENV` to something other than `production` like `local` for example.'),
        ];
    }
}
PK     os[sm
  
  E  Solutions/SolutionProviders/UndefinedViewVariableSolutionProvider.phpnu [        <?php

namespace Spatie\LaravelIgnition\Solutions\SolutionProviders;

use Spatie\Ignition\Contracts\BaseSolution;
use Spatie\Ignition\Contracts\HasSolutionsForThrowable;
use Spatie\Ignition\Contracts\Solution;
use Spatie\LaravelIgnition\Exceptions\ViewException;
use Spatie\LaravelIgnition\Solutions\MakeViewVariableOptionalSolution;
use Spatie\LaravelIgnition\Solutions\SuggestCorrectVariableNameSolution;
use Throwable;

class UndefinedViewVariableSolutionProvider implements HasSolutionsForThrowable
{
    protected string $variableName;

    protected string $viewFile;

    public function canSolve(Throwable $throwable): bool
    {
        if (! $throwable instanceof ViewException) {
            return false;
        }

        return $this->getNameAndView($throwable) !== null;
    }

    public function getSolutions(Throwable $throwable): array
    {
        $solutions = [];

        /** @phpstan-ignore-next-line  */
        extract($this->getNameAndView($throwable));

        if (! isset($variableName)) {
            return [];
        }

        if (isset($viewFile)) {
            /** @phpstan-ignore-next-line  */
            $solutions = $this->findCorrectVariableSolutions($throwable, $variableName, $viewFile);
            $solutions[] = $this->findOptionalVariableSolution($variableName, $viewFile);
        }


        return $solutions;
    }

    /**
     * @param \Spatie\LaravelIgnition\Exceptions\ViewException $throwable
     * @param string $variableName
     * @param string $viewFile
     *
     * @return array<int, \Spatie\Ignition\Contracts\Solution>
     */
    protected function findCorrectVariableSolutions(
        ViewException $throwable,
        string $variableName,
        string $viewFile
    ): array {
        return collect($throwable->getViewData())
            ->map(function ($value, $key) use ($variableName) {
                similar_text($variableName, $key, $percentage);

                return ['match' => $per