    ->filter(fn (ReflectionMethod $reflectionMethod) => str_starts_with($reflectionMethod->name, 'get') && str_ends_with($reflectionMethod->name, 'Property'))
            ->map(fn (ReflectionMethod $reflectionMethod) => lcfirst(Str::of($reflectionMethod->name)->after('get')->before('Property')));

        return $this->filterItemsBySimilarity(
            $properties->merge($computedProperties),
            $similar
        );
    }

    public function getMethodNamesLike(string $similar): Collection
    {
        $methods = collect($this->reflectionClass->getMethods(ReflectionMethod::IS_PUBLIC))
            // @phpstan-ignore-next-line
            ->reject(fn (ReflectionMethod $reflectionMethod) => $reflectionMethod->class !== $this->reflectionClass->name)
            ->map(fn (ReflectionMethod $reflectionMethod) => $reflectionMethod->name);

        return $this->filterItemsBySimilarity($methods, $similar);
    }

    protected function filterItemsBySimilarity(Collection $items, string $similar): Collection
    {
        return $items
            ->map(function (string $name) use ($similar) {
                similar_text($similar, $name, $percentage);

                return ['match' => $percentage, 'value' => $name];
            })
            ->sortByDesc('match')
            ->filter(function (array $item) {
                return $item['match'] > 40;
            })
            ->map(function (array $item) {
                return $item['value'];
            })
            ->values();
    }
}
PK     os[NL      Support/FlareLogHandler.phpnu [        <?php

namespace Spatie\LaravelIgnition\Support;

use InvalidArgumentException;
use Monolog\Handler\AbstractProcessingHandler;
use Monolog\Level;
use Monolog\Logger;
use Monolog\LogRecord;
use Spatie\FlareClient\Flare;
use Spatie\FlareClient\Report;
use Throwable;

class FlareLogHandler extends AbstractProcessingHandler
{
    protected Flare $flare;

    protected SentReports $sentReports;

    protected int $minimumReportLogLevel;

    public function __construct(Flare $flare, SentReports $sentReports, $level = Level::Debug, $bubble = true)
    {
        $this->flare = $flare;

        $this->minimumReportLogLevel = Level::Error->value;

        $this->sentReports = $sentReports;

        parent::__construct($level, $bubble);
    }

    public function setMinimumReportLogLevel(int $level): void
    {
        if (! in_array($level, Level::VALUES)) {
            throw new InvalidArgumentException('The given minimum log level is not supported.');
        }

        $this->minimumReportLogLevel = $level;
    }

    protected function write(LogRecord $record): void
    {
        if (! $this->shouldReport($record->toArray())) {
            return;
        }
        if ($this->hasException($record->toArray())) {
           