<?php

namespace Spatie\LaravelIgnition\Support;

use Illuminate\Support\Collection;
use Illuminate\Support\Str;
use Livewire\LivewireManager;
use ReflectionClass;
use ReflectionMethod;
use ReflectionProperty;

class LivewireComponentParser
{
    protected string $componentClass;

    protected ReflectionClass $reflectionClass;

    public static function create(string $componentAlias): self
    {
        return new self($componentAlias);
    }

    public function __construct(protected string $componentAlias)
    {
        $  /**
     * Check if runnable solutions are allowed based on the current
     * environment and config.
     *
     * @return bool
     */
    public static function check(): bool
    {
        if (! config('app.debug')) {
            // Never run solutions in when debug mode is not enabled.

            return false;
        }

        if (config('ignition.enable_runnable_solutions') !== null) {
            // Allow enabling or disabling runnable solutions regardless of environment
            // if the IGNITION_ENABLE_RUNNABLE_SOLUTIONS env var is explicitly set.

            return config('ignition.enable_runnable_solutions');
        }

        if (! app()->environment('local') && ! app()->environment('development')) {
            // Never run solutions on non-local environments. This avoids exposing
            // applications that are somehow APP_ENV=production with APP_DEBUG=true.

            return false;
        }

        return config('app.debug');
    }
}
PK     os[#4u    #  Support/LivewireComponentParser.phpnu [        <?php

namespace Spatie\LaravelIgnition\Support;

use Illuminate\Support\Collection;
use Illuminate\Support\Str;
use Livewire\LivewireManager;
use ReflectionClass;
use ReflectionMethod;
use ReflectionProperty;

class LivewireComponentParser
{
    protected string $componentClass;

    protected ReflectionClass $reflectionClass;

    public static function create(string $componentAlias): self
    {
        return new self($componentAlias);
    }

    public function __construct(protected string $componentAlias)
    {
        $this->componentClass = app(LivewireManager::class)->getClass($this->componentAlias);
        $this->reflectionClass = new ReflectionClass($this->componentClass);
    }

    public function getComponentClass(): string
    {
        return $this->componentClass;
    }

    public function getPropertyNamesLike(string $similar): Collection
    {
        $properties = collect($this->reflectionClass->getProperties(ReflectionProperty::IS_PUBLIC))
            // @phpstan-ignore-next-line
            ->reject(fn (ReflectionProperty $reflectionProperty) => $reflectionProperty->class !== $this->reflectionClass->name)
            ->map(fn (ReflectionProperty $reflectionProperty) => $reflectionProperty->name);

        $computedProperties = collect($this->reflectionClass->getMethods(ReflectionMethod::IS_PUBLIC))
            // @phpstan-ignore-next-line
            ->reject(fn (ReflectionMethod $reflectionMet