*  $roundingMode
     *
     * @psalm-return numeric-string
     */
    private function round(string $amount, int $roundingMode): string
    {
        if ($roundingMode === self::ROUND_UP) {
            return self::$calculator::ceil($amount);
        }

        if ($roundingMode === self::ROUND_DOWN) {
            return self::$calculator::floor($amount);
        }

        return self::$calculator::round($amount, $roundingMode);
    }

    /**
     * Round to a specific unit.
     *
     * @psalm-param positive-int|0  $unit
     * @psalm-param self::ROUND_* $roundingMode
     */
    public function roundToUnit(int $unit, int $roundingMode = self::ROUND_HALF_UP): self
    {
        if ($unit === 0) {
            return $this;
        }

        $abs = self::$calculator::absolute($this->amount);
        if (strlen($abs) < $unit) {
            return new self('0', $this->currency);
        }

        /** @psalm-var numeric-string $toBeRounded */
        $toBeRounded = substr($this->amount, 0, strlen($this->amount) - $unit) . '.' . substr($this->amount, $unit * -1);

        $result = $this->round($toBeRounded, $roundingMode);
        if ($result !== '0') {
            $result .= str_PK     g.s[n3  3  
  Teller.phpnu [        eric-string $result */
        return new self($result, $this->currency);
    }

    public function absolute(): Money
    {
        return new self(
            self::$calculator::absolute($this->amount),
            $this->currency
        );
    }

    public function negative(): Money
    {
        return (new self(0, $this->currency))
            ->subtract($this);
    }

    /**
     * Checks if the value represented by this object is zero.
     */
    public function isZero(): bool
    {
        return self::$calculator::compare($this->amount, '0') === 0;
    }

    /**
     * Checks if the value represented by this object is positive.
     */
    public function isPositive(): bPK     g.s[n3  3  
  Teller.phpnu [        >amount, '0') > 0;
    }

    /**
     * Checks if the value represented by this object is negative.
     */
    public function isNegative(): bool
    {
        return self::$calculator::compare($this->amount, '0') < 0;
    }

    /**
     * {@inheritdoc}
     *
     * @psalm-return array{amount: string, currency: string}
     */
    public function jsonSerialize(): array
    {
        return [
            'amount' => $this->amount,
            'currency' => $this->currency->jsonSerialize(),
        ];
    }

    /**
     * @param Money $first
     * @param Money ...$collection
     *
     * @psalm-pure
     */
    public static function min(self $first, self ...$collection): Money
    {
        $min = $first;

        foreach ($collection as $money) {
            if (! $money->lessThan($min)) {
                continue;
            }

            $min = $money;
        }

        return $min;
    }

    /**
     * @param Money $first
     * @param Money ...$collection
     *
     * @psalm-pure
     */
    public static function max(self $first, self ...$collection): Money
    {
        $max = $first;

        foreach ($collection as $money) {
            if (! $money->greaterThan($max)) {
                continue;
            }

            $max = $money;
        }

        return $max;
    }

    /** @psalm-pure */
    public static function sum(self $first, self ...$collection): Money
    {
        return $first->add(...$collection);
    }

    /** @psalm-pure */
    public static function avg(self $first, selfPK     g.s[n3  3  
  Teller.phpnu [        ..$collection)->divide((string) (count($collection) + 1));
    }

    /** @psalm-param class-string<Calculator> $calculator */
    public static function registerCalculator(string $calculator): void
    {
        self::$calculator = $calculator;
    }

    /** @psalm-return class-string<Calculator> */
    public static function getCalculator(): string
    {
        return self::$calculator;
    }
}
PK     g.s[n3  3  
  Teller.phpnu [        <?php

declare(strict_types=1);

namespace Money;

use Money\Currencies\ISOCurrencies;
use Money\Formatter\DecimalMoneyFormatter;
use Money\Parser\DecimalMoneyParser;

use function array_shift;
use function is_float;

final class Teller
{
    /**
     * Convenience factory method for a Teller object.
     *
     * <code>
     * $teller = Teller::USD();
     * </code>
     *
     * @param non-empty-string $method
     * @param array{0?: int}   $arguments
     *
     * @return Teller
     */
    public static function __callStatic(string $method, array $arguments): self
    {
        $currency     = new Currency($method);
        $currencies   = new ISOCurrencies();
        $parser       = new DecimalMoneyParser($currencies);
        $formatter    = new DecimalMoneyFormatter($currencies);
        $roundingMode = empty($arguments)
            ? Money::ROUND_HALF_UP
            : (int) array_shift($arguments);

        return new self(
            $currency,
            $parser,
            $formatter,
            $roundingMode
        );
    }

    private Currency $currency;

    private MoneyFormatter $formatter;

    private MoneyParser $parser;

    private int $roundingMode = Money::ROUND_HALF_UP;

    public function __construct(
        Currency $currency,
        MoneyParser $parser,
        MoneyFormatter $formatter,
        int $roundingMode = Money::ROUND_HALF_UP
    ) {
        $this->currency     = $currency;
        $this->parser       = $parser;
        $this->formatter    = $formatter;
        $this->roundingMode = $roundingMode;
    }

    /**
     * Are two monetary amounts equal to each other?
     *
     * @param mixed $amount a monetary amount
     * @param mixed $other  another monetary amount
     */
    public function equals(mixed $amount, mixed $other): bool
    {
        return $this->convertToMoney($amount)->equals(
            $this->convertToMoney($other)
        );
    }

    /**
     * Returns an integer less than, equal to, or greater than zero if a
     * monetary amount is respectively less than, equal to, or greater than
     * another.
     *
     * @param mixed $amount a monetary amount
     * @param mixed $other  another monetary amount
     */
    public function compare(mixed $amount, mixed $other): int
    {
        return $this->convertToMoney($amount)->compare(
            $this->convertToMoney($other)
        );
    }

    /**
     * Is one monetary amount greater than another?
     *
     * @param mixed $amount a monetary amount
     * @param mixed $other  another monetary amount
     */
    public function greaterThan(mixed $amount, mixed $other): bool
    {
        return $this->convertToMoney($amount)->greaterThan(
            $this->convertToMoney($other)
        );
    }

    /**
     * Is one monetary amount greater than or equal to another?
     *
     * @param mixed $amount a monetary amount
     * @param mixed $other  another monetary amount
     */
    public function greaterThanOrEqual(mixed $amount, mixed $other): bool
    {
        return $this->convertToMoney($amount)->greaterThanOrEqual(
            $this->convertToMoney($other)
        );
    }

    /**
     * Is one monetary amount less than another?
     *
     * @param mixed $amount a monetary amount
     * @param mixed $other  another monetary amount
     */
    public function lessThan(mixed $amount, mixed $other): bool
    {
        return $this->convertToMoney($amount)->lessThan(
            $this->convertToMoney($other)
        );
    }

    /**
     * Is one monetary amount less than or equal to another?
     *
     * @param mixed $amount a monetary amount
     * @param mixed $other  another monetary amount
     */
    public function lessThanOrEqual(mixed $amount, mixed $other): bool
    {
        return $this->convertToMoney($amount)->lessThanOrEqual(
            $this->convertToMoney($other)
        );
    }

    /**
     * Adds a series of monetary amounts to each other in sequence.
     *
     * @param mixed   $amount a monetary amount
     * @param mixed   $other  another monetary amount
     * @param mixed[] $others subsequent other monetary amounts
     *
     * @return string the calculated monetary amount
     */
    public function add(mixed $amount, mixed $other, mixed ...$others): string
    {
        return $this->convertToString(
            $this->convertToMoney($amount)->add(
                $this->convertToMoney($other),
                ...$this->convertToMoneyArray($others)
            )
        );
    }

    /**
     * Subtracts a series of monetary amounts from each other in sequence.
     *
     * @param mixed   $amount a monetary amount
     * @param mixed   $other  another monetary amount
     * @param mixed[] $others subsequent monetary amounts
     */
    public function subtract(mixed $amount, mixed $other, mixed ...$others): string
    {
        return $this->convertToString(
            $this->convertToMoney($amount)->subtract(
                $this->convertToMoney($other),
                ...$this->convertToMoneyArray($others)
            )
        );
    }

    /**
     * Multiplies a monetary amount by a factor.
     *
     * @param mixed                    $amount     a monetary amount
     * @param int|float|numeric-string $multiplier the multiplier
     */
    public function multiply(mixed $amount, int|float|string $multiplier): string
    {
        $multiplier = is_float($multiplier) ? Number::fromFloat($multiplier) : Number::fromNumber($multiplier);

        return $this->convertToString(
            $this->convertToMoney($amount)->multiply(
                (string) $multiplier,
                $this->roundingMode
            )
        );
    }

    /**
     * Divides a monetary amount by a divisor.
     *
     * @param mixed                    $amount  a monetary amount
     * @param int|float|numeric-string $divisor the divisor
     */
    public function divide(mixed $amount, int|float|string $divisor): string
    {
        $divisor = is_float($divisor) ? Number::fromFloat($divisor) : Number::fromNumber($divisor);

        return $this->convertToString(
            $this->convertToMoney($amount)->divide(
                (string) $divisor,
                $this->roundingMode
            )
        );
    }

    /**
     * Mods a monetary amount by a divisor.
     *
     * @param mixed                    $amount  a monetary amount
     * @param int|float|numeric-string $divisor the divisor
     */
    public function mod(mixed $amount, int|float|string $divisor): string
    {
        $divisor = is_float($divisor) ? Number::fromFloat($divisor) : Number::fromNumber($divisor);

        return $this->convertToString(
            $this->convertToMoney($amount)->mod(
                $this->convertToMoney((string) $divisor)
            )
        );
    }

    /**
     * Allocates a monetary amount according to an array of ratios.
     *
     * @param mixed                                 $amount a monetary amount
     * @param non-empty-array<array-key, float|int> $ratios an array of ratios
     *
     * @return string[] the calculated monetary amounts
     */
    public function allocate(mixed $amount, array $ratios): array
    {
        return $this->convertToStringArray(
            $this->convertToMoney($amount)->allocate($ratios)
        );
    }

    /**
     * Allocates a monetary amount among N targets.
     *
     * @param mixed $amount a monetary amount
     * @psalm-param positive-int $n the number of targets
     *
     * @return string[] the calculated monetary amounts
     */
    public function allocateTo(mixed $amount, int $n): array
    {
        return $this->convertToStringArray(
            $this->convertToMoney($amount)->allocateTo($n)
        );
    }

    /**
     * Determines the ratio of one monetary amount to another.
     *
     * @param mixed $amount a monetary amount
     * @param mixed $other  another monetary amount
     */
    public function ratioOf(mixed $amount, mixed $other): string
    {
        return $this->convertToString(
            $this->convertToMoney($amount)->ratioOf(
                $this->convertToMoney($other)
            )
        );
    }

    /**
     * Returns an absolute monetary amount.
     *
     * @param mixed $amount a monetary amount
     */
    public function absolute(mixed $amount): string
    {
        return $this->convertToString(
            $this->convertToMoney($amount)->absolute()
        );
    }

    /**
     * Returns the negative of an amount; note that this will convert negative
     * amounts to positive ones.
     *
     * @param mixed $amount a monetary amount
     */
    public function negative(mixed $amount): string
    {
        return $this->convertToString(
            $this->convertToMoney($amount)->negative()
        );
    }

    /**
     * Is a monetary amount equal to zero?
     *
     * @param mixed $amount a monetary amount
     */
    public function isZero(mixed $amount): bool
    {
        return $this->convertToMoney($amount)->isZero();
    }

    /**
     * Is a monetary amount greater than zero?
     *
     * @param mixed $amount a monetary amount
     */
    publ