     $this->maxLogs = $maxLogs;
    }

    public function start(): self
    {
        /** @phpstan-ignore-next-line */
        $this->app['events']->listen(MessageLogged::class, [$this, 'record']);

        return $this;
    }

    public function record(MessageLogged $event): void
    {
        if ($this->shouldIgnore($event)) {
            return;
        }

        $this->logMessages[] = LogMessage::fromMessageLoggedEvent($event);

        if (is_int($this->maxLogs)) {
            $this->logMessages = array_slice($this->logMessages, -$this->maxLogs);
        }
    }

    /** @return array<array<int,string>> */
    public function getLogMessages(): array
    {
        return $this->toArray();
    }

    /** @return array<int, mixed> */
    public function toArray():