

<?php $__env->startPush('css'); ?>
    
<?php $__env->stopPush(); ?>

<?php $__env->startSection('contents'); ?>
<div class="breadcrumb-area">
  <h3 class="title"><?php echo app('translator')->get('Receive Request Money'); ?></h3>
  <ul class="breadcrumb">
      <li>
        <a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
      </li>

      <li>
          <?php echo app('translator')->get('Receive Request Money'); ?>
      </li>
  </ul>
</div>

<div class="dashboard--content-item">
    <div class="table-responsive table--mobile-lg">
        <table class="table bg--body">
            <thead>
                <tr>
                  <th><?php echo e(__('Date')); ?></th>
                  <th><?php echo e(__('Request From')); ?></th>
                  <th><?php echo e(__('Amount')); ?></th>
                  <th><?php echo e(__('Status')); ?></th>
                  <th><?php echo e(__('Details')); ?></th>
                </tr>
            </thead>
            <tbody>
              <?php if(count($requests) == 0): ?>
              <tr>
                <td colspan="12">
                  <h4 class="text-center m-0 py-2"><?php echo e(__('No Data Found')); ?></h4>
                </td>
              </tr>
              <?php else: ?>
                <?php $__currentLoopData = $requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <?php
                      $from = App\Models\User::where('id',$data->user_id)->first();
                  ?>
                  <tr>
                      <td data-label="<?php echo e(__('Date')); ?>">
                        <div>
                          <?php echo e($data->created_at->toFormattedDateString()); ?>

                        </div>
                      </td>
                      <td data-label="<?php echo e(__('Request From')); ?>">
                        <div>
                          <?php echo e($from != NULL ? $from->name : 'User Deleted'); ?>

                        </div>
                      </td>
                      <td data-label="<?php echo e(__('Amount')); ?>">
                        <div>
                          <?php echo e(showprice($data->amount,$currency)); ?>

                        </div>
                      </td>
                      <td data-label="<?php echo e(__('Status')); ?>">
                        <div>
                          <span class="badge bg-<?php echo e($data->status == 1 ? 'success' : 'warning'); ?>"><?php echo e($data->status == 1 ? 'completed' : 'pending'); ?></span>
                        </div>
                      </td>

                      <td data-label="<?php echo e(__('Details')); ?>">
                        <div class="btn-list">
                            <a href="<?php echo e(route('user.money.request.details',$data->id)); ?>" class="btn btn-primary">
                              <?php echo e(__('Details')); ?>

                            </a>

                            <?php if($data->status == 0): ?>
                              <a href="javascript:;" id="sendBtn" data-href="<?php echo e(route('user.request.money.send',$data->id)); ?>" class="btn text--body" data-bs-toggle="modal" data-bs-target="#modal-success">
                                <?php echo e(__('Send')); ?>

                              </a>
                            <?php endif; ?>
                        </div>
                      </td>
                  </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php endif; ?>
            </tbody>
        </table>
    </div>
    <?php echo e($requests->links()); ?>

</div>


<div class="modal fade confirm-modal" id="modal-success" aria-modal="true" role="dialog">
  <div class="modal-dialog">
      <div class="modal-content">
        <form id="requestMoney" action="" method="POST" enctype="multipart/form-data">
          <?php echo csrf_field(); ?>
          <div class="modal-body p-4">
            <h4 class="modal-title text-center" id="withdrawModalTitle"><?php echo app('translator')->get('Receive Request Money'); ?></h4>
              <div class="modal-body text-center py-4">
                <p class="text-center"><?php echo e(__("You are about to change the status.")); ?></p>
                <p class="text-center"><?php echo e(__("Do you want to proceed?")); ?></p>
              </div>

              <div class="d-flex">
                  <button type="button" class="btn shadow-none btn--danger me-2 w-50" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                  <button type="submit" class="btn shadow-none btn--success w-50"><?php echo app('translator')->get('Proceed'); ?></button>
              </div>
          </div>
        </form>
      </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
  <script>
    'use strict';
    
    $("#sendBtn").on('click',function(){
      $("#requestMoney").prop("action",$(this).data('href'))
    })
  </script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fluxyjvi/public_html/project/resources/views/user/requestmoney/receive.blade.php ENDPATH**/ ?>