

<?php $__env->startPush('css'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
	<!-- Banner -->
	<section class="banner-section bg--gradient overflow-hidden position-relative border-bottom">
		<div class="hero-bg bg_img" data-img="<?php echo e(asset('assets/images/'.$gs->breadcumb_banner)); ?>"></div>
		<div class="container">
			<div class="hero-text">
				<h2 class="hero-text-title"><?php echo app('translator')->get('Investment Plan'); ?></h2>
				<ul class="breadcrumb">
					<li>
						<a href="<?php echo e(route('front.index')); ?>"><?php echo app('translator')->get('Home'); ?></a>
					</li>
					<li>
						<?php echo app('translator')->get('Invest Plan'); ?>
					</li>
				</ul>
			</div>
		</div>
		</div>
	</section>
	<!-- Banner -->

    <!-- Investment Plan -->
    <section class="investment-plan-section overflow-hidden bg--gradient-light pb-100 pt-100">
        <div class="container">
            <div class="section-header text-center">
                    <h6 class="section-header__subtitle"><?php echo app('translator')->get('Investment Plans & Pricing'); ?></h6>
                    <h2 class="section-header__title"><?php echo e($ps->plan_title); ?></h2>
                    <p>
                        <?php echo e('At Fluxe Assets Ltd., we believe that wealth building should be accessible, transparent, and tailored to individual goals. Our carefully curated investment plans are designed to meet a range of financial objectives — from capital preservation to long-term growth. Whether you are a first-time investor or a seasoned portfolio builder, our packages offer flexible options to help you invest with confidence.'); ?>

                    </p>
            </div>
            <div class="pricing--wrapper row g-3 g-md-4 g-lg-3 g-xxl-4 justify-content-center">
                <?php if(count($plans) == 0): ?>
                    <div class="col-12 text-center">
                            <h3 class="m-0"><?php echo e(__('No Plan Found')); ?></h3>
                    </div>
                <?php else: ?>
                    <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $schedule = \App\Models\ManageSchedule::where('time',$data->schedule_hour)->first();
                    ?>
                    <div class="col-lg-3 col-sm-6 col-md-6">
                        <div class="plan__item">
                            <div class="plan__item-header">
                                <div class="left">
                                    <h5 class="title"><?php echo e($data->title); ?></h5>
                                    <span><?php echo e($data->subtitle); ?></span>
                                </div>
                                <div class="right">
                                    <h5 class="title"><?php echo e($data->profit_percentage); ?>%</h5>
                                    <span><?php echo app('translator')->get('Return'); ?></span>
                                </div>
                            </div>
                            <div class="plan__item-body">
                                <ul>
                                    <li>
                                        <span class="name"><?php echo app('translator')->get('Profit'); ?></span>
                                        <span class="info">
                                            <?php echo e($data->lifetime_return == 1 ? 'Lifetime' :  'Every '.$schedule->name); ?>

                                        </span>
                                    </li>
                                    <li>
                                        <span class="name me-1"><?php echo app('translator')->get('Capital will back'); ?></span>
                                        <span class="badge align-self-center me-auto bg--<?php echo e($data->captial_return == 1 ? 'primary' : 'danger'); ?>"><?php echo e($data->captial_return == 1 ? 'Yes' : 'No'); ?></span>
                                    </li>
                                </ul>
                                <?php if($data->invest_type == 'range'): ?>
                                    <h6 class="text-center amount-range"><?php echo e(showPrice($data->min_amount)); ?> - <?php echo e(showPrice($data->max_amount)); ?></h6>
                                <?php else: ?> 
                                    <h6 class="text-center amount-range"><?php echo e(showPrice($data->fixed_amount)); ?></h6>
                                <?php endif; ?>
                                
                                <?php if(auth()->user()): ?>
                                <button class="cmn--btn w-100 invest-plan" type="button" data-bs-toggle="modal"
                                    data-bs-target="#invest-modal" data-title="<?php echo e($data->title); ?>" data-id="<?php echo e($data->id); ?>" data-type="<?php echo e($data->invest_type == 'range' ? 0 : 1); ?>" data-fixAmount="<?php echo e(rootPrice($data->fixed_amount)); ?>">
                                    <?php echo app('translator')->get('Invest Now'); ?>
                                </button>
                                <?php else: ?>
                                <a class="cmn--btn w-100 invest-plan" href="<?php echo e(route('user.login')); ?>" >
                                    <?php echo app('translator')->get('Invest Now'); ?>
                                </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>
        </div>
    </section>
    <!-- Investment Plan -->

    <!-- Choose -->
    <?php if ($__env->exists('partials.front.choose')) echo $__env->make('partials.front.choose', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Choose -->

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fluxyjvi/public_html/project/resources/views/frontend/plan.blade.php ENDPATH**/ ?>