<?php $__env->startPush('css'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('contents'); ?>

<div class="breadcrumb-area">
  <h3 class="title"><?php echo app('translator')->get('User Profile'); ?></h3>
  <ul class="breadcrumb">
      <li>
          <a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
      </li>
      <li>
        <?php echo app('translator')->get('User Profile'); ?>
      </li>
  </ul>
</div>
<div class="dashboard--content-item">
  <?php if ($__env->exists('includes.flash')) echo $__env->make('includes.flash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <form id="request-form" action="<?php echo e(route('user.profile.update')); ?>" method="POST" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>
  <div class="profile--card">
      <div class="user--profile mb-5">
          <div class="thumb">
              <img src="<?php echo e(auth()->user()->photo ? asset('assets/images/'.auth()->user()->photo) : asset('assets/front/images/clients/avatarprofile.png')); ?>" alt="clients">
          </div>
          <div class="remove-thumb">
              <i class="fas fa-times"></i>
          </div>
          <div class="content">
              <div>
                  <h3 class="title">
                      <?php echo e(auth()->user()->name); ?>

                  </h3>
                  <a href="#0" class="text--base">
                      <?php echo e(auth()->user()->email); ?>

                  </a>
              </div>
              <div class="mt-4">
                  <label class="btn btn-sm btn--base text--dark">
                      <?php echo app('translator')->get('Update Profile Picture'); ?>
                      <input type="file" id="profile-image-upload" name="photo" hidden>
                  </label>
              </div>
          </div>
      </div>

          <div class="row gy-4">
              <div class="col-sm-6 col-xxl-4">
                  <label for="name" class="form-label"><?php echo app('translator')->get('Name'); ?></label>
                  <input type="text" id="name" name="name" class="form-control" value="<?php echo e($user->name); ?>">
              </div>

              <div class="col-sm-6 col-xxl-4">
                  <label for="email" class="form-label"><?php echo app('translator')->get('Email Address'); ?></label>
                  <input type="email" id="email" class="form-control"
                      value="<?php echo e($user->email); ?>" readonly>
              </div>

              <div class="col-sm-6 col-xxl-4">
                  <label for="phone" class="form-label"><?php echo app('translator')->get('Phone Number'); ?></label>
                  <input type="text" name="phone" id="phone" class="form-control" value="<?php echo e($user->phone); ?>">
              </div>

              <div class="col-sm-6 col-xxl-4">
                  <label for="name" class="form-label"><?php echo app('translator')->get('Zip'); ?></label>
                  <input type="text" name="zip" class="form-control" value="<?php echo e($user->zip); ?>">
              </div>

              <div class="col-sm-6 col-xxl-4">
                <label for="city" class="form-label"><?php echo app('translator')->get('City'); ?></label>
                <input type="text" name="city" id="city" class="form-control" value="<?php echo e($user->city); ?>">
              </div>

              <div class="col-sm-6 col-xxl-4">
                <label for="last-name" class="form-label"><?php echo app('translator')->get('Fax'); ?></label>
                <input type="text" id="last-name" name="fax" class="form-control" value="<?php echo e($user->fax); ?>">
              </div>

              <div class="col-sm-6 col-xxl-4">
                <label for="address" class="form-label"><?php echo app('translator')->get('Address'); ?></label>
                <input type="text" id="address"  name="address" class="form-control" value="<?php echo e($user->address); ?>">
              </div>

              <div class="col-sm-6 col-xxl-4">

              </div>

              <div class="col-sm-12">
                  <div class="text-end">
                      <button type="submit" class="cmn--btn"><?php echo app('translator')->get('Update Profile'); ?></button>
                  </div>
              </div>
          </div>
        </div>
      </form>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script>
  "use strict"
  var prevImg = $('.user--profile .thumb').html();
  function proPicURL(input) {
      if (input.files && input.files[0]) {
          var uploadedFile = new FileReader();
          uploadedFile.onload = function (e) {
              var preview = $('.user--profile').find('.thumb');
              preview.html(`<img src="${e.target.result}" alt="user">`);
              preview.addClass('image-loaded');
              preview.hide();
              preview.fadeIn(650);
              $(".image-view").hide();
              $(".remove-thumb").show();
          }
          uploadedFile.readAsDataURL(input.files[0]);
      }
  }
  $("#profile-image-upload").on('change', function () {
      proPicURL(this);
  });
  $(".remove-thumb").on('click', function () {
      $(".user--profile .thumb").html(prevImg);
      $(".user--profile .thumb").removeClass('image-loaded');
      $(".image-view").show();
      $(this).hide();
  })
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fluxyjvi/public_html/project/resources/views/user/profile.blade.php ENDPATH**/ ?>