<?php

return [
    'site_title_separator' => ' - ',
    'text_edit' => 'Edit',
    'text_filter' => 'Filter',
    'text_clear' => 'Clear',
    'text_search' => 'Search',
    'text_enabled' => 'Enabled',
    'text_disabled' => 'Disabled',
    'text_active' => 'Active',
    'text_inactive' => 'Inactive',
    'text_incomplete' => 'Incomplete',
    'text_new' => 'New',
    'text_no' => 'No',
    'text_yes' => 'Yes',
    'text_none' => 'None',
    'text_hide' => 'Hide',
    'text_show' => 'Show',
    'text_action' => 'Action',
    'text_dashes' => ' -- ',
    'text_equals' => ' = ',
    'text_times' => 'x ',
    'text_plus' => '+ ',
    'text_please_select' => ' - please select - ',
    'text_use_default' => 'Use Default',
    'text_updated' => 'updated',
    'text_added' => 'added',
    'text_deleted' => 'deleted',
    'text_default' => 'Default',
    'text_select_all' => 'Select All',
    'text_select_none' => 'Select None',
    'text_select' => 'Select',
    'text_all_locations' => 'All Locations',
    'text_selected' => 'Selected',
    'text_now' => 'Now',
    'text_never' => 'Never',
    'text_remove' => 'Remove',
    'text_reload' => 'Reload',
    'text_save' => 'Save',
    'text_saving' => 'Saving...',
    'text_resetting' => 'Resetting...',
    'text_loading' => 'Loading...',
    'text_deleting' => 'Deleting...',
    'text_support' => 'Help Center',
    'text_documentation' => 'Documentation',
    'text_community_support' => 'Community Support',
    'text_empty' => 'Empty',
    'text_help' => 'Click for Help',
    'text_no_title' => 'No Title',
    'text_allow' => 'Allow',
    'text_opening' => 'Opening',
    'text_delivery' => 'Delivery',
    'text_collection' => 'Pick-up',

    'label_code' => 'Code',
    'label_name' => 'Name',
    'label_type' => 'Type',
    'label_email' => 'Email',
    'label_status' => 'Status',
    'label_location' => 'Location(s)',
    'label_description' => 'Description',

    'column_id' => 'ID',
    'column_location' => 'Location(s)',
    'column_date_added' => 'Date Added',
    'column_date_updated' => 'Date Updated',

    'text_filter_location' => 'View all locations',
    'text_filter_status' => 'View all status',
    'text_filter_date' => 'View all dates',
    'text_back_link' => 'Go back to the previous page',
    'text_admin_link' => 'Return to the admin dashboard',

    'button_new' => '<i class="fa fa-plus"></i>&nbsp;&nbsp;New',
    'button_delete' => '<i class="fa fa-trash-o"></i>&nbsp;&nbsp;Delete',
    'button_add' => 'Add',
    'button_edit' => 'Edit',
    'button_continue' => 'Continue',
    'button_filter' => 'Filter',
    'button_save' => '<i class="fa fa-save"></i>&nbsp;&nbsp;Save',
    'button_save_close' => '<i class="fa fa-save"></i>&nbsp;&nbsp;Save & Close',
    'button_icon_back' => '<i class="fa fa-arrow-left px-0"></i>',
    'button_icon_filter' => '<i class="fa fa-filter"></i>',
    'button_icon_delete' => '<i class="fa fa-trash-o"></i>',
    'button_close' => 'Close',
    'button_refresh' => '<i class="fa fa-refresh"></i>&nbsp;&nbsp;Refresh',

    'alert_success' => '%s successfully.',
    'alert_error' => 'An error occurred, %s.',
    'alert_error_nothing' => 'An error occurred, nothing %s.',
    'alert_error_try_again' => 'An error occurred, please try again.',
    'alert_warning_confirm' => 'This cannot be undone! Are you sure you want to do this?',
    'alert_confirm' => 'Are you sure you want to do this?',
    'alert_user_not_logged_in' => 'You must be logged in to access that page.',
    'alert_user_restricted' => 'Warning: You do not have the right permission to view this page, please contact the system administrator.',
    'alert_location_restricted' => 'Warning: You do not have the right permission to access context outside your location, please contact the system administrator.',
    'alert_warning_locationable_delete' => 'Warning: You do not have the right permission to delete record(s) attached to multiple locations, please contact the system administrator.',
    'alert_form_error_message' => 'Sorry but form validation has failed, please check for errors.',
    'alert_error_set_default' => '"%s" is disabled and cannot be set as default.',
    'alert_missing_method' => 'Missing method [%s] in %s.',
    'alert_missing_model_definition' => "Model '%s' does not contain a definition for '%s'.",
    'alert_valid_values' => 'Valid values for [locationAware] property are (none,show,hide).',
    'alert_widget_class_name' => "The Widget class name '%s' has not been registered",
    'alert_missing_field_property' => "Missing form field property 'modelClass' in '%s'",
    'alert_invalid_ajax_handler_name' => 'Invalid ajax handler name: %s',
    'alert_invalid_ajax_partial_name' => 'Invalid partial name: %s',
    'alert_widget_not_bound_to_controller' => "A widget with class name '%s' has not been bound to the controller",
    'alert_user_not_logged' => 'User is not logged in',
    'alert_access_denied' => 'Access denied.',
    'alert_invalid_csrf_token' => 'Invalid security token, please reload the page and try again.',

    'title_access_denied' => 'Access denied',
    'title_page_not_found' => 'No page found',
    'alert_page_not_found' => 'There\'s no page at this address, check the URL and try again.',

    'text_settings_title' => 'Settings',
    'text_message_title' => 'Your messages',
    'text_activity_title' => 'Recent activities',
    'text_empty_activity' => 'No recent activity',
    'text_empty_message' => 'No message found',
    'text_see_all_message' => 'See all messages',
    'text_see_all_activity' => 'See all activities',
    'text_see_all_customers' => 'See all customers',
    'text_see_all_orders' => 'See all orders',
    'text_user' => 'User',
    'text_staff_group' => 'Staff Group',
    'text_location' => 'Location',
    'text_set_status' => 'Set Status',
    'text_edit_details' => 'Edit Details',
    'text_network_admin' => 'Network Admin',
    'text_administration' => 'Administration',
    'text_logout' => 'Logout',
    'text_switch_to_assigned' => 'Switch to assigned view',
    'text_switch_to_list' => 'Switch to list view',

    'help_permalink' => 'Use ONLY alpha-numeric lowercase characters, _ or - and make sure it is unique GLOBALLY.',

    'staff_status' => [
        'text_set_status' => 'Set a status',
        'text_online' => 'Online',
        'text_back_soon' => 'Back Soon',
        'text_away' => 'Away',
        'text_lunch_break' => 'On my lunch break...',
        'text_custom_status' => 'Set a custom away status',
        'text_clear_tomorrow' => 'Clear tomorrow',
        'text_clear_hours' => 'Clear in 4 hours',
        'text_clear_minutes' => 'Clear in 30 minutes',
        'text_dont_clear' => 'Don\'t Clear',
    ],

    'side_menu' => [
        'updates' => 'Updates',
        'storefront' => 'Storefront',
        'page' => 'Static Pages',
        'system_logs' => 'System Logs',
        'setting' => 'Settings',
        'dashboard' => 'Dashboard',
        'menu' => 'Menu Items',
        'category' => 'Categories',
        'table' => 'Tables',
        'sale' => 'Sales',
        'order' => 'Orders',
        'reservation' => 'Reservations',
        'user' => 'Staff',
        'customer' => 'Customers',
        'customer_group' => 'Groups',
        'staff_group' => 'Groups',
        'staff_role' => 'Roles',
        'activities' => 'Activities',
        'restaurant' => 'Restaurant',
        'location' => 'Locations',
        'marketing' => 'Marketing',
        'localisation' => 'Localisation',
        'language' => 'Languages',
        'currency' => 'Currencies',
        'country' => 'Countries',
        'rating' => 'Ratings',
        'status' => 'Statuses',
        'mealtimes' => 'Mealtimes',
        'extension' => 'Extensions',
        'payment' => 'Payments',
        'design' => 'Design',
        'theme' => 'Themes',
        'mail_template' => 'Mail Templates',
        'tool' => 'Tools',
        'media_manager' => 'Media Manager',
        'system' => 'System',

        'alert_no_definition' => 'No definition for item %s.',
        'alert_invalid_menu' => 'Invalid item specified.',
        'alert_menu_not_found' => 'No main menu item found matching {%s}.',
        'alert_invalid_status' => 'Status message is required.',
    ],

    'list' => [
        'missing_model' => 'List action used in %s does not have a model defined.',
        'missing_definitions' => 'List action used in %s does not have definitions.',
        'invalid_column_datetime' => 'Column value \'%s\' is not a DateTime object, are you missing a $dates reference in the Model?',
        'delete_empty' => 'Nothing selected to delete.',
        'missing_column' => 'List used in %s has no list columns defined.',
        'text_empty' => 'Nothing found.',
        'text_setup' => 'Setup',
        'text_showing' => 'Showing %s-%s of %s records',
        'setup_title' => 'List Setup - %s',
        'label_visible_columns' => 'Visible Columns',
        'label_page_limit' => 'Items Per Page',
        'button_reset_setup' => 'Reset',
        'button_cancel_setup' => 'Cancel',
        'button_apply_setup' => 'Apply changes',
        'filter_missing_definitions' => "The model class %s must define a method %s returning options for the '%s' filter.",
        'filter_missing_scope_definitions' => 'No definition for scope %s',
        'help_visible_columns' => 'Set which columns are visible and in what order to display them',
        'help_page_limit' => 'Limit how many records are shown per page',
        'alert_relationship_not_supported' => 'The relationship %s is not supported for list columns.',
        'missing_action_code' => 'Invalid bulk action code specified.',
        'action_not_found' => 'Bulk Action class (%s) not found',

        'actions' => [
            'text_select' => 'Select an action to apply',
            'label_edit' => 'Edit',
            'label_status' => 'Enable/Disable',
            'label_enable' => 'Enable',
            'label_disable' => 'Disable',
            'text_select_all' => 'Select all %s records',
        ],
    ],

    'calendar' => [
        'missing_model' => 'Calendar action used in %s does not have a model defined.',
        'missing_definitions' => 'Calendar action used in %s does not have model definitions.',
        'missing_method' => "Calender action '%s' does not contain a method '%s'.",
        'missing_partial' => "Calender action  defined in '%s' is missing a popover partial.",
    ],

    'form' => [
        'create_title' => ':name: Create',
        'edit_title' => ':name: Edit',
        'preview_title' => ':name: Preview',
        'missing_model' => 'Form action used in %s does not have a model defined.',
        'missing_definitions' => 'Form action field [%s] does not have definitions.',
        'missing_definition' => 'Form action does not contain a field definition for: %s.',
        'missing_method' => "Form action '%s' does not contain a method '%s'.",
        'undefined_tab' => 'Misc',
        'create_success' => '%s created successfully',
        'edit_success' => '%s updated successfully',
        'delete_success' => '%s deleted successfully',
        'create_failed' => '%s create failed',
        'edit_failed' => '%s update failed',
        'delete_failed' => '%s delete failed',
        'insert_row' => 'Insert Row',
        'insert_row_below' => 'Insert Row Below',
        'delete_row' => 'Delete Row',
        'not_ready' => 'Form action has not been initialized, check that you have called initForm() in your controller.',
        'options_method_not_exists' => 'The model class %s must define a method %s returning options for the [%s] form field.',
        'field_invalid_type' => 'Invalid field type used %s.',
        'missing_id' => 'Form record ID has not been specified.',
        'not_found' => 'Form record with ID [%s] could not be found.',
        'mass_assignment_failed' => "Mass assignment failed for Model attribute ':attribute'.",
        'record_not_found' => 'Record not found.',
        'request_class_not_found' => 'Form Request class (%s) not found',
        'record_not_found_in_model' => 'Record ID [%s] not found in model %s.',

        'save_actions' => [
            'continue' => 'Continue Editing',
            'close' => 'Go to Listing',
            'new' => 'Create New',
        ],
    ],

    'allergens' => [
        'text_title' => 'Allergens',
        'text_allergens' => 'Allergens',
        'text_form_name' => 'Allergen',
        'text_filter_search' => 'Search by name.',
        'text_empty' => 'There are no allergens available.',

        'label_image' => 'Image',
        'help_photo' => 'Select a file to update allergen image, otherwise leave blank.',
    ],

    'categories' => [
        'text_title' => 'Categories',
        'text_form_name' => 'Category',
        'text_filter_search' => 'Search by name.',
        'text_empty' => 'There are no categories available.',

        'column_parent' => 'Parent',
        'column_priority' => 'Priority',

        'label_permalink_slug' => 'Slug',
        'label_parent' => 'Parent',
        'label_image' => 'Image',
        'label_priority' => 'Priority',

        'help_photo' => 'Select a file to update category image, otherwise leave blank.',
    ],

    'customer_groups' => [
        'text_title' => 'Customer Groups',
        'text_form_name' => 'Customer Group',
        'text_empty' => 'There are no customer groups available.',

        'column_customers' => '# Customers',

        'label_approval' => 'Approval',

        'alert_set_default' => 'Customer group set as default',

        'help_approval' => 'New customers must be approved before they can login.',
    ],

    'customers' => [
        'text_title' => 'Customers',
        'text_form_name' => 'Customer',
        'text_tab_general' => 'Customer',
        'text_tab_address' => 'Addresses',
        'text_tab_orders' => 'Orders',
        'text_tab_reservations' => 'Reservations',
        'text_filter_search' => 'Search by name or email.',
        'text_empty' => 'There are no customers available.',
        'text_subscribe' => 'Subscribe',
        'text_un_subscribe' => 'Un-subscribe',
        'text_title_edit_address' => 'Address',
        'text_impersonate' => 'Impersonate Customer',

        'column_full_name' => 'Full Name',
        'column_telephone' => 'Telephone',
        'column_date_added' => 'Date Registered',

        'button_activate' => 'Manually Activate',

        'label_first_name' => 'First Name',
        'label_last_name' => 'Last Name',
        'label_password' => 'Password',
        'label_confirm_password' => 'Confirm Password',
        'label_telephone' => 'Telephone',
        'label_newsletter' => 'Newsletter',
        'label_send_invite' => 'Send Invitation Email',
        'label_customer_group' => 'Customer Group',
        'label_address_1' => 'Address 1',
        'label_address_2' => 'Address 2',
        'label_city' => 'City',
        'label_state' => 'State',
        'label_postcode' => 'Postcode',
        'label_country' => 'Country',

        'help_send_invite' => 'Sends an invitation message containing a link to set a password on their account.',
        'help_password' => 'Leave blank to leave password unchanged',

        'alert_login_restricted' => 'Warning: You do not have the right permission to <b>access a customer account</b>, please contact system administrator.',
        'alert_impersonate_confirm' => 'Are you sure you want to impersonate this customer? You can revert to your original state by logging out.',
        'alert_impersonate_success' => 'You are now impersonating customer: %s',
        'alert_activation_success' => 'Customer activated successfully.',
        'alert_customer_not_active' => "Cannot login user '%s' until activated.",
        'alert_customer_payment_profile_not_found' => 'Customer payment profile not found!',
    ],

    'dashboard' => [
        'text_title' => 'Dashboard',
        'text_heading' => 'Dashboard',
        'text_add_widget' => 'Add Widget',
        'text_edit_widget' => 'Edit Widget',
        'text_select_widget' => 'Select a widget',

        'text_zero' => '0',
        'text_dash_dash' => '--',
        'text_today' => 'Today',
        'text_delivery' => 'Delivery',
        'text_collection' => 'Pick-up',
        'text_no_activity' => 'There are no new activities available.',
        'text_total_sale' => 'Total Sales',
        'text_total_lost_sale' => 'Total Lost Sales',
        'text_total_cash_payment' => 'Total Cash Payments',
        'text_total_customer' => 'Total Customers',
        'text_total_order' => 'Total Orders',
        'text_total_delivery_order' => 'Total Delivery Orders',
        'text_total_collection_order' => 'Total Pick-up Orders',
        'text_total_completed_order' => 'Total Orders Completed',
        'text_total_reservation' => 'Total Reservations',
        'text_total_reserved_guest' => 'Total Guests',
        'text_total_completed_reservation' => 'Total Reservations Completed',
        'text_total_reserved_table' => 'Total Table(s) Reserved',
        'text_complete_setup' => 'Complete Restaurant Setup',
        'text_progress' => 'Complete',
        'text_progress_initial' => 'Initial Setup',
        'text_progress_setting' => 'Your restaurant settings',
        'text_progress_menus' => 'Add Menus',
        'text_progress_design' => 'Design your website background',
        'text_progress_email' => 'Send test email',
        'text_progress_count' => '60%',
        'text_progress_summary' => 'Follow these steps to get your restaurant up &amp; running. ',
        'text_initial_progress' => '<b>Initial Setup</b> - Set your preferred general settings, such as restaurant name and email.',
        'text_settings_progress' => '<b>Your restaurant settings</b> - Let your customers know your restaurant opening times, delivery hours, preparation time and where its located.',
        'text_menus_progress' => '<b>Add Menus</b> - Add your menu using our simple editor. Display multiple menus like delivery &amp; eat-in, includes sizes and meal options',
        'text_design_progress' => '<b>Design your website background</b> - Upload your own or choose a background image for your website from our gallery.',
        'text_email_progress' => '<b>Send test email</b> - Ensure order confirmation emails are sent to customers successfully.',
        'text_statistic' => 'Statistics',
        'text_range' => 'Range',
        'text_week' => 'Last 7 Days',
        'text_month' => 'Last 30 Days',
        'text_year' => 'This Year',
        'text_context' => 'Context',
        'text_stats_card' => 'Card',
        'text_charts_dataset' => 'Datasets',
        'text_cache_usage' => 'Cache Usage',
        'text_total_cache' => 'Total cache size:',
        'text_news' => 'TastyIgniter News',
        'text_news_count' => 'News Count',
        'text_recent_activity' => 'Recent Activity',
        'text_activities_count' => 'Activities Count',
        'text_top_customers' => 'Top Customers',
        'text_latest_order' => '10 Latest Orders',
        'text_reports_chart' => 'Reports Chart',
        'text_select_range' => 'Select date range',
        'text_last_version_check' => 'Your last <b>TastyIgniter core version check</b> was more than a week ago. <a href="%s"><b>Check for Updates</b></a>',

        'alert_select_widget_to_update' => 'Please select a widget to update.',
        'alert_select_widget_to_add' => 'Please select a widget to add.',
        'alert_widget_class_not_found' => 'The selected class does not exist.',
        'alert_invalid_widget' => 'The selected class is not a dashboard widget.',
        'alert_invalid_aliases' => 'Invalid aliases string.',
        'alert_invalid_priorities' => "'Invalid priorities string.'",
        'alert_invalid_data_posted' => 'Invalid data posted.',
        'alert_widget_not_found' => 'The specified widget is not found.',

        'onboarding' => [
            'title' => 'Getting started',
            'label_settings' => 'Complete required system settings',
            'label_locations' => 'Configure a default location',
            'label_themes' => 'Customize your site',
            'label_extensions' => 'Install recommended extensions',
            'label_payments' => 'Configure your payment gateways',
            'label_menus' => 'Add your Menu Items',
            'label_mail' => 'Send test email',

            'help_settings' => 'Confirm all required system settings are specified.',
            'help_locations' => 'Set your default delivery area and customise your opening hours.',
            'help_themes' => 'Activate and customize the front-end theme',
            'help_extensions' => 'Some extensions are recommended for your site to function properly.',
            'help_payments' => 'Enable and configure a default payment method for your customers.',
            'help_menus' => 'Make your menu items available for your customers to order.',
            'help_mail' => 'Ensure order confirmation emails are sent to customers successfully.',
        ],

        'charts' => [
            'text_orders' => 'Orders',
            'text_reservations' => 'Reservations',
            'text_customers' => 'Customers',
        ],

        'column_location' => 'Location',
        'column_ready_type' => 'Ready Time',
        'column_total_orders' => '# Orders',
        'column_total_sale' => 'Total Sale',

        'label_widget' => 'Widget',
        'label_widget_title' => 'Widget Title',
        'label_widget_columns' => 'Widget Grid Width',
        'label_widget_css_class' => 'Widget CSS Class',

        'button_add_widget' => 'Add Widget',
        'button_reset_widgets' => 'Reset Widgets',
        'button_set_default' => 'Set As Default',

        'help_widget_columns' => 'The widget width, a number between 1 and 12.',

        'error_rss' => 'The URL address is incorrect or',

        'alert_set_default_confirm' => 'Are you sure you want to set the current widgets as default for all users?',
        'alert_reset_layout_success' => 'Layout reset successfully',
    ],

    'locations' => [
        'text_title' => 'Locations',
        'text_form_name' => 'Location',
        'text_tab_general' => 'Details',
        'text_tab_schedules' => 'Schedules',
        'text_tab_options' => 'Options',
        'text_tab_general_options' => 'General options',
        'text_tab_delivery' => 'Delivery Areas',
        'text_tab_gallery' => 'Gallery',
        'text_tab_title_address' => 'Address',
        'text_filter_search' => 'Search by name, city or state.',
        'text_empty' => 'There are no locations available.',
        'text_24_7' => '24/7',
        'text_daily' => 'Daily',
        'text_flexible' => 'Flexible',
        'text_timesheet' => 'Timesheet',
        'text_schedule' => 'Schedule',
        'text_title_schedule' => 'Edit %s schedule',
        'text_same_as' => 'Same as %s hours',
        'text_open' => 'Open',
        'text_closed' => 'Closed',
        'text_circle' => 'Circle',
        'text_shape' => 'Shape (polygon)',
        'text_custom' => 'Address',
        'text_address_component_street' => 'Match by Street name',
        'text_address_component_town' => 'Match by town or sub-locality',
        'text_address_component_city' => 'Match by city or locality',
        'text_address_component_region' => 'Match by region or administrative area level 2',
        'text_address_component_state' => 'Match by state or administrative area level 1',
        'text_address_component_postal_code' => 'Match by postal code',
        'text_delivery_area' => 'Delivery Areas',
        'text_add_new_area' => 'Add new area',
        'text_edit_area' => 'Delivery Area',
        'text_all_orders' => 'all',
        'text_above_order_total' => 'above',
        'text_below_order_total' => 'below',
        'text_asap_only' => 'ASAP only',
        'text_later_only' => 'Later only',

        'column_city' => 'City',
        'column_state' => 'State',
        'column_postcode' => 'Postcode',
        'column_telephone' => 'Telephone',

        'label_address_1' => 'Address 1',
        'label_address_2' => 'Address 2',
        'label_city' => 'City',
        'label_state' => 'State',
        'label_postcode' => 'Postcode',
        'label_country' => 'Country',
        'label_auto_lat_lng' => 'Automatically fetch lat/lng',
        'label_latitude' => 'Latitude',
        'label_longitude' => 'Longitude',
        'label_radius' => 'Delivery Radius',
        'label_telephone' => 'Telephone',
        'label_permalink_slug' => 'Slug',
        'label_image' => 'Image',
        'label_schedule_name' => 'Name',
        'label_schedule_type' => 'Type',
        'label_schedule_days' => 'Days',
        'label_schedule_hours' => 'Hours',
        'label_schedule_open' => 'Start Time',
        'label_schedule_close' => 'End Time',
        'label_area_shape' => 'Area Shape',
        'label_area_circle' => 'Area Circle',
        'label_area_vertices' => 'Area Vertices',
        'label_area_type' => 'Area Type',
        'label_area_default' => 'Set As Default',
        'label_area_id' => 'Area ID',
        'label_area_name' => 'Area Name',
        'label_area_charge' => 'Charge',
        'label_area_distance' => 'Distance (mile/kilometers)',
        'label_address_component' => 'Address Component',
        'label_address_component_type' => 'Address Component Type',
        'label_address_component_value' => 'Address Component Value',
        'label_charge_condition' => 'Rule',
        'label_area_min_amount' => 'Total',
        'label_gallery_title' => 'Title',
        'label_gallery_add_image' => 'Add Media',
        'label_gallery_image_thumbnail' => 'Thumbnail',
        'label_gallery_image_name' => 'Filename',
        'label_gallery_image_alt' => 'Alt Text',
        'label_delivery_condition' => 'Delivery Charge Condition',
        'label_delivery_distance' => 'Distance Based Delivery Charge Condition',

        'error_no_zero_total' => 'The %s can not be a value zero on conditions other than \'on all orders\'.',
        'alert_delivery_area' => 'Add at least one delivery area to allow your customers find this location.',
        'alert_set_default' => 'Location set as default',
        'alert_missing_map_center' => 'Map is missing center coordinates, please enter an address then click save.',
        'alert_missing_map_config' => 'Missing Google Maps Javascript Library, please provide your maps api key on the general system settings page.',
        'alert_invalid_area' => 'Invalid area selected.',
        'alert_schedule_not_loaded' => 'Schedule not loaded.',
        'alert_invalid_schedule_type' => "Defined parameter '%s' is not a valid working type.",

        'help_permalink_disabled' => 'Permalink is disabled when single location mode is activated.',
        'help_image' => 'Select a logo for this location.',
        'help_guest_order' => 'Allow customer to place an order without creating an account, or use the default system settings.',
        'help_flexible_hours' => 'Start typing to set the opening hours, such as 09:00-01:00 or 09:00-10:00,19:00-01:00',
        'help_delivery_areas' => 'Set delivery conditions to specific geographical area/boundaries. Delivery areas are applied in the order in which they appear. Every location must have at least one delivery area to accept delivery orders.',
        'help_delivery_condition' => 'Use the table below to set different delivery charge conditions. Conditions/Rules are applied in the order in which they appear. For free delivery set charge to 0 or -1 to make delivery unavailable. When an \'all\' rule is present, no other condition will be applied.',
        'help_delivery_components' => 'All rules must be VALID to apply this delivery area, each rule is matched against the user\'s address component. Values can contain Regular Expressions.',
        'help_delivery_distance' => 'Add additional charges based on the delivery distance per unit. These will be in addition to delivery condition charges. Rules are applied in the order in which they appear.',
    ],

    'login' => [
        'text_title' => 'Login',
        'text_password_reset_title' => 'Reset Password',
        'text_forgot_password' => 'Forgot your password?',
        'text_reset_password_title' => 'Reset your Password',
        'text_back_to_login' => 'Back to Login',

        'button_login' => 'Login',
        'button_reset_password' => 'Reset Password',

        'label_reset_code' => 'Reset code',
        'label_username' => 'Username',
        'label_password' => 'Password',
        'label_password_confirm' => 'Confirm Password',

        'alert_username_not_found' => 'Login failed, please try again or contact the system administrator!',
        'alert_success_reset' => 'You\'ve successfully changed your password.',
        'alert_failed_reset' => 'The reset code is either invalid or expired.',
        'alert_success_logout' => 'You are now logged out.',
        'alert_email_sent' => 'We\'ve sent a password reset link to your email.',
        'alert_email_not_sent' => 'The e-mail could not be sent. Possible reason: your host may have disabled the mail() function.',
    ],

    'mealtimes' => [
        'text_title' => 'Mealtimes',
        'text_form_name' => 'Mealtime',
        'text_empty' => 'There are no mealtimes, please add.',

        'column_mealtime_id' => 'ID',
        'column_mealtime_name' => 'Name',
        'column_start_time' => 'Start Time',
        'column_end_time' => 'End Time',

        'label_mealtime_name' => 'Mealtime Name',
        'label_start_time' => 'Start Time',
        'label_end_time' => 'End Time',
    ],

    'menu_options' => [
        'text_title' => 'Menu Options',
        'text_form_name' => 'Menu Option',
        'text_tab_general' => 'General',
        'text_tab_values' => 'Option Values',
        'text_empty' => 'There are no menu options available.',
        'text_filter_search' => 'Search by name or price.',
        'text_filter_display_type' => 'View all display types',
        'text_select' => 'Select',
        'text_radio' => 'Radio',
        'text_checkbox' => 'Checkbox',
        'text_quantity' => 'Quantity',
        'is_required' => 'is required',
        'is_not_required' => 'is not required',
        'text_option' => 'Option',
        'text_option_summary' => 'Display as a %s HTML element',

        'column_display_type' => 'Display Type',

        'label_option_name' => 'Option Name',
        'label_priority' => 'Priority',
        'label_display_type' => 'Display Type',
        'label_option_values' => 'Option Values',
        'label_option_value' => 'Option Value',
        'label_option_price' => 'Option Price',
        'label_option_id' => 'Option ID',
        'label_update_related_menu_item' => 'Update option values of associated menu items',
    ],

    'menus' => [
        'text_title' => 'Menus',
        'text_form_name' => 'Menu',
        'text_tab_general' => 'Menu',
        'text_tab_menu_option' => 'Options',
        'text_tab_special' => 'Specials',
        'text_empty' => 'There are no menus available.',
        'text_filter_search' => 'Search by name, price or stock qty.',
        'text_filter_category' => 'View all categories',
        'text_mealtime_all' => 'Available all day',
        'text_delivery_only' => 'Delivery Only',
        'text_collection_only' => 'Pick-up Only',
        'text_fixed_amount' => 'Fixed Amount',
        'text_percentage' => 'Percentage',
        'text_forever' => 'Forever',
        'text_period' => 'Period',
        'text_recurring' => 'Recurring',

        'column_category' => 'Category',
        'column_price' => 'Price',
        'column_stock_qty' => 'Stock Qty',

        'label_price' => 'Price',
        'label_category' => 'Category',
        'label_image' => 'Image',
        'label_stock_qty' => 'Stock Quantity',
        'label_minimum_qty' => 'Minimum Quantity',
        'label_mealtime' => 'Mealtime',
        'label_order_restriction' => 'Order Restriction',
        'label_menu_priority' => 'Priority',
        'label_special_status' => 'Special Status',
        'label_option' => 'Option',
        'label_menu_option' => 'Menu Option',
        'label_option_id' => 'Option ID',
        'label_option_name' => 'Option Name',
        'label_option_display_type' => 'Option Display Type',
        'label_option_priority' => 'Option Priority',
        'label_option_required' => 'Option Required',
        'label_option_value' => 'Option Value',
        'label_option_price' => 'Option Price',
        'label_option_qty' => 'Stock Quantity',
        'label_option_default_value' => 'Default',
        'label_option_value_id' => 'ID',
        'label_min_selected' => 'Min Selected',
        'label_max_selected' => 'Max Selected',
        'label_start_date' => 'Start Date',
        'label_end_date' => 'End Date',
        'label_special_price' => 'Special Price',
        'label_special_type' => 'Special Type',
        'label_allergens' => 'Allergens',
        'label_validity' => 'Validity',
        'label_recurring_every' => 'Recurring every',
        'label_recurring_from_time' => 'Recurring from time',
        'label_recurring_to_time' => 'Recurring to time',

        'help_image' => 'Select a file to update menu image, otherwise leave blank.',
        'help_mealtime' => 'Set what time of day your customers can order this menu. Mealtimes can be managed under Kitchen > Mealtimes',
        'help_stock_qty' => 'Total stock available for this menu at all selected locations.',
        'help_minimum_qty' => 'Enter the minimum quantity that can be ordered by customers.',
        'help_menu_option' => 'Choose from the dropdown to add an option to this menu item.',
        'help_order_restriction' => 'Whether to restrict the menu to a specific order type.',
        'help_min_selected' => 'Minimum items to select from these options, leave blank to ignore.',
        'help_max_selected' => 'Maximum items to select from these options, leave blank to ignore.',
        'help_option_required' => 'Select Enabled if a customer MUST choose this option. If this option is not required, select Disabled.',
        'help_specials' => 'Select disable to deactivate Special. Select Enable to activate Special and enter the Start Date, End Date and price of your Special item.',
        'alert_menu_option_not_attached' => 'Please select a menu option to attach.',
    ],

    'orders' => [
        'text_title' => 'Orders',
        'text_form_name' => 'Order',
        'text_invoice_heading' => 'Order Invoice: %s',
        'text_tab_general' => 'Order',
        'text_status_history' => 'Status History',
        'text_payment_logs' => 'Payment Attempts',
        'text_tab_menu' => 'Menu Items',
        'text_empty' => 'There are no orders available.',
        'text_filter_search' => 'Search by id, location, status, staff or customer name.',
        'text_filter_assignee' => 'View all assignees',
        'text_filter_order_type' => 'View all order types',
        'text_filter_payment' => 'View all payments',
        'text_delivery' => 'Delivery',
        'text_collection' => 'Pick-up',
        'text_invoice' => 'Invoice',
        'text_restaurant' => 'Location',
        'text_customer' => 'Customer',
        'text_payment' => 'Payment',
        'text_invoice_no' => 'Invoice #',
        'text_invoice_date' => 'Invoice Date',
        'text_order_date' => 'Order Date',
        'text_deliver_to' => 'Deliver to',
        'text_asap' => 'ASAP',
        'text_invoice_thank_you' => 'Thank you for your order',
        'text_collection_order_type' => 'This is a pick-up order',
        'text_no_payment' => 'No payment method selected',
        'text_unassigned' => 'Yet to be Assigned',
        'text_assigned_to_self' => 'Assigned To Me',
        'text_assigned_to_others' => 'Assigned To Other Staff',

        'button_print_invoice' => '<i class="fa fa-receipt"></i>&nbsp;&nbsp;View Invoice',

        'column_location' => 'Location',
        'column_customer_name' => 'Customer Name',
        'column_payment' => 'Payment',
        'column_total' => 'Total',
        'column_time' => 'Order Time',
        'column_date' => 'Order Date',
        'column_time_date' => 'Date Time',
        'column_staff' => 'Staff',
        'column_comment' => 'Comment',
        'column_assignee' => 'Assigned To',
        'column_assignee_group' => 'Assigned To Group',
        'column_notify' => 'Customer Notified',
        'column_name_option' => 'Name/Options',
        'column_price' => 'Price',
        'column_quantity' => 'Qty',

        'label_order_id' => 'Order ID',
        'label_customer_name' => 'Customer Name',
        'label_telephone' => 'Telephone',
        'label_delivery_address' => 'Delivery Address',
        'label_order_type' => 'Order Type',
        'label_time_is_asap' => 'Order Time Is Asap',
        'label_order_time' => 'Delivery/Pick-up Time',
        'label_order_date' => 'Delivery/Pick-up Date',
        'label_order_date_time' => 'Delivery/Pick-up Date Time',
        'label_date_added' => 'Date Added',
        'label_order_total' => 'Order Total',
        'label_comment' => 'Notes',
        'label_delivery_comment' => 'Delivery Notes',
        'label_date_modified' => 'Date Modified',
        'label_user_agent' => 'User Agent',
        'label_ip_address' => 'IP Address',
        'label_invoice' => 'Invoice',
        'label_assign_staff' => 'Assignee',
        'label_restaurant_name' => 'Name',
        'label_restaurant_address' => 'Address',
        'label_payment_method' => 'Payment Method',
        'label_total_items' => 'Total Items',

        'activity_event_log_title' => 'Order status updated',
        'activity_event_log_assigned_title' => 'Order assigned',
        'activity_event_log' => 'updated order (#:properties.order_id) status to <b>:properties.status_name</b>',
        'activity_event_log_assigned' => 'assigned order (#:properties.order_id) to',

        'alert_invoice_not_generated' => 'Invoice has not yet been generated.',
    ],

    'payments' => [
        'text_title' => 'Payments',
        'text_form_name' => 'Payment',
        'text_tab_config' => 'Config',
        'text_filter_search' => 'Search by name or description.',
        'text_empty' => 'There are no payments available.',

        'label_payments' => 'Payment Gateways',
        'label_code' => 'Unique Code',
        'label_default' => 'Is Default',
        'label_priority' => 'Priority',

        'alert_setting_missing_id' => 'Extension setting code has not been specified.',
        'alert_invalid_code' => 'Invalid payment gateway code selected.',
        'alert_code_not_found' => 'Unable to find payment gateway with code %s',
        'alert_update_payment_profile' => 'The updatePaymentProfile() method is not supported by the payment gateway.',
        'alert_delete_payment_profile' => 'The deletePaymentProfile() method is not supported by the payment gateway.',
        'alert_pay_from_payment_profile' => 'The payFromPaymentProfile() method is not supported by the payment gateway.',
    ],

    'permissions' => [
        'name' => 'Administration',
        'dashboard' => 'Manage dashboard widgets',
        'categories' => 'Create, edit and delete menu categories',
        'customer_groups' => 'Manage customer groups',
        'customers' => 'Create, edit and delete customers',
        'impersonate_staff' => 'Ability to impersonate staff',
        'impersonate_customers' => 'Ability to impersonate customers',
        'locations' => 'Create, edit and delete locations',
        'menus' => 'Create, edit and delete menu items',
        'orders' => 'Edit orders',
        'delete_orders' => 'Delete orders',
        'delete_reservations' => 'Delete reservations',
        'assign_orders' => 'Assign orders',
        'assign_reservations' => 'Assign reservations',
        'payments' => 'Manage payment gateways',
        'reservations' => 'Manage reservations',
        'staff_groups' => 'Manage staff groups',
        'staffs' => 'Create, edit and delete staffs',
        'statuses' => 'Manage orders and reservations statuses',
        'tables' => 'Create, edit and delete reservations tables',
        'mealtimes' => 'Create, edit and delete mealtimes',
        'allergens' => 'Create, edit and delete allergens',
    ],

    'reservations' => [
        'text_title' => 'Reservations',
        'text_form_name' => 'Reservation',
        'text_tab_general' => 'Reservation',
        'text_tab_restaurant' => 'Restaurant',
        'text_status_history' => 'Status History',
        'text_empty' => 'There are no reservations available.',
        'text_filter_assignee' => 'View all assignees',
        'text_filter_search' => 'Search by id, location, guest number, status, customer or table name.',
        'text_switch_to_calendar' => 'Switch to calender view',
        'text_no_booking' => 'No Bookings',
        'text_restaurant' => 'Location',
        'text_unassigned' => 'Yet to be Assigned',
        'text_assigned_to_self' => 'Assigned To Me',
        'text_assigned_to_others' => 'Assigned To Other Staff',

        'column_location' => 'Location',
        'column_customer_name' => 'Name',
        'column_guest' => 'Guest(s)',
        'column_table' => 'Table',
        'column_staff' => 'Staff',
        'column_assignee' => 'Assigned To',
        'column_assignee_group' => 'Assigned To Group',
        'column_notify' => 'Customer Notified',
        'column_comment' => 'Comment',
        'column_date_time' => 'Date - Time',
        'column_time' => 'Time',
        'column_date' => 'Date',

        'label_reservation_id' => 'Reservation ID',
        'label_customer_name' => 'Customer Name',
        'label_guest' => 'Guest Number',
        'label_reservation_date' => 'Reservation Date',
        'label_reservation_time' => 'Reservation Time',
        'label_reservation_duration' => 'Reservation Duration',
        'label_occasion' => 'Occasion',
        'label_date_added' => 'Date Added',
        'label_date_modified' => 'Date Modified',
        'label_send_confirmation' => 'Send reservation confirmation',
        'label_user_agent' => 'User Agent',
        'label_ip_address' => 'IP Address',
        'label_assign_staff' => 'Assign Staff',
        'label_restaurant_name' => 'Restaurant Name',
        'label_restaurant_address' => 'Restaurant Address',
        'label_table_name' => 'Table Name',
        'label_table_capacity' => 'Table Maximum Capacity',
        'label_table_min_capacity' => 'Table Minimum Capacity',
        'label_first_name' => 'First Name',
        'label_last_name' => 'Last Name',
        'label_customer_telephone' => 'Telephone',

        'help_reservation_duration' => 'Stay time in minutes. Leave blank to use the default stay time',

        'activity_event_log_title' => 'Reservation status updated',
        'activity_event_log_assigned_title' => 'Reservation assigned',
        'activity_event_log' => 'updated reservation (#:properties.reservation_id) status to <b>:properties.status_name</b>',
        'activity_event_log_assigned' => 'assigned reservation (#:properties.reservation_id) to',

        'alert_no_reservation_found' => 'No matching reservation found.',
    ],

    'settings' => [
        'text_tab_setup' => 'Sales',
        'text_tab_tax' => 'Tax',
        'text_tab_user' => 'Customer registration',

        'text_tab_desc_user' => 'Configure registration email confirmation ...',
        'text_tab_desc_setup' => 'Configure order, reservation and invoicing settings',
        'text_tab_desc_tax' => 'Configure tax settings',
    ],

    'staff_groups' => [
        'text_title' => 'Staff Groups',
        'text_form_name' => 'Staff Group',
        'text_empty' => 'There are no staff groups available.',
        'text_round_robin' => 'Round Robin',
        'text_load_balanced' => 'Load Balanced',

        'label_auto_assign' => 'Automatic Order Assignment',
        'label_assignment_mode' => 'Assignment Mode',
        'label_assignment_availability' => 'Assignment Availability',
        'label_load_balanced_limit' => 'Load Balanced Limit',

        'column_users' => '# Users',

        'alert_no_available_assignee' => 'No available assignee.',

        'help_auto_assign' => 'Allocate and control the number of orders assigned to staff in this group.',
        'help_round_robin' => 'Assign orders to the staff who are online in a circular fashion.',
        'help_load_balanced' => 'Limit the number of orders a staff can handle simultaneously.',
        'help_load_balanced_limit' => 'Maximum number of orders per staff.',
        'help_assignment_availability' => 'Allow staff to control their availability for automatic order assignment',
    ],

    'staff_roles' => [
        'text_title' => 'Staff Roles',
        'text_form_name' => 'Staff Roles',
        'text_tab_permission' => 'Permissions',
        'text_empty' => 'There are no staff roles available.',

        'label_permissions' => 'Permissions',
    ],

    'staff' => [
        'text_title' => 'Staff',
        'text_form_name' => 'Staff',
        'text_filter_search' => 'Search by location, name or email.',
        'text_filter_role' => 'View all roles',
        'text_filter_group' => 'View all groups',
        'text_empty' => 'There are no staffs available.',
        'text_roles_scope_groups' => 'Scope, Roles and Groups',
        'text_sale_permission_global_access' => 'Global Access',
        'text_sale_permission_groups' => 'Groups',
        'text_sale_permission_restricted' => 'Restricted Access',
        'text_impersonate' => 'Impersonate Staff',

        'column_group' => 'Staff Groups',
        'column_role' => 'Staff Roles',
        'column_location' => 'Locations',
        'column_last_login' => 'Last Login',

        'label_super_staff' => 'Super Admin',
        'label_username' => 'Username',
        'label_send_invite' => 'Send Invitation Email',
        'label_password' => 'Password',
        'label_confirm_password' => 'Password Confirm',
        'label_role' => 'Role',
        'label_group' => 'Groups',
        'label_language' => 'Language',
        'label_location' => 'Locations',
        'label_sale_permission' => 'Order and Reservation Scope',

        'help_send_invite' => 'Sends an invitation message containing a link to set a password on their account.',
        'help_super_staff' => 'Grants this staff unlimited access to all areas of the system. Super staff can add and manage other staff.',
        'help_role' => 'Roles define staff permissions.',
        'help_groups' => 'Specify which groups the staff should belong to. Segmenting agents into groups lets you easily assign orders.',
        'help_location' => 'Specify which locations the staff should belong to. The staff can ONLY view menus, categories, orders, and reservations attached to the selected location(s). Does not apply to super admins',
        'help_sale_permission_global_access' => 'Can view all Orders and Reservations in the Admin Panel',
        'help_sale_permission_groups' => 'Can view Orders and Reservations in their Group(s) and Orders and Reservations assigned to them',
        'help_sale_permission_restricted' => 'Can only view Orders and Reservations assigned to them',

        'alert_login_restricted' => 'Warning: You do not have the right permission to <b>access a staff account</b>, please contact system administrator.',
        'alert_impersonate_confirm' => 'Are you sure you want to impersonate this staff? You can revert to your original state by logging out.',
        'alert_impersonate_success' => 'You are now impersonating staff: %s',
    ],

    'statuses' => [
        'text_title' => 'Statuses',
        'text_editor_title' => 'Add %s',
        'text_form_name' => 'Status',
        'text_filter_status' => 'View all status types',
        'text_empty' => 'There are no statuses available.',
        'text_order' => 'Order',
        'text_reservation' => 'Reservation',
        'text_unassigned' => 'Yet to be Assigned',
        'text_assigned_to_self' => 'Assigned To Me',
        'text_assigned_to_others' => 'Assigned To Other Staff',

        'column_comment' => 'Status Comment',
        'column_notify' => 'Notify',
        'column_time_date' => 'Date Time',
        'column_staff' => 'Staff',
        'column_assignee' => 'Assigned To',

        'label_for' => 'Status For',
        'label_color' => 'Color',
        'label_notify' => 'Email Notification',
        'label_notify_customer' => 'Notify Customer',
        'label_comment' => 'Comment',

        'label_assignee_group' => 'Assign To Group',
        'label_assignee' => 'Assign To Staff',

        'help_notify' => 'Set whether an email is sent to the customer after this status is set to the order. This option can be overridden from the order edit page.',
        'help_notify_customer' => 'Set whether to send a status update email to the customer',

        'help_assignee_group' => 'A notification is sent out to all the staff in the selected group',

        'alert_already_added' => 'The selected %s must be different from the current %s',
        'alert_invalid_action' => 'Invalid action.',
        'alert_status_not_found' => 'Status ID [%s] not found.',
    ],

    'stocks' => [
        'text_title' => 'Stocks',
        'text_form_name' => 'Stock',
        'text_title_manage_stock' => 'Manage Stock',
        'text_title_stock_history' => 'Stock History',
        'text_stock_description' => 'Managing stock for <b>%s</b> at %s location(s)',
        'text_empty' => 'There are no locations available.',

        'button_manage_stock' => 'Manage Stock',
        'button_stock_history' => 'Stock History',

        'text_action_none' => 'Select reason',
        'text_action_in_stock' => '[+] Stock Received',
        'text_action_restock' => '[+] Restock',
        'text_action_recount' => '[=] Stock Re-count',
        'text_action_sold' => '[-] Sold',
        'text_action_returned' => '[-] Returned',
        'text_action_waste' => '[-] Waste',

        'label_is_tracked' => 'Track Stock',
        'label_quantity' => 'Stock Quantity',
        'label_stock_action' => 'Stock Action',
        'label_stock_quantity' => 'Add, remove or recount stock',
        'label_low_stock_alert' => 'Low Stock Alerts',
        'label_low_stock_threshold' => 'Low Stock Threshold',

        'column_staff_name' => 'Staff Name',
        'column_quantity' => 'Quantity',
        'column_created_at' => 'Calculated At',

        'help_is_tracked' => 'When enabled, ordered menu and/or options quantities are automatically subtracted.',
        'help_low_stock_alert' => 'Enable automated low stock alerts so that you receive emails when the stock quantity falls below or equals the specified threshold.',
    ],

    'tables' => [
        'text_title' => 'Tables',
        'text_form_name' => 'Table',
        'text_empty' => 'There are no tables available.',
        'text_filter_search' => 'Search by name or capacity.',

        'column_min_capacity' => 'Minimum Capacity',
        'column_capacity' => 'Maximum Capacity',
        'column_extra_capacity' => 'Extra Capacity',
        'column_priority' => 'Priority',
        'column_joinable' => 'Is Joinable',

        'label_min_capacity' => 'Minimum Capacity',
        'label_capacity' => 'Maximum Capacity',
        'label_extra_capacity' => 'Extra Capacity',
        'label_priority' => 'Priority',
        'label_joinable' => 'Is Joinable',

        'help_tables' => 'Select a table to attach to this location.',
        'help_extra_capacity' => 'Used internally by the staff to determine table convenience/inconvenience.',

        'error_capacity' => 'The Maximum capacity value must be greater than minimum capacity value.',
        'error_table_widget_data_not_specified' => 'The Table widget data source is not specified in the configuration.',
        'error_table_widget_data_class_not_found' => 'The Table widget data source class "%s" could not be found.',
    ],
];
