<?php $__env->startSection('contents'); ?>
<div class="breadcrumb-area">
	<h3 class="title"><?php echo app('translator')->get('Transaction'); ?></h3>
	<ul class="breadcrumb">
		<li>
		  <a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
		</li>

		<li>
			<?php echo app('translator')->get('Transaction'); ?>
		</li>
	</ul>
</div>

<div class="dashboard--content-item">
	<div class="card p-3 default--card">
	  <form action="<?php echo e(route('user.transaction')); ?>" method="get">
		<div class="row ">
		  <div class="col-md-4">
			<input name="trx_no" class="form-control" autocomplete="off" placeholder="<?php echo e(__('Transaction no')); ?>" type="text" value="<?php echo e(old('trx_no')); ?>">
		  </div>

		  <div class="col-md-4">
			<select id="type" name="type" required class="form-control">
			  <option value=""><?php echo e(__('Select Type')); ?></option>
			  <option value="all" <?php echo e(request()->type == 'all' ? 'selected' : ''); ?>><?php echo e(__('All')); ?></option>
			  <option value="Deposit" <?php echo e(request()->type == 'Deposit' ? 'selected' : ''); ?>><?php echo e(__('Deposit')); ?></option>
			  <option value="Payout" <?php echo e(request()->type == 'Payout' ? 'selected' : ''); ?>><?php echo e(__('Payout')); ?></option>
			  <option value="ReferralBonus" <?php echo e(request()->type == 'ReferralBonus' ? 'selected' : ''); ?>><?php echo e(__('Referral Bonus')); ?></option>
			  <option value="SendMoney" <?php echo e(request()->type == 'SendMoney' ? 'selected' : ''); ?>><?php echo e(__('Send Money')); ?></option>
			  <option value="ReceiveMoney" <?php echo e(request()->type == 'ReceiveMoney' ? 'selected' : ''); ?>><?php echo e(__('Receive Money')); ?></option>
			  <option value="Invest" <?php echo e(request()->type == 'Invest' ? 'selected' : ''); ?>><?php echo e(__('Invest')); ?></option>
			  <option value="InterestMoney" <?php echo e(request()->type == 'InterestMoney' ? 'selected' : ''); ?>><?php echo e(__('Interest Money')); ?></option>
			  <option value="RequestMoney" <?php echo e(request()->type == 'RequestMoney' ? 'selected' : ''); ?>><?php echo e(__('Request Money')); ?></option>
			  <option value="Payout Accepted" <?php echo e(request()->type == 'Payout Accepted' ? 'selected' : ''); ?>><?php echo e(__('Payout Accepted')); ?></option>
			  <option value="PayoutRejected" <?php echo e(request()->type == 'PayoutRejected' ? 'selected' : ''); ?>><?php echo e(__('Payout Rejected')); ?></option>
			</select>
		  </div>

		  <div class="col-md-4">
			<button type="submit" class="cmn--btn bg--primary submit-btn w-100 border-0"><?php echo e(__('Submit')); ?></button>
		  </div>
		</div>
	  </form>
	</div>
  </div>

<div class="dashboard--content-item">
	  <div class="table-responsive table--mobile-lg">
		  <table class="table bg--body">
			  <thead>
				  <tr>
					<th><?php echo app('translator')->get('No'); ?></th>
					<th><?php echo app('translator')->get('Type'); ?></th>
					<th><?php echo app('translator')->get('Txnid'); ?></th>
					<th><?php echo app('translator')->get('Amount'); ?></th>
					<th><?php echo app('translator')->get('Date'); ?></th>
				  </tr>
			  </thead>
			  <tbody>
				<?php if(count($transactions) == 0): ?>
					<tr>
						<td colspan="12">
							<h4 class="text-center m-0 py-2"><?php echo e(__('No Data Found')); ?></h4>
						</td>
					</tr>
				<?php else: ?>
				<?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				  <?php
					  $from = App\Models\User::where('id',$data->user_id)->first();
				  ?>
					<tr>
						<td data-label="<?php echo app('translator')->get('No'); ?>">
							<div>

							<span class="text-muted"><?php echo e($loop->iteration); ?></span>
							</div>
						</td>

						<td data-label="<?php echo app('translator')->get('Type'); ?>">
							<div>
							<?php echo e(strtoupper($data->type)); ?>

							</div>
						</td>

						<td data-label="<?php echo app('translator')->get('Txnid'); ?>">
							<div>
							<?php echo e($data->txnid); ?>

							</div>
						</td>

						<td data-label="<?php echo app('translator')->get('Amount'); ?>">
							<div>
							<p class="text-<?php echo e($data->profit == 'plus' ? 'success' : 'danger'); ?>"><?php echo e(showPrice($data->amount)); ?></p>
							</div>
						</td>

						<td data-label="<?php echo app('translator')->get('Date'); ?>">
							<div>
							<?php echo e(date('d M Y',strtotime($data->created_at))); ?>

							</div>
						</td>
					</tr>
			 	 <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				<?php endif; ?>
			  </tbody>
		  </table>
	  </div>
	  <?php echo e($transactions->links()); ?>

</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fluxyjvi/public_html/project/resources/views/user/transactions.blade.php ENDPATH**/ ?>