<?php $__env->startPush('css'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('contents'); ?>
<div class="breadcrumb-area">
  <h3 class="title"><?php echo app('translator')->get('Invest'); ?></h3>
  <ul class="breadcrumb">
      <li>
        <a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
      </li>

      <li>
          <?php echo app('translator')->get('Invest'); ?>
      </li>
  </ul>
</div>

<div class="dashboard--content-item">
  <div class="row g-3">
    <div class="col-12">
      <div class="card p-5 default--card">
          <?php if ($__env->exists('includes.flash')) echo $__env->make('includes.flash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
          <?php if($message = Session::get('success')): ?>
              <div class="alert alert-success">
                  <p><?php echo e($message); ?></p>
              </div>
          <?php endif; ?>
          <form id="" method="POST" class="payment-form" action="">
              <?php echo csrf_field(); ?>

              <div class="row gy-3 gy-md-4">
                <div class="col-sm-6">
                  <div class="form-group">
                    <label class="form-label required"><?php echo e(__('User Email')); ?></label>
                    <input name="email" id="accountemail" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" autocomplete="off" placeholder="<?php echo e(__('doe@gmail.com')); ?>" type="email" value="<?php echo e(auth()->user()->email); ?>" readonly>
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                      <p class="text-danger mt-2"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                  </div>
                </div>

                <div class="col-sm-6">
                  <div class="form-group">
                    <label class="form-label required"><?php echo e(__('User Name')); ?></label>
                    <input name="name" id="account_name" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" autocomplete="off" placeholder="<?php echo e(__('Jhon Doe')); ?>" type="text" value="<?php echo e(auth()->user()->name); ?>" readonly>
                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                      <p class="text-danger mt-2"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                  </div>
                </div>

                <div class="col-sm-12">
                    
                </div>

              <div class="col-sm-12">
                <div id="mergado-view" class="col-md-12 d-none">
                    <div class="row gy-3">
                        <div id="cardNumber"></div>
                        <div id="expirationDate"></div>
                        <div id="securityCode"> </div>


                        <div class="form-group pb-2">
                            <input class="form-control mergado-elements" type="text" id="cardholderName" data-checkout="cardholderName"
                                placeholder="<?php echo e(__('Card Holder Name')); ?>" />
                        </div>
                        <div class="form-group py-2">
                            <input class="form-control mergado-elements" type="text" id="docNumber" data-checkout="docNumber"
                                placeholder="<?php echo e(__('Document Number')); ?>" />
                        </div>
                        <div class="form-group py-2">
                            <select id="docType" class="form-control" name="docType" data-checkout="docType" type="text"></select>
                        </div>
                    </div>
                </div>
              </div>

                <div class="col-sm-6">
                  <div class="form-group">
                    <label class="form-label required"><?php echo e(__('Amount')); ?></label>
                    <input name="amount" id="amount" class="form-control <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" autocomplete="off" placeholder="<?php echo e(__('0.0')); ?>" type="number" value="<?php echo e(session('invest_amount')); ?>" min="1" readonly>
                    <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                      <p class="text-danger mt-2"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                  </div>
                </div>

                <div class="col-sm-6">
                  <label class="form-label required"><?php echo e(__('Payment Method')); ?></label>
                  <select id="method" name="method" required class="form-control <?php $__errorArgs = ['method'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                      <option value=""><?php echo e(__('Select Payment Method')); ?></option>
                         <?php $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <?php if($gateway->type == 'manual'): ?>
                              <option value="Manual" data-details="<?php echo e($gateway->details); ?>"><?php echo e($gateway->title); ?></option>
                              <?php else: ?>
                              <option value="<?php echo e($gateway->keyword); ?>"><?php echo e($gateway->name); ?></option>
                          <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </select>
                  <?php $__errorArgs = ['method'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-danger mt-2"><?php echo e($message); ?></p>
                  <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="col-sm-12 mt-4 manual-payment d-none">
                  <div class="card default--card">
                    <div class="card-body">
                      <div class="row">

                        <div class="col-sm-12 pb-2 manual-payment-details">
                        </div>

                        <div class="col-sm-12">
                          <label class="form-label required"><?php echo app('translator')->get('Transaction ID'); ?>#</label>
                          <input class="form-control" name="txn_id4" type="text" placeholder="Transaction ID" id="manual_transaction_id">
                        </div>

                      </div>
                    </div>
                  </div>
              </div>

                <input type="hidden" name="user_id" value="<?php echo e(auth()->id()); ?>">
                <input type="hidden" name="plan_id" value="<?php echo e(session('investPlanId')); ?>">
                <input type="hidden" name="currency_sign" value="<?php echo e($defaultCurrency->sign); ?>">
                <input type="hidden" id="currencyCode" name="currency_code" value="<?php echo e($defaultCurrency->name); ?>">
                <input type="hidden" name="currency_id" value="<?php echo e($defaultCurrency->id); ?>">
                <input type="hidden" name="paystackInfo" id="paystackInfo" value="<?php echo e($paystackKey); ?>">

                <div class="col-sm-12">
                  <label class="form-label d-none d-sm-block">&nbsp;</label>
                  <button type="submit" class="cmn--btn bg--primary submit-btn w-100 border-0"><?php echo e(__('Submit')); ?></button>

                </div>
              </div>

          </form>
      </div>
  </div>
  </div>
</div>

<div class="dashboard--content-item">
    <div class="table-responsive table--mobile-lg">
        <table class="table bg--body">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get('Transaction'); ?></th>
                    <th><?php echo app('translator')->get('Method'); ?></th>
                    <th><?php echo app('translator')->get('Plan'); ?></th>
                    <th><?php echo app('translator')->get('Profit Amount'); ?></th>
                    <th><?php echo app('translator')->get('Status'); ?></th>
                    <th><?php echo app('translator')->get('Next Profit'); ?></th>
                </tr>
            </thead>
            <tbody>
              <?php if(count($invests) == 0): ?>
                <tr>
                  <td colspan="12">
                    <h4 class="text-center m-0 py-2"><?php echo e(__('No Data Found')); ?></h4>
                  </td>
                </tr>
                <?php else: ?>
                  <?php $__currentLoopData = $invests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td data-label="Transaction">
                          <div>
                            <?php echo e(strtoupper($data->transaction_no)); ?>

                          </div>
                        </td>

                        <td data-label="Method">
                          <div>
                            <?php echo e(strtoupper($data->method)); ?>

                          </div>
                        </td>

                        <td data-label="Plan">
                          <div>
                            <?php echo e($data->plan->title); ?>

                            <br>
                            <?php echo e(showPrice($data->amount)); ?>

                          </div>
                        </td>

                        <td data-label="Profit Amount">
                          <div>
                            <?php echo e(showPrice($data->profit)); ?>

                          </div>
                        </td>

                        <?php if($data->status == 0): ?>
                          <td data-label="Status">
                            <div>
                                <span class="badge btn--warning btn-sm"><?php echo app('translator')->get('pending'); ?></span>
                            </div>
                          </td>
                        <?php elseif($data->status == 1): ?>
                          <td data-label="Status">
                            <div>
                                <span class="badge btn--info btn-sm"><?php echo app('translator')->get('running'); ?></span>
                            </div>
                          </td>
                        <?php else: ?>
                          <td data-label="Status">
                            <div>
                                <span class="badge btn--success btn-sm"><?php echo app('translator')->get('completed'); ?></span>
                            </div>
                          </td>
                        <?php endif; ?>

                        <?php if($data->status == 0): ?>
                          <td data-label="Next Profit">
                            <div>
                                <?php echo app('translator')->get('N/A'); ?>
                            </div>
                          </td>
                        <?php elseif($data->status == 1): ?>
                          <td data-label="Next Profit" class="countdown" data-date="<?php echo e(Carbon\Carbon::parse($data->profit_time)->format('M d,Y h:i:s')); ?>"></td>
                        <?php else: ?>
                          <td data-label="Next Profit">
                            <div>
                              <span class="badge btn--danger btn-sm"><?php echo app('translator')->get('closed'); ?></span>
                            </div>
                          </td>
                        <?php endif; ?>

                    </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>


<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script type="text/javascript">
  'use strict';

  $(document).on('change','#method',function(){
      var val = $(this).val();

      if(val == 'stripe')
      {
        $('.payment-form').prop('action','<?php echo e(route('checkout.stripe.submit')); ?>');
        
        $('.card-elements').prop('required',true);
        $('#mergado-view').addClass('d-none');
        $('.mergado-elements').prop('required',false);
        $('.payment-form').prop('id','');
        $('#manual_transaction_id').prop('required',false);
        $('.manual-payment').addClass('d-none');
      }

      if(val == 'skrill'){
        $('.payment-form').prop('action','<?php echo e(route('checkout.skrill.submit')); ?>');
        $('#card-view').addClass('d-none');
        $('.card-elements').prop('required',false);
        $('#mergado-view').addClass('d-none');
        $('.mergado-elements').prop('required',false);
        $('.payment-form').prop('id','');
        $('#manual_transaction_id').prop('required',false);
        $('.manual-payment').addClass('d-none');
      }

      if(val == 'payeer'){
        $('.payment-form').prop('action','<?php echo e(route('checkout.payeer.submit')); ?>');
        $('#card-view').addClass('d-none');
        $('.card-elements').prop('required',false);
        $('#mergado-view').addClass('d-none');
        $('.mergado-elements').prop('required',false);
        $('.payment-form').prop('id','');
        $('#manual_transaction_id').prop('required',false);
        $('.manual-payment').addClass('d-none');
      }

      if(val == 'mercadopago')
      {
        $('.payment-form').prop('action','<?php echo e(route('checkout.mercadopago.submit')); ?>');
        $('#card-view').addClass('d-none');
        $('.card-elements').prop('required',false);
        $('.mergado-elements').prop('required',false);
        $('#mergado-view').removeClass('d-none');
        $('.payment-form').prop('id','mercadopago');
        $('#manual_transaction_id').prop('required',false);
        $('.manual-payment').addClass('d-none');
      }

      if(val == 'authorize.net')
      {
        $('.payment-form').prop('action','<?php echo e(route('checkout.authorize.submit')); ?>');
        $('#card-view').removeClass('d-none');
        $('.card-elements').prop('required',true);
        $('#mergado-view').addClass('d-none');
        $('.mergado-elements').prop('required',false);
        $('.payment-form').prop('id','');
        $('#manual_transaction_id').prop('required',false);
        $('.manual-payment').addClass('d-none');
      }

      if(val == 'paypal') {
        $('.payment-form').prop('action','<?php echo e(route('checkout.paypal.submit')); ?>');
        $('#card-view').addClass('d-none');
        $('.card-elements').prop('required',false);
        $('#mergado-view').addClass('d-none');
        $('.mergado-elements').prop('required',false);
        $('.payment-form').prop('id','');
        $('#manual_transaction_id').prop('required',false);
        $('.manual-payment').addClass('d-none');
      }

      if(val == 'perfectmoney') {
        $('.payment-form').prop('action','<?php echo e(route('checkout.perfectmoney.submit')); ?>');
        $('#card-view').addClass('d-none');
        $('.card-elements').prop('required',false);
        $('#mergado-view').addClass('d-none');
        $('.mergado-elements').prop('required',false);
        $('.payment-form').prop('id','');
        $('#manual_transaction_id').prop('required',false);
        $('.manual-payment').addClass('d-none');
      }

      if(val == 'mollie') {
        $('.payment-form').prop('action','<?php echo e(route('checkout.molly.submit')); ?>');
        $('#card-view').addClass('d-none');
        $('.card-elements').prop('required',false);
        $('#mergado-view').addClass('d-none');
        $('.mergado-elements').prop('required',false);
        $('.payment-form').prop('id','');
        $('#manual_transaction_id').prop('required',false);
        $('.manual-payment').addClass('d-none');
      }

      if(val == 'flutterwave') {
        $('.payment-form').prop('action','<?php echo e(route('checkout.flutter.submit')); ?>');
        $('#card-view').addClass('d-none');
        $('.card-elements').prop('required',false);
        $('#mergado-view').addClass('d-none');
        $('.mergado-elements').prop('required',false);
        $('.payment-form').prop('id','');
        $('#manual_transaction_id').prop('required',false);
        $('.manual-payment').addClass('d-none');
      }


      if(val == 'paytm') {
        $('.payment-form').prop('action','<?php echo e(route('checkout.paytm.submit')); ?>');
        $('#card-view').addClass('d-none');
        $('.card-elements').prop('required',false);
        $('#mergado-view').addClass('d-none');
        $('.mergado-elements').prop('required',false);
        $('.payment-form').prop('id','');
        $('#manual_transaction_id').prop('required',false);
        $('.manual-payment').addClass('d-none');
      }

      if(val == 'instamojo') {
        $('.payment-form').prop('action','<?php echo e(route('checkout.instamojo.submit')); ?>');
        $('#card-view').addClass('d-none');
        $('.card-elements').prop('required',false);
        $('#mergado-view').addClass('d-none');
        $('.mergado-elements').prop('required',false);
        $('.payment-form').prop('id','');
        $('#manual_transaction_id').prop('required',false);
        $('.manual-payment').addClass('d-none');
      }

      if(val == 'paystack') {
        $('.payment-form').prop('action','<?php echo e(route('checkout.paystack.submit')); ?>');
		$('.payment-form').prop('id','step1-form');
        $('#card-view').addClass('d-none');
        $('.card-elements').prop('required',false);
        $('#mergado-view').addClass('d-none');
        $('.mergado-elements').prop('required',false);
        $('#manual_transaction_id').prop('required',false);
        $('.manual-payment').addClass('d-none');
    }

      if(val == 'coinpayment') {
        $('.payment-form').prop('action','<?php echo e(route('checkout.coinpay.submit')); ?>');
        $('#card-view').addClass('d-none');
        $('.card-elements').prop('required',false);
        $('#mergado-view').addClass('d-none');
        $('.mergado-elements').prop('required',false);
        $('.payment-form').prop('id','');
        $('#manual_transaction_id').prop('required',false);
        $('.manual-payment').addClass('d-none');
      }

      if(val == 'coingate') {
        $('.payment-form').prop('action','<?php echo e(route('checkout.coingate.submit')); ?>');
        $('#card-view').addClass('d-none');
        $('.card-elements').prop('required',false);
        $('#mergado-view').addClass('d-none');
        $('.mergado-elements').prop('required',false);
        $('.payment-form').prop('id','');
        $('#manual_transaction_id').prop('required',false);
        $('.manual-payment').addClass('d-none');
      }

      if(val == 'razorpay') {
          $('.payment-form').prop('action','<?php echo e(route('checkout.razorpay.submit')); ?>');
          $('#card-view').addClass('d-none');
          $('.card-elements').prop('required',false);
          $('#mergado-view').addClass('d-none');
          $('.mergado-elements').prop('required',false);
          $('.payment-form').prop('id','');
          $('#manual_transaction_id').prop('required',false);
          $('.manual-payment').addClass('d-none');
      }

      if(val == 'block.io.btc' || val == 'block.io.ltc' || val == 'block.io.dgc') {
        $('.payment-form').prop('action','<?php echo e(route('checkout.blockio.submit')); ?>');
        $('#card-view').addClass('d-none');
        $('.card-elements').prop('required',false);
        $('.payment-form').prop('id','');
        $('#manual_transaction_id').prop('required',false);
        $('.manual-payment').addClass('d-none');
    }

      if(val == 'Manual'){
      $('.payment-form').prop('action','<?php echo e(route('checkout.manual.submit')); ?>');
      $('.manual-payment').removeClass('d-none');
      $('#card-view').addClass('d-none');
      $('.card-elements').prop('required',false);
      $('#mergado-view').addClass('d-none');
      $('.mergado-elements').prop('required',false);
      $('.payment-form').prop('id','');
      $('#manual_transaction_id').prop('required',true);
      const details = $(this).find(':selected').data('details');
      $('.manual-payment-details').empty();
      $('.manual-payment-details').append(`<font size="3">${details}</font>`)
    }
  });

  </script>



  <script>
     closedFunction=function() {
          alert('Payment Cancelled!');
      }

      successFunction=function(transaction_id) {
          window.location.href = '<?php echo e(url('order/payment/return')); ?>?txn_id=' + transaction_id;
      }

      failedFunction=function(transaction_id) {
          alert('Transaction was not successful, Ref: '+transaction_id)
      }
  </script>

  <script>
      'use strict';

    $(document).on('submit','#step1-form',function(e){
      e.preventDefault();

        var total = parseFloat( $('#amount').val());
        var paystackInfo = $("#paystackInfo").val();
        var curr = $('#currencyCode').val();

        total = Math.round(total);

            var handler = PaystackPop.setup({
              key: paystackInfo,
              email: $('input[name=email]').val(),
              amount: total * 100,
              currency: curr,
              ref: ''+Math.floor((Math.random() * 1000000000) + 1),
              callback: function(response){
                $('#ref_id').val(response.reference);
                $('#step1-form').prop('id','');
                $('.payment-form').submit();
              },
              onClose: function(){
                window.location.reload();
              }
            });
            handler.openIframe();
                return false;


    });
  </script>



<script type="text/javascript">
  'use strict';

  var cnstatus = false;
  var dateStatus = false;
  var cvcStatus = false;

  function validateCard(cn) {
    cnstatus = Stripe.card.validateCardNumber(cn);
    if (!cnstatus) {
      $("#errCard").html('Card number not valid<br>');
    } else {
      $("#errCard").html('');
    }
    btnStatusChange();


  }

  function validateCVC(cvc) {
    cvcStatus = Stripe.card.validateCVC(cvc);
    if (!cvcStatus) {
      $("#errCVC").html('CVC number not valid');
    } else {
      $("#errCVC").html('');
    }
    btnStatusChange();
  }

</script>



<script type="text/javascript">
	'use strict';

	$('.countdown').each(function(){
		var date = $(this).data('date');
		var countDownDate = new Date(date).getTime();
		var $this = $(this);
		var x = setInterval(function() {
		  var now = new Date().getTime();
		  var distance = countDownDate - now;

		  var days = Math.floor(distance / (1000 * 60 * 60 * 24));
		  var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
		  var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
		  var seconds = Math.floor((distance % (1000 * 60)) / 1000);

		  var text = days + "d " + hours + "h "
		  + minutes + "m " + seconds + "s ";
		  $this.html(text);

		  if (distance < 0) {
		    clearInterval(x);
		   var text = 0 + "d " + 0 + "h "
		  + 0 + "m " + 0 + "s ";
		  $this.html(text);
		  }
		}, 1000);
	});

</script>

<script type="text/javascript" src="<?php echo e(asset('assets/front/js/payvalid.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('assets/front/js/paymin.js')); ?>"></script>
<script type="text/javascript" src="https://js.stripe.com/v3/"></script>
<script type="text/javascript" src="<?php echo e(asset('assets/front/js/payform.js')); ?>"></script>
<script src="https://js.paystack.co/v1/inline.js"></script>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        const manualPaymentSection = document.querySelector(".manual-payment");
        const transactionInput = document.getElementById("manual_transaction_id");

        // Function to generate random transaction ID
        function generateTransactionID(prefix = "TXN") {
            const timestamp = Date.now(); // milliseconds since epoch
            const randomPart = Math.floor(1000 + Math.random() * 9000); // random 4-digit number
            //return `${prefix}-${timestamp}-${randomPart}
            return `${prefix}-${timestamp}`;
        }

        // MutationObserver or simple trigger depending on how the section is shown
        const methodSelect = document.getElementById("method");
        methodSelect.addEventListener("change", function () {
            const selected = methodSelect.options[methodSelect.selectedIndex].value;

            if (selected === "Manual") {
                // Only generate once if empty
                if (!transactionInput.value) {
                    transactionInput.value = generateTransactionID();
                }

                // Optionally, reveal the section (if your app doesn't handle that yet)
                manualPaymentSection.classList.remove("d-none");
            } else {
                transactionInput.value = "";
                manualPaymentSection.classList.add("d-none");
            }
        });
    });
</script>



    <script src="https://sdk.mercadopago.com/js/v2"></script>
    <script>
        const mp = new MercadoPago("<?php echo e($mercadoKey); ?>");

        const cardNumberElement = mp.fields.create('cardNumber', {
            placeholder: "Card Number"
        }).mount('cardNumber');

        const expirationDateElement = mp.fields.create('expirationDate', {
            placeholder: "MM/YY",
        }).mount('expirationDate');

        const securityCodeElement = mp.fields.create('securityCode', {
            placeholder: "Security Code"
        }).mount('securityCode');


        (async function getIdentificationTypes() {
            try {
                const identificationTypes = await mp.getIdentificationTypes();

                const identificationTypeElement = document.getElementById('docType');

                createSelectOptions(identificationTypeElement, identificationTypes);

            } catch (e) {
                return console.error('Error getting identificationTypes: ', e);
            }
        })();

        function createSelectOptions(elem, options, labelsAndKeys = {
            label: "name",
            value: "id"
        }) {

            const {
                label,
                value
            } = labelsAndKeys;

            const tempOptions = document.createDocumentFragment();

            options.forEach(option => {
                const optValue = option[value];
                const optLabel = option[label];

                const opt = document.createElement('option');
                opt.value = optValue;
                opt.textContent = optLabel;


                tempOptions.appendChild(opt);
            });

            elem.appendChild(tempOptions);
        }
        cardNumberElement.on('binChange', getPaymentMethods);
        async function getPaymentMethods(data) {
            const {
                bin
            } = data
            const {
                results
            } = await mp.getPaymentMethods({
                bin
            });
            console.log(results);
            return results[0];
        }

        async function getIssuers(paymentMethodId, bin) {
            const issuears = await mp.getIssuers({
                paymentMethodId,
                bin
            });
            console.log(issuers)
            return issuers;
        };

        async function getInstallments(paymentMethodId, bin) {
            const installments = await mp.getInstallments({
                amount: document.getElementById('transactionAmount').value,
                bin,
                paymentTypeId: 'credit_card'
            });

        };

        async function createCardToken() {
            const token = await mp.fields.createCardToken({
                cardholderName,
                identificationType,
                identificationNumber,
            });

        }
        let doSubmit = false;
        $(document).on('submit', '#mercadopago', function(e) {
            getCardToken();
            e.preventDefault();
        });
        async function getCardToken() {
            if (!doSubmit) {
                let $form = document.getElementById('mercadopago');
                const token = await mp.fields.createCardToken({
                    cardholderName: document.getElementById('cardholderName').value,
                    identificationType: document.getElementById('docType').value,
                    identificationNumber: document.getElementById('docNumber').value,
                })
                setCardTokenAndPay(token.id)
            }
        };

        function setCardTokenAndPay(token) {
            let form = document.getElementById('mercadopago');
            let card = document.createElement('input');
            card.setAttribute('name', 'token');
            card.setAttribute('type', 'hidden');
            card.setAttribute('value', token);
            form.appendChild(card);
            doSubmit = true;
            form.submit();
        };
    </script>


<?php $__env->stopPush(); ?>




<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fluxyjvi/public_html/project/resources/views/user/invest/create.blade.php ENDPATH**/ ?>