

<?php $__env->startPush('css'); ?>
    
<?php $__env->stopPush(); ?>

<?php $__env->startSection('contents'); ?>
<div class="breadcrumb-area">
  <h3 class="title"><?php echo app('translator')->get('Request Money'); ?></h3>
  <ul class="breadcrumb">
      <li>
        <a href="<?php echo e(route('user.dashboard')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
      </li>

      <li>
          <?php echo app('translator')->get('Request Money'); ?>
      </li>
  </ul>
</div>

<div class="dashboard--content-item">
  <div class="row g-3">
    <div class="col-12">
      <div class="card default--card">
        <div class="card-body">
            <?php if ($__env->exists('includes.flash')) echo $__env->make('includes.flash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <form id="request-form" action="<?php echo e(route('user.money.request.store')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>

                <div class="row gy-3 gy-md-4">
                  <div class="col-sm-12">
                    <div class="form-group">
                      <label class="form-label required"><?php echo e(__('Receiver Email')); ?></label>
                      <input name="email" id="accountemail" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" autocomplete="off" placeholder="<?php echo e(__('doe@gmail.com')); ?>" type="email" value="<?php echo e(old('email')); ?>">
                      <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-danger mt-2"><?php echo e($message); ?></p>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                    </div>
                  </div>

                  <div class="col-sm-12">
                    <div class="form-group">
                      <label class="form-label required"><?php echo e(__('Account Name')); ?></label>
                      <input name="name" id="account_name" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" autocomplete="off" placeholder="<?php echo e(__('Jhon Doe')); ?>" type="text" value="<?php echo e(old('name')); ?>" readonly>
                      <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-danger mt-2"><?php echo e($message); ?></p>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                  </div>

                  <div class="col-sm-12">
                    <div class="form-group">
                      <label class="form-label required"><?php echo e(__('Amount')); ?></label>
                      <input name="amount" id="amount" class="form-control <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" autocomplete="off" placeholder="<?php echo e(__('0.0')); ?>" type="number" value="<?php echo e(old('amount')); ?>" min="1">
                      <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="text-danger mt-2"><?php echo e($message); ?></p>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                  </div>

                  <div class="col-sm-12">
                    <div class="form-group">
                        <label class="form-label"><?php echo e(__('Description')); ?></label>
                        <textarea name="details" class="form-control nic-edit" cols="30" rows="5" placeholder="<?php echo e(__('Receive account details')); ?>"></textarea>
                    </div>
                </div>

                  <div class="col-sm-12">
                    <label class="form-label d-none d-sm-block">&nbsp;</label>
                    <button type="submit" class="cmn--btn bg--primary submit-btn w-100 border-0"><?php echo e(__('Submit')); ?></button>

                  </div>
                </div>

            </form>
        </div>
      </div>
  </div>
  </div>
</div>

<div class="dashboard--content-item">
    <div class="table-responsive table--mobile-lg">
        <table class="table bg--body">
            <thead>
                <tr>
                  <th><?php echo e(__('Date')); ?></th>
                  <th><?php echo e(__('Sender')); ?></th>
                  <th><?php echo e(__('Amount')); ?></th>
                  <th><?php echo e(__('Receiver')); ?></th>
                  <th><?php echo e(__('Status')); ?></th>
                  <th><?php echo e(__('Details')); ?></th>
                </tr>
            </thead>
            <tbody>
              <?php if(count($requests) == 0): ?>
                <tr>
                  <td colspan="12">
                    <h4 class="text-center m-0 py-2"><?php echo e(__('No Data Found')); ?></h4>
                  </td>
                </tr>
                <?php else: ?>
                <?php $__currentLoopData = $requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                      <td data-label="<?php echo e(__('Date')); ?>">
                        <div>
                          <?php echo e($data->created_at->toFormattedDateString()); ?>

                        </div>
                      </td>
                      <td data-label="<?php echo e(__('Sender')); ?>">
                        <div>
                          <?php echo e(auth()->user()->name); ?>

                        </div>
                      </td>
                      <td data-label="<?php echo e(__('Amount')); ?>">
                        <div>
                          <?php echo e(showprice($data->amount,$currency)); ?>

                        </div>
                      </td>
                      <td data-label="<?php echo e(__('Receiver')); ?>">
                        <div>
                          <?php echo e($data->receiver_name); ?>

                        </div>
                      </td>
                      <td data-label="<?php echo e(__('Status')); ?>">
                        <div>
                          <span class="badge bg-<?php echo e($data->status == 1 ? 'success' : 'warning'); ?>"><?php echo e($data->status == 1 ? 'completed' : 'pending'); ?></span>
                        </div>
                      </td>

                      <td data-label="<?php echo e(__('Details')); ?>">
                        <div class="btn-list">
                            <a href="<?php echo e(route('user.money.request.details',$data->id)); ?>" class="btn btn-primary">
                              <?php echo e(__('Details')); ?>

                            </a>
                        </div>
                      </td>
                  </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php endif; ?>
            </tbody>
        </table>
    </div>
    <?php echo e($requests->links()); ?>

</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script>
  'use strict';
  
  $("#account_name").on('click',function(){
    let accountEmail = $("#accountemail").val();
    
    let url = `${mainurl}/user/username/${accountEmail}`;

    $.get(url, function(data){
      $("#account_name").val(data);
    });
  })
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fluxyjvi/public_html/project/resources/views/user/requestmoney/create.blade.php ENDPATH**/ ?>