<?php $__env->startPush('css'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

    <?php if(in_array('Banner', $home_modules)): ?>
        <!-- Banner -->
        <section class="banner-section bg--gradient overflow-hidden">
            <div class="particle"></div>
            <div class="particle2"></div>
            <div class="particle3"></div>
            <div class="particle4"></div>
            <div class="banner-bg bg_img" data-img="<?php echo e(asset('assets/images/'.$ps->hero_photo)); ?>">
                <div class="container">
                    <div class="banner-wrapper">
                        <div class="banner-cont text--light">
                            <h1 class="title text--base"><?php echo e($ps->hero_title); ?></h1>
                            <p>
                                <?php echo e($ps->hero_subtitle); ?>

                            </p>
                            <div class="btn__grp">
                                <a href="<?php echo e($ps->hero_btn_url); ?>" class="cmn--btn"><?php echo app('translator')->get('Start Investing Today'); ?> <span class="round-effect">
                                        <i class="fas fa-long-arrow-alt-right"></i>
                                    </span></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Banner -->
    <?php endif; ?>

    <?php if(in_array('About', $home_modules)): ?>
        <!-- About -->
        <section class="about-section overflow-hidden pt-100 pb-100 position-relative">
            <div class="container">
                <div class="row gy-4 gy-sm-5 flex-wrap-reverse align-items-center">
                    <div class="col-lg-6">
                        <div class="about--img">
                            <img src="<?php echo e(asset('assets/images/'.$ps->about_photo)); ?>" alt="about us">
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="about--content">
                            <div class="section-header mb-4">
                                <h6 class="section-header__subtitle"><?php echo app('translator')->get('Who We are'); ?></h6>
                                <h3 class="section-header__title"><?php echo e($ps->about_title); ?></h3>

                            </div>
                            <p class="about-txt m-0 mb-4">
                                <?php
                                    echo $ps->about_text;
                                ?>
                            </p>
                            <a href="<?php echo e($ps->about_link); ?>" class="cmn--btn"><?php echo app('translator')->get('Read More'); ?>
                                <span class="round-effect">
                                    <i class="fas fa-long-arrow-alt-right"></i>
                                </span>
                            </a>
                        </div>
                        <div class="border-top mt-4">
                            <div class="counter-area">
                                <?php $__currentLoopData = $counters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="counter-item">
                                        <div class="counter-thumb">
                                            <img src="<?php echo e(asset('assets/images/'.$data->photo)); ?>" alt="about">
                                        </div>
                                        <div class="counter-content">
                                            <div class="counter-header">
                                                <h4 class="title odometer" data-odometer-final="<?php echo e($data->count); ?>">0</h4>
                                                <h4 class="title"><?php echo e($data->messurement); ?></h4>
                                            </div>
                                            <h6 class="text--base"><?php echo e($data->title); ?></h6>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- / About -->
    <?php endif; ?>

    <?php if(in_array('Profit Calculator', $home_modules)): ?>
        <!-- Profit Calculator -->
        <section class="profit-calculator pt-100 pb-100 bg--shapes overflow-hidden">
            <div class="container position-relative">
                <div class="row align-items-center">
                    <div class="col-lg-6">
                        <div class="profit-thumb">
                            <img src="<?php echo e(asset('assets/images/'.$ps->profit_banner)); ?>" alt="profit">
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="profit-calculator-area">
                            <div class="section-header text-lg-start">
                                <h6 class="section-header__subtitle"><?php echo app('translator')->get('Profit Calculator'); ?></h6>
                                <h3 class="section-header__title"><?php echo e($ps->profit_title); ?></h3>
                                <p>
                                <?php
                                    echo $ps->profit_text;
                                ?>
                                </p>
                            </div>
                            <form id="profitCalculate" class="row gy-4" action="<?php echo e(route('front.profit.calculate')); ?>" method="POST">
                                <?php if ($__env->exists('includes.user.form-both')) echo $__env->make('includes.user.form-both', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php echo csrf_field(); ?>
                                <div class="col-md-6">
                                    <label for="select-plan" class="form-label"><?php echo app('translator')->get('Select Plan'); ?></label>
                                    <select name="plan" id="select-plan" class="form-control form--control bg--section">
                                        <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($data->id); ?>"><?php echo e($data->title); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label for="amount" class="form-label"><?php echo app('translator')->get('Enter Amount'); ?></label>
                                    <input type="number" name="amount" class="form-control form--control bg--section" placeholder="0.00">
                                </div>
                                <div class="col-md-12">
                                    <label for="profit-amount" class="form-label"><?php echo app('translator')->get('Profit Amount'); ?></label>
                                    <input type="text" class="form-control form--control bg--section profitCalBoxAmount" id="profit-calculate-amount"
                                        value="0.00" readonly>
                                </div>
                                <div class="col-md-12">
                                    <button class="cmn--btn" type="submit"><?php echo app('translator')->get('Calculate Now'); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- / Profit Calculator -->
    <?php endif; ?>


    <?php if(in_array('Investment Plan', $home_modules)): ?>
        <!-- Investment Plan -->
        <section class="investment-plan-section overflow-hidden bg--gradient-light pb-50 pt-80 border-top">
            <div class="container">
                <div class="section-header text-center">
                    <h6 class="section-header__subtitle"><?php echo app('translator')->get('Investment Plans & Pricing'); ?></h6>
                    <h3 class="section-header__title"><?php echo e($ps->plan_title); ?></h3>
                    <p>
                        <?php echo e('Choose from flexible investment packages designed to match your financial goals — whether you are starting small or scaling big.'); ?>

                    </p>
                </div>
                <div class="pricing--wrapper row g-3 g-md-4 g-lg-3 g-xxl-4 justify-content-center">
                    <?php $__currentLoopData = $plans->take(4); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $schedule = \App\Models\ManageSchedule::where('time',$data->schedule_hour)->first();
                    ?>
                        <div class="col-lg-3 col-sm-6 col-md-6">
                            <div class="plan__item">
                                <div class="plan__item-header">
                                    <div class="left">
                                        <h5 class="title"><?php echo e($data->title); ?></h5>
                                        <span><?php echo e($data->subtitle); ?></span>
                                    </div>
                                    <div class="right">
                                        <h5 class="title"><?php echo e($data->profit_percentage); ?>%</h5>
                                        <span><?php echo app('translator')->get('Return'); ?></span>
                                    </div>
                                </div>
                                <div class="plan__item-body">
                                    <ul>
                                        <li>
                                            <span class="name"><?php echo app('translator')->get('Profit'); ?></span>
                                            <span class="info">
                                                <?php echo e($data->lifetime_return == 1 ? 'Lifetime' :  'Every '.$schedule->name); ?>

                                            </span>
                                        </li>

                                        <li>
                                            <span class="name me-1"><?php echo app('translator')->get('Capital will back'); ?></span>
                                            <span class="badge align-self-center me-auto bg--<?php echo e($data->captial_return == 1 ? 'primary' : 'danger'); ?>"><?php echo e($data->captial_return == 1 ? 'Yes' : 'No'); ?></span>
                                        </li>

                                        <li>
                                            <span class="name <?php echo e($data->profit_repeat == NULL ?? me-1); ?>"><?php echo app('translator')->get('Repeatable'); ?></span>
                                            <?php if($data->profit_repeat == NULL): ?>
                                                <span class="badge align-self-center me-auto bg--danger"><?php echo app('translator')->get('NO'); ?></span>
                                            <?php else: ?>
                                                <span class="info">
                                                    <?php echo e($data->profit_repeat.' Times'); ?>

                                                </span>
                                            <?php endif; ?>
                                        </li>
                                    </ul>

                                    <?php if($data->invest_type == 'range'): ?>
                                        <h6 class="text-center amount-range"><?php echo e(showPrice($data->min_amount)); ?> - <?php echo e(showPrice($data->max_amount)); ?></h6>
                                    <?php else: ?>
                                        <h6 class="text-center amount-range"><?php echo e(showPrice($data->fixed_amount)); ?></h6>
                                    <?php endif; ?>
                                    
                                    <?php if(auth()->user()): ?>
                                    <button class="cmn--btn w-100 invest-plan" type="button" data-bs-toggle="modal"
                                        data-bs-target="#invest-modal" data-title="<?php echo e($data->title); ?>" data-id="<?php echo e($data->id); ?>" data-type="<?php echo e($data->invest_type == 'range' ? 0 : 1); ?>" data-fixAmount="<?php echo e(rootPrice($data->fixed_amount)); ?>">
                                        <?php echo app('translator')->get('Invest Now'); ?>
                                    </button>
                                    <?php else: ?>
                                    <a class="cmn--btn w-100 invest-plan" href="<?php echo e(route('user.login')); ?>" >
                                        <?php echo app('translator')->get('Invest Now'); ?>
                                    </a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="text-center mt-5">
                    <a href="<?php echo e(route('front.plans')); ?>" class="cmn--btn btn-outline"><?php echo app('translator')->get('All Packages'); ?></a>
                </div>
            </div>
        </section>
        <!-- / Investment Plan -->
    <?php endif; ?>


    <?php if(in_array('How To Start', $home_modules)): ?>
        <!-- How To Start -->
        <section class="how-to-start-section pt-80 pb-50 border-top border-bottom overflow-hidden">
            <div class="container">
                <div class="row align-items-center flex-wrap-reverse gy-5">
                    <div class="col-lg-6">
                        <div class="pe-xl-4 pe-xxl-5">
                            <div class="section-header text-lg-end">
                                <h6 class="section-header__subtitle"><?php echo app('translator')->get('How To Get Started'); ?></h6>
                                <h3 class="section-header__title"><?php echo e($ps->start_title); ?></h3>
                                <p>
                                    <?php
                                        echo $ps->start_text;
                                    ?>
                                </p>
                            </div>
                            <div class="how-wrapper">
                                <?php $__currentLoopData = $process; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="how__item">
                                        <div class="how__item-thumb">
                                            <i class="<?php echo e($data->icon); ?>"></i>
                                        </div>
                                        <div class="how__item-content">
                                            <h5 class="how__item-title text--base">
                                                <?php echo e($data->title); ?>

                                            </h5>
                                            <p>
                                            <?php
                                                echo $data->details;
                                            ?>
                                            </p>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="how-thumb">
                            <img src="<?php echo e(asset('assets/images/'.$ps->start_photo)); ?>" alt="about" />
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- How To Start -->
    <?php endif; ?>


    <?php if(in_array('Choose', $home_modules)): ?>
        <!-- Choose -->
        <?php if ($__env->exists('partials.front.choose')) echo $__env->make('partials.front.choose', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- Choose -->
    <?php endif; ?>

<!-- Referral --
    <?php if(in_array('Referral', $home_modules)): ?>
        <section class="referral-section pt-50 pb-100">
            <div class="container">
                <div class="row align-items-center justify-content-between flex-wrap-reverse">
                    <div class="col-lg-6 col-xl-5">
                        <div class="referral-thumb">
                            <img src="<?php echo e(asset('assets/images/'.$ps->referral_banner)); ?>" alt="about">
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="section-header mb-lg-0">
                            <h6 class="section-header__subtitle"><?php echo app('translator')->get('Referral Comission'); ?></h6>
                            <h2 class="section-header__title"><?php echo e($ps->referral_title); ?></h2>
                            <p>
                                <?php
                                    echo $ps->referral_text;
                                ?>
                            </p>
                            <div class="comission-area">
                                <?php if($ps->referral_percentage): ?>
                                    <?php $__currentLoopData = json_decode($ps->referral_percentage,true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="comission-item">
                                            <div class="thumb">
                                                <?php echo e($data); ?>%
                                            </div>
                                            <div class="cont">
                                                <div class="name"><?php echo app('translator')->get('Level 0'); ?> <?php echo e($key + 1); ?></div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>
                            <a href="#" class="cmn--btn">
                                <?php echo app('translator')->get('Send Referral Link'); ?> <span class="round-effect"><i
                                        class="fas fa-long-arrow-alt-right"></i></span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>
-- Referral -->


    <?php if(in_array('Testimonials', $home_modules)): ?>
        <!-- Testimonials -->
        <section class="testimonial-section pt-100 pb-50 border-top">
            <div class="container">
                <div class="client__slider owl-theme owl-carousel">
                    <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="client__item">
                            <div class="client__item-img">
                                <img src="<?php echo e(asset('assets/images/'.$data->photo)); ?>" alt="clients">
                            </div>
                            <div class="client__item-cont bg--section">
                                <div class="section-header">
                                    <h6 class="section-header__subtitle"><?php echo e($data->title); ?></h6>
                                    <h5 class="section-header__title" style="font-weight: 100 !important;"><?php echo e($data->subtitle); ?></h5>
                                </div>
                                <blockquote class="quote">
                                    <?php
                                        echo $data->details;
                                    ?>
                                </blockquote>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </section>
        <!-- Testimonials -->
    <?php endif; ?>
    
    <section>
        <div style="background-color: #1D2330; border: 1px solid #282E3B; border-radius: 4px; width: 100%; padding: 5px;">
        <!--<h3 style="color: #ffffff; font-family: sans-serif; font-size: 14px; margin-bottom: 5px;">Live Market Trends</h3>-->
        <iframe src="https://widget.coinlib.io/widget?type=horizontal_v2&theme=dark&pref_coin_id=1505&invert_hover=no" width="100%" height="36px" scrolling="auto" frameborder="0" style="border:0;"></iframe>
        </div>
    </section>


<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fluxyjvi/public_html/project/resources/views/frontend/index.blade.php ENDPATH**/ ?>