<?php $__env->startPush('css'); ?>

<?php $__env->stopPush(); ?>

<?php $__env->startSection('contents'); ?>
<div class="breadcrumb-area">
    <h3 class="title"><?php echo app('translator')->get('Invest History'); ?></h3>
    <ul class="breadcrumb">
        <li>
            <a href="<?php echo e(route('user.invest.plans')); ?>"><?php echo app('translator')->get('Plans'); ?></a>
        </li>
        <li>
            <?php echo app('translator')->get('Invest History'); ?>
        </li>
    </ul>
</div>

<div class="dashboard--content-item">
  <div class="card p-3 default--card">
    <form action="<?php echo e(route('user.invest.history')); ?>" method="get">
      <div class="row g-3">
        <div class="col-md-4">
          <input name="trx_no" class="form-control" autocomplete="off" placeholder="<?php echo e(__('Transaction no')); ?>" type="text" value="<?php echo e(old('trx_no')); ?>">
        </div>

        <div class="col-md-4">
          <select id="type" name="type" required class="form-control">
            <option value=""><?php echo e(__('Select Type')); ?></option>
            <option value="all"><?php echo e(__('All')); ?></option>
            <option value="pending"><?php echo e(__('Pending')); ?></option>
            <option value="running"><?php echo e(__('Running')); ?></option>
            <option value="completed"><?php echo e(__('Completed')); ?></option>
          </select>
        </div>

        <div class="col-md-4">
          <button type="submit" class="cmn--btn bg--primary submit-btn w-100 border-0"><?php echo e(__('Submit')); ?></button>
        </div>
      </div>
    </form>
  </div>
</div>

<div class="dashboard--content-item">
    <h5 class="dashboard-title"><?php echo app('translator')->get('Invests'); ?></h5>
    <div class="table-responsive table--mobile-lg">
        <table class="table bg--body">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get('Transaction'); ?></th>
                    <th><?php echo app('translator')->get('Method'); ?></th>
                    <th><?php echo app('translator')->get('Plan'); ?></th>
                    <!-- <th><?php echo app('translator')->get('Method'); ?></th> -->
                    <th><?php echo app('translator')->get('Profit Amount'); ?></th>
                    <th><?php echo app('translator')->get('Status'); ?></th>
                    <th><?php echo app('translator')->get('Next Profit'); ?></th>
                </tr>
            </thead>
            <tbody>
              <?php if(count($invests) == 0): ?>
              <tr>
                <td colspan="12">
                  <h4 class="text-center m-0 py-2"><?php echo e(__('No Data Found')); ?></h4>
                </td>
              </tr>
              <?php else: ?>
                <?php $__currentLoopData = $invests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                      <td data-label="Transaction">
                        <div>
                          <?php echo e(strtoupper($data->transaction_no)); ?>

                        </div>
                      </td>

                      <td data-label="Method">
                        <div>
                          <?php echo e(strtoupper($data->method)); ?>

                        </div>
                      </td>

                      <td data-label="Plan">
                        <div>
                          <?php echo e($data->plan->title); ?>

                          <br>
                          <?php echo e(showPrice($data->amount)); ?>

                        </div>
                      </td>

                      <!-- <td data-label="Method">
                        <div>
                          <?php echo e(ucfirst($data->method)); ?>

                        </div>
                      </td> -->

                      <td data-label="Profit Amount">
                        <div>
                          <?php echo e(showPrice($data->profit)); ?>

                        </div>
                      </td>

                      <?php if($data->status == 0): ?>
                        <td data-label="Status">
                          <div>
                              <span class="badge btn--warning btn-sm"><?php echo app('translator')->get('pending'); ?></span>
                          </div>
                        </td>
                      <?php elseif($data->status == 1): ?>
                        <td data-label="Status">
                          <div>
                              <span class="badge btn--info btn-sm"><?php echo app('translator')->get('running'); ?></span>
                          </div>
                        </td>
                      <?php else: ?>
                        <td data-label="Status">
                          <div>
                              <span class="badge btn--success btn-sm"><?php echo app('translator')->get('completed'); ?></span>
                          </div>
                        </td>
                      <?php endif; ?>

                      <?php if($data->status == 0): ?>
                        <td data-label="Next Profit">
                          <div>
                              <?php echo app('translator')->get('N/A'); ?>
                          </div>
                        </td>
                      <?php elseif($data->status == 1): ?>
                          <td data-label="Next Profit" class="countdown" data-complete="<?php echo e(now()->gt(Carbon\Carbon::parse($data->profit_time)) ? true : false); ?>" data-date="<?php echo e(Carbon\Carbon::parse($data->profit_time)->diffInSeconds()); ?>"></td>
                      <?php else: ?>
                        <td data-label="Next Profit">
                          <div>
                            <span class="badge btn--danger btn-sm"><?php echo app('translator')->get('closed'); ?></span>
                          </div>
                        </td>
                      <?php endif; ?>

                  </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script type="text/javascript">
	'use strict';

	$('.countdown').each(function(){
        var $this = $(this);
        const complete = $(this).data('complete');

        if(!complete){
            var times = $(this).data('date');
            var x = setInterval(function () {
                    var distance = times * 1000;
                    var days = Math.floor(distance / (1000 * 60 * 60 * 24));
                    var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                    var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                    var seconds = Math.floor((distance % (1000 * 60)) / 1000);
                    var text = days + "d: " + hours + "h " + minutes + "m " + seconds + "s ";
                    $this.html(text);
                    if (distance < 0) {
                        clearInterval(x);
                        $this.html("COMPLETE");
                    }
                    times--;
            }, 1000);
        }else{
            $this.html("COMPLETE");
        }
	});

</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fluxyjvi/public_html/project/resources/views/user/invest/history.blade.php ENDPATH**/ ?>