<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />

    <?php if(isset($page->meta_tag) && isset($page->meta_description)): ?>
        <meta name="keywords" content="<?php echo e($page->meta_tag); ?>">
        <meta name="description" content="<?php echo $page->meta_description; ?>">
    <?php elseif(isset($blog->meta_tag) && isset($blog->meta_description)): ?>
        <meta name="keywords" content="<?php echo e($blog->meta_tag); ?>">
        <meta name="description" content="<?php echo $blog->meta_description; ?>">
    <?php else: ?>
        <meta name="keywords" content="<?php echo e($seo->meta_keys); ?>">
        <meta name="author" content="GeniusOcean">
    <?php endif; ?>
    <title><?php echo e($gs->title); ?></title>

    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/bootstrap.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/animate.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/all.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/lightbox.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/odometer.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/owl.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/main.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/toastr.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/styles.php?color='.str_replace('#','',$gs->colors))); ?>">
    <?php if($default_font->font_value): ?>
        <link href="https://fonts.googleapis.com/css?family=<?php echo e($default_font->font_value); ?>&display=swap" rel="stylesheet">
    <?php else: ?>
        <link href="https://fonts.googleapis.com/css?family=Open+Sans&display=swap" rel="stylesheet">
    <?php endif; ?>

    <?php if($default_font->font_family): ?>
        <link rel="stylesheet" id="colorr" href="<?php echo e(asset('assets/front/css/font.php?font_familly='.$default_font->font_family)); ?>">
    <?php else: ?>
        <link rel="stylesheet" id="colorr" href="<?php echo e(asset('assets/front/css/font.php?font_familly='."Open Sans")); ?>">
    <?php endif; ?>

    <link rel="shortcut icon" href="<?php echo e(asset('assets/images/'.$gs->favicon)); ?>">
    <?php echo $__env->yieldPushContent('css'); ?>

    <?php if(!empty($seo->google_analytics)): ?>
	<script>
		window.dataLayer = window.dataLayer || [];
		function gtag() {
				dataLayer.push(arguments);
		}
		gtag('js', new Date());
		gtag('config', '<?php echo e($seo->google_analytics); ?>');
	</script>
	<?php endif; ?>
</head>

<body>
    <!-- Overlayer -->
    <span class="toTopBtn">
        <i class="fas fa-angle-up"></i>
    </span>
    <div class="overlayer"></div>
    <div class="loader"></div>
    <!-- Overlayer -->

    <!-- Header -->
    <header class="bg--gradient">
        <?php if ($__env->exists('partials.front.navbar',compact('sociallinks'))) echo $__env->make('partials.front.navbar',compact('sociallinks'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php if ($__env->exists('partials.front.nav')) echo $__env->make('partials.front.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </header>
    <!-- Header -->

    <?php echo $__env->yieldContent('content'); ?>

    <!-- Footer -->
    <?php echo $__env->make('partials.front.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Footer -->

    


    <!-- Invest Modal -->
    <div class="modal fade" id="invest-modal">
        <div class="modal-dialog">
            <div class="modal-content">
                <form class="investForm" action="<?php echo e(route('user.invest.amount')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body p-4">
                        <h4 class="modal-title text-center plan-title"><?php echo app('translator')->get('Basic Plan'); ?></h4>
                        <div class="pt-3 pb-4">
                            <label for="amount" class="form-label"><?php echo app('translator')->get('Enter Amount'); ?></label>
                            <div class="input-group input--group">
                                <input type="number" name="amount" class="form-group-input form-control form--control bg--section"
                                    placeholder="0.00" id="modalAmount">
                                <button type="button" class="input-group-text"><?php echo app('translator')->get($gs->currency_code); ?></button>
                            </div>

                            <label for="amount" class="form-label"><?php echo app('translator')->get('Select Wallet'); ?></label>
                            <div class="input-group input--group">
                                <select name="wallet" id="investMethod" class="form-control" required>
                                    <option value="checkout"><?php echo e(__('checkout')); ?></option>
                                    <option value="main_wallet"><?php echo e(__('Main Balance')); ?></option>
                                    <option value="interest_wallet"><?php echo e(__('Interest Balance')); ?></option>
                                </select>
                            </div>
                        </div>
                        <input type="hidden" name="investId" id="investId" value="">
                        <div class="d-flex">
                            <button type="button" class="btn shadow-none btn--danger me-2 w-50"
                                data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                            <button type="submit" class="btn shadow-none btn--success w-50"><?php echo app('translator')->get('Proceed'); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Invest Modal -->

    <script src="<?php echo e(asset('assets/front/js/jquery-3.6.0.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/viewport.jquery.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/odometer.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/lightbox.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/owl.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/toastr.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/notify.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/main.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/front/js/custom.js')); ?>"></script>

    <script>
        'use strict';
		let mainurl = '<?php echo e(url('/')); ?>';
        let tawkto = '<?php echo e($gs->is_talkto); ?>';
	</script>


        <script type="text/javascript">
            if(tawkto == 1){
                var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
                (function(){
                    var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
                    s1.async=true;
                    s1.src='https://embed.tawk.to/<?php echo e($gs->talkto); ?>/default';
                    s1.charset='UTF-8';
                    s1.setAttribute('crossorigin','*');
                    s0.parentNode.insertBefore(s1,s0);
                })();
            }
        </script>


    <script>
        'use strict';

        <?php if(Session::has('message')): ?>
        toastr.options =
        {
            "closeButton" : true,
            "progressBar" : true
        }
            toastr.success("<?php echo e(session('message')); ?>");
        <?php endif; ?>

        <?php if(Session::has('error')): ?>
        toastr.options =
        {
            "closeButton" : true,
            "progressBar" : true
        }
            toastr.error("<?php echo e(session('error')); ?>");
        <?php endif; ?>

        <?php if(Session::has('info')): ?>
        toastr.options =
        {
            "closeButton" : true,
            "progressBar" : true
        }
            toastr.info("<?php echo e(session('info')); ?>");
        <?php endif; ?>

        <?php if(Session::has('warning')): ?>
        toastr.options =
        {
            "closeButton" : true,
            "progressBar" : true
        }
            toastr.warning("<?php echo e(session('warning')); ?>");
        <?php endif; ?>
    </script>

    <script>
        'use strict';

        $('.invest-plan').on('click',function(){
            $('#modalAmount').val('');
            $('#modalAmount').prop('readonly',false)

            let id = $(this).data('id');
            let title = $(this).data('title');
            let type = $(this).data('type');

            if(type == 1){
                $('#modalAmount').val($(this).attr('data-fixAmount'));
                $('#modalAmount').prop('readonly',true)
            }
            $('#investId').val(id);
            $('.plan-title').text(title);
        });

        $(document).on('change','#investMethod',function(){
            var val = $(this).val();
            if(val == 'checkout'){
                $('.investForm').prop('action','<?php echo e(route('user.invest.amount')); ?>');
            }

            if(val == 'main_wallet'){
                $('.investForm').prop('action','<?php echo e(route('user.invest.mainWallet')); ?>');
            }

            if(val == 'interest_wallet'){
                $('.investForm').prop('action','<?php echo e(route('user.invest.interestWallet')); ?>');
            }
        });

    </script>
    <?php echo $__env->yieldPushContent('js'); ?>
</body>

</html>
<?php /**PATH /home/fluxyjvi/public_html/project/resources/views/layouts/front.blade.php ENDPATH**/ ?>