@extends('layouts.front')

@push('css')

@endpush

@section('content')
    <!-- Banner -->
    <section class="banner-section bg--gradient overflow-hidden position-relative border-bottom">
        <div class="hero-bg bg_img" data-img="{{ asset('assets/images/'.$gs->breadcumb_banner) }}"></div>
        <div class="container">
            <div class="hero-text">
                <h2 class="hero-text-title">@lang('About US')</h2>
                <ul class="breadcrumb">
                    <li>
                        <a href="{{route('front.index')}}">@lang('Home')</a>
                    </li>
                    <li>
                        @lang('About US')
                    </li>
                </ul>
            </div>
        </div>
        </div>
    </section>
    <!-- Banner -->


    <!-- About -->
    <section class="about-section overflow-hidden pt-100 pb-80 position-relative">
        <div class="container">
            <div class="row gy-4 gy-sm-5 flex-wrap-reverse align-items-center">
                <div class="col-lg-6">
                    <div class="about--img">
                        <img src="{{ asset('assets/images/'.$ps->about_photo) }}" alt="about">
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="about--content">
                        <div class="section-header mb-4">
                            <h6 class="section-header__subtitle">@lang('Who We are')</h6>
                            <h3 class="section-header__title">{{ $ps->about_title }}</h3>
                        </div>
                        <p>{{'Fluxe Assets Ltd. is a forward-thinking investment firm dedicated to providing innovative, diversified, and digitally enabled investment solutions. With a strong presence in both emerging and developed markets, we are committed to helping our clients navigate the evolving global financial landscape with clarity and confidence.'}}</p>
                        <p>{{'Founded on the principles of integrity, insight, and innovation, Fluxe Assets Ltd. partners with individuals, families, and institutions to build, manage, and preserve wealth over the long term. Our investment philosophy is rooted in rigorous research, disciplined risk management, and a deep understanding of our clients’ unique financial goals.'}}</p>
                        <!-- <p class="about-txt m-0 mb-4">
                            @php
                                echo $ps->about_text;
                            @endphp
                        </p> -->
                    </div>
                    <div class="border-top mt-4">
                        <div class="counter-area">
                            @foreach ($counters as $key=>$data)  
                                <div class="counter-item">
                                    <div class="counter-thumb">
                                        <img src="{{asset('assets/images/'.$data->photo)}}" alt="about">
                                    </div>
                                    <div class="counter-content">
                                        <div class="counter-header">
                                            <h4 class="title odometer" data-odometer-final="{{ $data->count }}">0</h4>
                                            <h4 class="title">{{ $data->messurement }}</h4>
                                        </div>
                                        <h6 class="text--base">{{ $data->title }}</h6>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- About -->


    <!-- Mission-Vision -->
    <section class="choose-section pt-30 pb-30 border-top">
        <div class="container">
            <style>
                .card {
                    border-radius: 12px;
                    backdrop-filter: blur(8px); /* Optional: creates a glass effect */
                    background-color: rgba(255, 255, 255, 0.05); /* Transparent light tint */
                    transition: transform 0.3s ease;
                    color: #fff;
                }
            
                .card:hover {
                    transform: translateY(-5px);
                }
            
                .card-title {
                    font-weight: bold;
                }
            
                body {
                    background-color: #121212; /* Optional: dark background for contrast */
                }
            </style>
            <div class="container my-5">
                <div class="section-header mb-4">
                <h3 class="section-header__title text-center">Our Vision & Mission</h3>
                </div>
                <div class="row justify-content-center">
                    <!-- Vision Card -->
                    <div class="col-md-5 mb-4">
                        <div class="card shadow-sm h-100">
                            <div class="card-body">
                                <h5 class="card-title text-primary pb-2">Our Vision</h5>
                                <p class="card-text">
                                    To be a trusted global partner in wealth creation and preservation.
                                </p>
                            </div>
                        </div>
                    </div>
            
                    <!-- Mission Card -->
                    <div class="col-md-5 mb-4">
                        <div class="card shadow-sm h-100">
                            <div class="card-body">
                                <h5 class="card-title text-primary pb-2">Our Mission</h5>
                                <p class="card-text">
                                    To deliver exceptional investment outcomes through innovation, integrity, and client-focused service.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Mission-Vision -->
    
    <!-- Features -->
<section class="choose-section pt-40 pb-0 border-top">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-12">
                <div class="section-header text-center mt-5 mb-0">
                    <!-- <h6 class="section-header__subtitle">@lang('Features')</h6>-->
                    <h3 class="section-header__title">@lang('Our Core Values')</h3>
                </div>
            </div>

            <div class="col-lg-12">
                <div class="choose-area">
                    <div class="choose-inner">
            
                        <!-- Feature Item 1 -->
                        <div class="choose-item">
            
                            <div class="choose-content">
                                <h5 class="choose-content-title">Integrity</h5>
                                <p>
                                    We operate with honesty, accountability, and a commitment to doing what’s right for our clients.
                                </p>
                            </div>
                        </div>
            
                        <!-- Feature Item 2 -->
                        <div class="choose-item">
            
                            <div class="choose-content">
                                <h5 class="choose-content-title">Innovation</h5>
                                <p>
                                    We embrace technology and forward-thinking strategies to stay ahead in a dynamic investment environment.
                                </p>
                            </div>
                        </div>
            
                        <!-- Feature Item 3 -->
                        <div class="choose-item">
                            <div class="choose-content">
                                <h5 class="choose-content-title">Client-Centricity</h5>
                                <p>
                                     Your goals guide our approach. We take time to understand your needs and deliver tailored solutions.
                                </p>
                            </div>
                        </div>
                        
                        <!-- Feature Item 4 -->
                        <div class="choose-item">
            
                            <div class="choose-content">
                                <h5 class="choose-content-title">Trust</h5>
                                <p>
                                      We build enduring relationships based on transparency, responsiveness, and reliability.
                                </p>
                            </div>
                        </div>            
            
                        <!-- Feature Item 5 -->
                        <div class="choose-item">
            
                            <div class="choose-content">
                                <h5 class="choose-content-title">Excellence</h5>
                                <p>
                                      We strive for the highest standards in performance, service, and results.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</section>
    <!-- Features -->    

    <!-- About xxxxxx -->
<!--<section class="choose-section pt-100 pb-50 border-top">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-4">
                <div class="section-header mb-lg-0">
                    <h6 class="section-header__subtitle">@lang('Features')</h6>
                    <h2 class="section-header__title">{{ $ps->feature_title }}</h2>
                    <p>
                        @php
                            echo $ps->feature_text;
                        @endphp
                    </p>
                </div>
            </div>
            <div class="col-lg-8">
                <div class="choose-area bg--section border">
                    <div class="choose-inner">
                        @foreach ($features as $key=>$data)
                            <div class="choose-item">
                                <div class="choose-thumb">
                                    <i class="{{ $data->icon }}"></i>
                                </div>
                                <div class="choose-content">
                                    <h5 class="choose-content-title">{{ $data->title }}</h5>
                                    <p>
                                       @php
                                           echo $data->details;
                                       @endphp
                                    </p>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>-->
    <!-- About xxxxxx -->

    <!-- comment out -->
    @includeIf('partials.front.choose')
    <!-- 
    @includeIf('partials.front.payment') -->
    <!-- comment out -->

@endsection

@push('js')

@endpush